# coding: utf-8
"""
<copyright company="Aspose" file="AddTextOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AddTextOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'data_source' : 'DataSource',
        'file_info' : 'FileInfo',
        'scope_options' : 'ScopeOptions',
        'text' : 'str',
        'select_poistion' : 'str',
        'select_text' : 'str',
        'skip_empty_cells' : 'bool'
    }

    attribute_map = {
        'name' : 'Name' ,
        'data_source' : 'DataSource' ,
        'file_info' : 'FileInfo' ,
        'scope_options' : 'ScopeOptions' ,
        'text' : 'Text' ,
        'select_poistion' : 'SelectPoistion' ,
        'select_text' : 'SelectText' ,
        'skip_empty_cells' : 'SkipEmptyCells' 
    }

    @staticmethod
    def get_swagger_types():
        return AddTextOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return AddTextOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,data_source=None ,file_info=None ,scope_options=None ,text=None ,select_poistion=None ,select_text=None ,skip_empty_cells=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AddTextOptions - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['data_source'] = None 
        self.container['file_info'] = None 
        self.container['scope_options'] = None 
        self.container['text'] = None 
        self.container['select_poistion'] = None 
        self.container['select_text'] = None 
        self.container['skip_empty_cells'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.file_info = file_info
        if 'file_info' in params:
            self.file_info = params["file_info"]


             
        self.scope_options = scope_options
        if 'scope_options' in params:
            self.scope_options = params["scope_options"]


             
        self.text = text
        if 'text' in params:
            self.text = params["text"]


             
        self.select_poistion = select_poistion
        if 'select_poistion' in params:
            self.select_poistion = params["select_poistion"]


             
        self.select_text = select_text
        if 'select_text' in params:
            self.select_text = params["select_text"]


             
        self.skip_empty_cells = skip_empty_cells
        if 'skip_empty_cells' in params:
            self.skip_empty_cells = params["skip_empty_cells"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def file_info(self):
        return self.container['file_info']

    @file_info.setter
    def file_info(self, file_info):
        self.container['file_info'] = file_info 
    @property
    def scope_options(self):
        return self.container['scope_options']

    @scope_options.setter
    def scope_options(self, scope_options):
        self.container['scope_options'] = scope_options 
    @property
    def text(self):
        return self.container['text']

    @text.setter
    def text(self, text):
        self.container['text'] = text 
    @property
    def select_poistion(self):
        return self.container['select_poistion']

    @select_poistion.setter
    def select_poistion(self, select_poistion):
        self.container['select_poistion'] = select_poistion 
    @property
    def select_text(self):
        return self.container['select_text']

    @select_text.setter
    def select_text(self, select_text):
        self.container['select_text'] = select_text 
    @property
    def skip_empty_cells(self):
        return self.container['skip_empty_cells']

    @skip_empty_cells.setter
    def skip_empty_cells(self, skip_empty_cells):
        self.container['skip_empty_cells'] = skip_empty_cells 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AddTextOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    