# coding: utf-8
"""
<copyright company="Aspose" file="AggregateResultByColorpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AggregateResultByColor(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'aggregate_operation' : 'str',
        'color_name' : 'str',
        'count' : 'int',
        'sum' : 'float',
        'max_value' : 'float',
        'min_value' : 'float',
        'average_value' : 'float'
    }

    attribute_map = {
        'aggregate_operation' : 'AggregateOperation' ,
        'color_name' : 'ColorName' ,
        'count' : 'Count' ,
        'sum' : 'Sum' ,
        'max_value' : 'MaxValue' ,
        'min_value' : 'MinValue' ,
        'average_value' : 'AverageValue' 
    }

    @staticmethod
    def get_swagger_types():
        return AggregateResultByColor.swagger_types

    @staticmethod
    def get_attribute_map():
        return AggregateResultByColor.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,aggregate_operation=None ,color_name=None ,count=None ,sum=None ,max_value=None ,min_value=None ,average_value=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AggregateResultByColor - a model defined in Swagger
        """
        self.container['aggregate_operation'] = None 
        self.container['color_name'] = None 
        self.container['count'] = None 
        self.container['sum'] = None 
        self.container['max_value'] = None 
        self.container['min_value'] = None 
        self.container['average_value'] = None 
        params = locals()
        self.aggregate_operation = aggregate_operation
        if 'aggregate_operation' in params:
            self.aggregate_operation = params["aggregate_operation"]


             
        self.color_name = color_name
        if 'color_name' in params:
            self.color_name = params["color_name"]


             
        self.count = count
        if 'count' in params:
            self.count = params["count"]


             
        self.sum = sum
        if 'sum' in params:
            self.sum = params["sum"]


             
        self.max_value = max_value
        if 'max_value' in params:
            self.max_value = params["max_value"]


             
        self.min_value = min_value
        if 'min_value' in params:
            self.min_value = params["min_value"]


             
        self.average_value = average_value
        if 'average_value' in params:
            self.average_value = params["average_value"]


             

    @property
    def aggregate_operation(self):
        return self.container['aggregate_operation']

    @aggregate_operation.setter
    def aggregate_operation(self, aggregate_operation):
        self.container['aggregate_operation'] = aggregate_operation 
    @property
    def color_name(self):
        return self.container['color_name']

    @color_name.setter
    def color_name(self, color_name):
        self.container['color_name'] = color_name 
    @property
    def count(self):
        return self.container['count']

    @count.setter
    def count(self, count):
        self.container['count'] = count 
    @property
    def sum(self):
        return self.container['sum']

    @sum.setter
    def sum(self, sum):
        self.container['sum'] = sum 
    @property
    def max_value(self):
        return self.container['max_value']

    @max_value.setter
    def max_value(self, max_value):
        self.container['max_value'] = max_value 
    @property
    def min_value(self):
        return self.container['min_value']

    @min_value.setter
    def min_value(self, min_value):
        self.container['min_value'] = min_value 
    @property
    def average_value(self):
        return self.container['average_value']

    @average_value.setter
    def average_value(self, average_value):
        self.container['average_value'] = average_value 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AggregateResultByColor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    