# coding: utf-8
"""
<copyright company="Aspose" file="AnalyzedColumnDescriptionpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AnalyzedColumnDescription(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'index' : 'int',
        'column_index' : 'int',
        'title' : 'str',
        'repetition_rate' : 'float',
        'column_data_data_type' : 'str',
        'number_category_type' : 'str',
        'text_category_type' : 'str',
        'style_number' : 'int',
        'column_data_exception_description' : 'str'
    }

    attribute_map = {
        'index' : 'Index' ,
        'column_index' : 'ColumnIndex' ,
        'title' : 'Title' ,
        'repetition_rate' : 'RepetitionRate' ,
        'column_data_data_type' : 'ColumnDataDataType' ,
        'number_category_type' : 'NumberCategoryType' ,
        'text_category_type' : 'TextCategoryType' ,
        'style_number' : 'StyleNumber' ,
        'column_data_exception_description' : 'columnDataExceptionDescription' 
    }

    @staticmethod
    def get_swagger_types():
        return AnalyzedColumnDescription.swagger_types

    @staticmethod
    def get_attribute_map():
        return AnalyzedColumnDescription.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,index=None ,column_index=None ,title=None ,repetition_rate=None ,column_data_data_type=None ,number_category_type=None ,text_category_type=None ,style_number=None ,column_data_exception_description=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AnalyzedColumnDescription - a model defined in Swagger
        """
        self.container['index'] = None 
        self.container['column_index'] = None 
        self.container['title'] = None 
        self.container['repetition_rate'] = None 
        self.container['column_data_data_type'] = None 
        self.container['number_category_type'] = None 
        self.container['text_category_type'] = None 
        self.container['style_number'] = None 
        self.container['column_data_exception_description'] = None 
        params = locals()
        self.index = index
        if 'index' in params:
            self.index = params["index"]


             
        self.column_index = column_index
        if 'column_index' in params:
            self.column_index = params["column_index"]


             
        self.title = title
        if 'title' in params:
            self.title = params["title"]


             
        self.repetition_rate = repetition_rate
        if 'repetition_rate' in params:
            self.repetition_rate = params["repetition_rate"]


             
        self.column_data_data_type = column_data_data_type
        if 'column_data_data_type' in params:
            self.column_data_data_type = params["column_data_data_type"]


             
        self.number_category_type = number_category_type
        if 'number_category_type' in params:
            self.number_category_type = params["number_category_type"]


             
        self.text_category_type = text_category_type
        if 'text_category_type' in params:
            self.text_category_type = params["text_category_type"]


             
        self.style_number = style_number
        if 'style_number' in params:
            self.style_number = params["style_number"]


             
        self.column_data_exception_description = column_data_exception_description
        if 'column_data_exception_description' in params:
            self.column_data_exception_description = params["column_data_exception_description"]


             

    @property
    def index(self):
        return self.container['index']

    @index.setter
    def index(self, index):
        self.container['index'] = index 
    @property
    def column_index(self):
        return self.container['column_index']

    @column_index.setter
    def column_index(self, column_index):
        self.container['column_index'] = column_index 
    @property
    def title(self):
        return self.container['title']

    @title.setter
    def title(self, title):
        self.container['title'] = title 
    @property
    def repetition_rate(self):
        return self.container['repetition_rate']

    @repetition_rate.setter
    def repetition_rate(self, repetition_rate):
        self.container['repetition_rate'] = repetition_rate 
    @property
    def column_data_data_type(self):
        return self.container['column_data_data_type']

    @column_data_data_type.setter
    def column_data_data_type(self, column_data_data_type):
        self.container['column_data_data_type'] = column_data_data_type 
    @property
    def number_category_type(self):
        return self.container['number_category_type']

    @number_category_type.setter
    def number_category_type(self, number_category_type):
        self.container['number_category_type'] = number_category_type 
    @property
    def text_category_type(self):
        return self.container['text_category_type']

    @text_category_type.setter
    def text_category_type(self, text_category_type):
        self.container['text_category_type'] = text_category_type 
    @property
    def style_number(self):
        return self.container['style_number']

    @style_number.setter
    def style_number(self, style_number):
        self.container['style_number'] = style_number 
    @property
    def column_data_exception_description(self):
        return self.container['column_data_exception_description']

    @column_data_exception_description.setter
    def column_data_exception_description(self, column_data_exception_description):
        self.container['column_data_exception_description'] = column_data_exception_description 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AnalyzedColumnDescription):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    