# coding: utf-8
"""
<copyright company="Aspose" file="AutoFilterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AutoFilter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'filter_columns' : 'list[FilterColumn]',
        'range' : 'str',
        'sorter' : 'DataSorter',
        'show_filter_button' : 'bool',
        'link' : 'Link'
    }

    attribute_map = {
        'filter_columns' : 'FilterColumns' ,
        'range' : 'Range' ,
        'sorter' : 'Sorter' ,
        'show_filter_button' : 'ShowFilterButton' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return AutoFilter.swagger_types

    @staticmethod
    def get_attribute_map():
        return AutoFilter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,filter_columns=None ,range=None ,sorter=None ,show_filter_button=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AutoFilter - a model defined in Swagger
        """
        self.container['filter_columns'] = None 
        self.container['range'] = None 
        self.container['sorter'] = None 
        self.container['show_filter_button'] = None 
        self.container['link'] = None 
        params = locals()
        self.filter_columns = filter_columns
        if 'filter_columns' in params:
            self.filter_columns = params["filter_columns"]


             
        self.range = range
        if 'range' in params:
            self.range = params["range"]


             
        self.sorter = sorter
        if 'sorter' in params:
            self.sorter = params["sorter"]


             
        self.show_filter_button = show_filter_button
        if 'show_filter_button' in params:
            self.show_filter_button = params["show_filter_button"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def filter_columns(self):
        return self.container['filter_columns']

    @filter_columns.setter
    def filter_columns(self, filter_columns):
        self.container['filter_columns'] = filter_columns 
    @property
    def range(self):
        return self.container['range']

    @range.setter
    def range(self, range):
        self.container['range'] = range 
    @property
    def sorter(self):
        return self.container['sorter']

    @sorter.setter
    def sorter(self, sorter):
        self.container['sorter'] = sorter 
    @property
    def show_filter_button(self):
        return self.container['show_filter_button']

    @show_filter_button.setter
    def show_filter_button(self, show_filter_button):
        self.container['show_filter_button'] = show_filter_button 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AutoFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    