# coding: utf-8
"""
<copyright company="Aspose" file="Cellpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Cell(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'row' : 'int',
        'column' : 'int',
        'value' : 'str',
        'type' : 'str',
        'formula' : 'str',
        'is_formula' : 'bool',
        'is_merged' : 'bool',
        'is_array_header' : 'bool',
        'is_in_array' : 'bool',
        'is_error_value' : 'bool',
        'is_in_table' : 'bool',
        'is_style_set' : 'bool',
        'html_string' : 'str',
        'style' : 'LinkElement',
        'worksheet' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'name' : 'Name' ,
        'row' : 'Row' ,
        'column' : 'Column' ,
        'value' : 'Value' ,
        'type' : 'Type' ,
        'formula' : 'Formula' ,
        'is_formula' : 'IsFormula' ,
        'is_merged' : 'IsMerged' ,
        'is_array_header' : 'IsArrayHeader' ,
        'is_in_array' : 'IsInArray' ,
        'is_error_value' : 'IsErrorValue' ,
        'is_in_table' : 'IsInTable' ,
        'is_style_set' : 'IsStyleSet' ,
        'html_string' : 'HtmlString' ,
        'style' : 'Style' ,
        'worksheet' : 'Worksheet' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Cell.swagger_types

    @staticmethod
    def get_attribute_map():
        return Cell.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,row=None ,column=None ,value=None ,type=None ,formula=None ,is_formula=None ,is_merged=None ,is_array_header=None ,is_in_array=None ,is_error_value=None ,is_in_table=None ,is_style_set=None ,html_string=None ,style=None ,worksheet=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Cell - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['row'] = None 
        self.container['column'] = None 
        self.container['value'] = None 
        self.container['type'] = None 
        self.container['formula'] = None 
        self.container['is_formula'] = None 
        self.container['is_merged'] = None 
        self.container['is_array_header'] = None 
        self.container['is_in_array'] = None 
        self.container['is_error_value'] = None 
        self.container['is_in_table'] = None 
        self.container['is_style_set'] = None 
        self.container['html_string'] = None 
        self.container['style'] = None 
        self.container['worksheet'] = None 
        self.container['link'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.row = row
        if 'row' in params:
            self.row = params["row"]


             
        self.column = column
        if 'column' in params:
            self.column = params["column"]


             
        self.value = value
        if 'value' in params:
            self.value = params["value"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.formula = formula
        if 'formula' in params:
            self.formula = params["formula"]


             
        self.is_formula = is_formula
        if 'is_formula' in params:
            self.is_formula = params["is_formula"]


             
        self.is_merged = is_merged
        if 'is_merged' in params:
            self.is_merged = params["is_merged"]


             
        self.is_array_header = is_array_header
        if 'is_array_header' in params:
            self.is_array_header = params["is_array_header"]


             
        self.is_in_array = is_in_array
        if 'is_in_array' in params:
            self.is_in_array = params["is_in_array"]


             
        self.is_error_value = is_error_value
        if 'is_error_value' in params:
            self.is_error_value = params["is_error_value"]


             
        self.is_in_table = is_in_table
        if 'is_in_table' in params:
            self.is_in_table = params["is_in_table"]


             
        self.is_style_set = is_style_set
        if 'is_style_set' in params:
            self.is_style_set = params["is_style_set"]


             
        self.html_string = html_string
        if 'html_string' in params:
            self.html_string = params["html_string"]


             
        self.style = style
        if 'style' in params:
            self.style = params["style"]


             
        self.worksheet = worksheet
        if 'worksheet' in params:
            self.worksheet = params["worksheet"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def row(self):
        return self.container['row']

    @row.setter
    def row(self, row):
        self.container['row'] = row 
    @property
    def column(self):
        return self.container['column']

    @column.setter
    def column(self, column):
        self.container['column'] = column 
    @property
    def value(self):
        return self.container['value']

    @value.setter
    def value(self, value):
        self.container['value'] = value 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def formula(self):
        return self.container['formula']

    @formula.setter
    def formula(self, formula):
        self.container['formula'] = formula 
    @property
    def is_formula(self):
        return self.container['is_formula']

    @is_formula.setter
    def is_formula(self, is_formula):
        self.container['is_formula'] = is_formula 
    @property
    def is_merged(self):
        return self.container['is_merged']

    @is_merged.setter
    def is_merged(self, is_merged):
        self.container['is_merged'] = is_merged 
    @property
    def is_array_header(self):
        return self.container['is_array_header']

    @is_array_header.setter
    def is_array_header(self, is_array_header):
        self.container['is_array_header'] = is_array_header 
    @property
    def is_in_array(self):
        return self.container['is_in_array']

    @is_in_array.setter
    def is_in_array(self, is_in_array):
        self.container['is_in_array'] = is_in_array 
    @property
    def is_error_value(self):
        return self.container['is_error_value']

    @is_error_value.setter
    def is_error_value(self, is_error_value):
        self.container['is_error_value'] = is_error_value 
    @property
    def is_in_table(self):
        return self.container['is_in_table']

    @is_in_table.setter
    def is_in_table(self, is_in_table):
        self.container['is_in_table'] = is_in_table 
    @property
    def is_style_set(self):
        return self.container['is_style_set']

    @is_style_set.setter
    def is_style_set(self, is_style_set):
        self.container['is_style_set'] = is_style_set 
    @property
    def html_string(self):
        return self.container['html_string']

    @html_string.setter
    def html_string(self, html_string):
        self.container['html_string'] = html_string 
    @property
    def style(self):
        return self.container['style']

    @style.setter
    def style(self, style):
        self.container['style'] = style 
    @property
    def worksheet(self):
        return self.container['worksheet']

    @worksheet.setter
    def worksheet(self, worksheet):
        self.container['worksheet'] = worksheet 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Cell):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    