# coding: utf-8
"""
<copyright company="Aspose" file="Cellspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Cells(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'max_row' : 'int',
        'max_column' : 'int',
        'cell_count' : 'int',
        'rows' : 'LinkElement',
        'columns' : 'LinkElement',
        'cell_list' : 'list[LinkElement]',
        'link' : 'Link'
    }

    attribute_map = {
        'max_row' : 'MaxRow' ,
        'max_column' : 'MaxColumn' ,
        'cell_count' : 'CellCount' ,
        'rows' : 'Rows' ,
        'columns' : 'Columns' ,
        'cell_list' : 'CellList' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Cells.swagger_types

    @staticmethod
    def get_attribute_map():
        return Cells.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,max_row=None ,max_column=None ,cell_count=None ,rows=None ,columns=None ,cell_list=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Cells - a model defined in Swagger
        """
        self.container['max_row'] = None 
        self.container['max_column'] = None 
        self.container['cell_count'] = None 
        self.container['rows'] = None 
        self.container['columns'] = None 
        self.container['cell_list'] = None 
        self.container['link'] = None 
        params = locals()
        self.max_row = max_row
        if 'max_row' in params:
            self.max_row = params["max_row"]


             
        self.max_column = max_column
        if 'max_column' in params:
            self.max_column = params["max_column"]


             
        self.cell_count = cell_count
        if 'cell_count' in params:
            self.cell_count = params["cell_count"]


             
        self.rows = rows
        if 'rows' in params:
            self.rows = params["rows"]


             
        self.columns = columns
        if 'columns' in params:
            self.columns = params["columns"]


             
        self.cell_list = cell_list
        if 'cell_list' in params:
            self.cell_list = params["cell_list"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def max_row(self):
        return self.container['max_row']

    @max_row.setter
    def max_row(self, max_row):
        self.container['max_row'] = max_row 
    @property
    def max_column(self):
        return self.container['max_column']

    @max_column.setter
    def max_column(self, max_column):
        self.container['max_column'] = max_column 
    @property
    def cell_count(self):
        return self.container['cell_count']

    @cell_count.setter
    def cell_count(self, cell_count):
        self.container['cell_count'] = cell_count 
    @property
    def rows(self):
        return self.container['rows']

    @rows.setter
    def rows(self, rows):
        self.container['rows'] = rows 
    @property
    def columns(self):
        return self.container['columns']

    @columns.setter
    def columns(self, columns):
        self.container['columns'] = columns 
    @property
    def cell_list(self):
        return self.container['cell_list']

    @cell_list.setter
    def cell_list(self, cell_list):
        self.container['cell_list'] = cell_list 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Cells):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    