# coding: utf-8
"""
<copyright company="Aspose" file="CellsColorpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class CellsColor(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'color' : 'Color',
        'color_index' : 'int',
        'is_shape_color' : 'bool',
        'tint' : 'float',
        'argb' : 'int',
        'theme_color' : 'ThemeColor',
        'type' : 'str',
        'transparency' : 'float'
    }

    attribute_map = {
        'color' : 'Color' ,
        'color_index' : 'ColorIndex' ,
        'is_shape_color' : 'IsShapeColor' ,
        'tint' : 'tint' ,
        'argb' : 'Argb' ,
        'theme_color' : 'ThemeColor' ,
        'type' : 'Type' ,
        'transparency' : 'Transparency' 
    }

    @staticmethod
    def get_swagger_types():
        return CellsColor.swagger_types

    @staticmethod
    def get_attribute_map():
        return CellsColor.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,color=None ,color_index=None ,is_shape_color=None ,tint=None ,argb=None ,theme_color=None ,type=None ,transparency=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        CellsColor - a model defined in Swagger
        """
        self.container['color'] = None 
        self.container['color_index'] = None 
        self.container['is_shape_color'] = None 
        self.container['tint'] = None 
        self.container['argb'] = None 
        self.container['theme_color'] = None 
        self.container['type'] = None 
        self.container['transparency'] = None 
        params = locals()
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.color_index = color_index
        if 'color_index' in params:
            self.color_index = params["color_index"]


             
        self.is_shape_color = is_shape_color
        if 'is_shape_color' in params:
            self.is_shape_color = params["is_shape_color"]


             
        self.tint = tint
        if 'tint' in params:
            self.tint = params["tint"]


             
        self.argb = argb
        if 'argb' in params:
            self.argb = params["argb"]


             
        self.theme_color = theme_color
        if 'theme_color' in params:
            self.theme_color = params["theme_color"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.transparency = transparency
        if 'transparency' in params:
            self.transparency = params["transparency"]


             

    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def color_index(self):
        return self.container['color_index']

    @color_index.setter
    def color_index(self, color_index):
        self.container['color_index'] = color_index 
    @property
    def is_shape_color(self):
        return self.container['is_shape_color']

    @is_shape_color.setter
    def is_shape_color(self, is_shape_color):
        self.container['is_shape_color'] = is_shape_color 
    @property
    def tint(self):
        return self.container['tint']

    @tint.setter
    def tint(self, tint):
        self.container['tint'] = tint 
    @property
    def argb(self):
        return self.container['argb']

    @argb.setter
    def argb(self, argb):
        self.container['argb'] = argb 
    @property
    def theme_color(self):
        return self.container['theme_color']

    @theme_color.setter
    def theme_color(self, theme_color):
        self.container['theme_color'] = theme_color 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def transparency(self):
        return self.container['transparency']

    @transparency.setter
    def transparency(self, transparency):
        self.container['transparency'] = transparency 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CellsColor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    