# coding: utf-8
"""
<copyright company="Aspose" file="CellsDrawingpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class CellsDrawing(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'mso_drawing_type' : 'str',
        'auto_shape_type' : 'str',
        'placement' : 'str',
        'upper_left_row' : 'int',
        'top' : 'int',
        'upper_left_column' : 'int',
        'left' : 'int',
        'lower_right_row' : 'int',
        'bottom' : 'int',
        'lower_right_column' : 'int',
        'right' : 'int',
        'width' : 'int',
        'height' : 'int',
        'x' : 'int',
        'y' : 'int',
        'rotation_angle' : 'float',
        'html_text' : 'str',
        'text' : 'str',
        'alternative_text' : 'str',
        'text_horizontal_alignment' : 'str',
        'text_horizontal_overflow' : 'str',
        'text_orientation_type' : 'str',
        'text_vertical_alignment' : 'str',
        'text_vertical_overflow' : 'str',
        'is_group' : 'bool',
        'is_hidden' : 'bool',
        'is_lock_aspect_ratio' : 'bool',
        'is_locked' : 'bool',
        'is_printable' : 'bool',
        'is_text_wrapped' : 'bool',
        'is_word_art' : 'bool',
        'linked_cell' : 'str',
        'z_order_position' : 'int',
        'font' : 'Font',
        'hyperlink' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'name' : 'Name' ,
        'mso_drawing_type' : 'MsoDrawingType' ,
        'auto_shape_type' : 'AutoShapeType' ,
        'placement' : 'Placement' ,
        'upper_left_row' : 'UpperLeftRow' ,
        'top' : 'Top' ,
        'upper_left_column' : 'UpperLeftColumn' ,
        'left' : 'Left' ,
        'lower_right_row' : 'LowerRightRow' ,
        'bottom' : 'Bottom' ,
        'lower_right_column' : 'LowerRightColumn' ,
        'right' : 'Right' ,
        'width' : 'Width' ,
        'height' : 'Height' ,
        'x' : 'X' ,
        'y' : 'Y' ,
        'rotation_angle' : 'RotationAngle' ,
        'html_text' : 'HtmlText' ,
        'text' : 'Text' ,
        'alternative_text' : 'AlternativeText' ,
        'text_horizontal_alignment' : 'TextHorizontalAlignment' ,
        'text_horizontal_overflow' : 'TextHorizontalOverflow' ,
        'text_orientation_type' : 'TextOrientationType' ,
        'text_vertical_alignment' : 'TextVerticalAlignment' ,
        'text_vertical_overflow' : 'TextVerticalOverflow' ,
        'is_group' : 'IsGroup' ,
        'is_hidden' : 'IsHidden' ,
        'is_lock_aspect_ratio' : 'IsLockAspectRatio' ,
        'is_locked' : 'IsLocked' ,
        'is_printable' : 'IsPrintable' ,
        'is_text_wrapped' : 'IsTextWrapped' ,
        'is_word_art' : 'IsWordArt' ,
        'linked_cell' : 'LinkedCell' ,
        'z_order_position' : 'ZOrderPosition' ,
        'font' : 'Font' ,
        'hyperlink' : 'Hyperlink' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return CellsDrawing.swagger_types

    @staticmethod
    def get_attribute_map():
        return CellsDrawing.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,mso_drawing_type=None ,auto_shape_type=None ,placement=None ,upper_left_row=None ,top=None ,upper_left_column=None ,left=None ,lower_right_row=None ,bottom=None ,lower_right_column=None ,right=None ,width=None ,height=None ,x=None ,y=None ,rotation_angle=None ,html_text=None ,text=None ,alternative_text=None ,text_horizontal_alignment=None ,text_horizontal_overflow=None ,text_orientation_type=None ,text_vertical_alignment=None ,text_vertical_overflow=None ,is_group=None ,is_hidden=None ,is_lock_aspect_ratio=None ,is_locked=None ,is_printable=None ,is_text_wrapped=None ,is_word_art=None ,linked_cell=None ,z_order_position=None ,font=None ,hyperlink=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        CellsDrawing - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['mso_drawing_type'] = None 
        self.container['auto_shape_type'] = None 
        self.container['placement'] = None 
        self.container['upper_left_row'] = None 
        self.container['top'] = None 
        self.container['upper_left_column'] = None 
        self.container['left'] = None 
        self.container['lower_right_row'] = None 
        self.container['bottom'] = None 
        self.container['lower_right_column'] = None 
        self.container['right'] = None 
        self.container['width'] = None 
        self.container['height'] = None 
        self.container['x'] = None 
        self.container['y'] = None 
        self.container['rotation_angle'] = None 
        self.container['html_text'] = None 
        self.container['text'] = None 
        self.container['alternative_text'] = None 
        self.container['text_horizontal_alignment'] = None 
        self.container['text_horizontal_overflow'] = None 
        self.container['text_orientation_type'] = None 
        self.container['text_vertical_alignment'] = None 
        self.container['text_vertical_overflow'] = None 
        self.container['is_group'] = None 
        self.container['is_hidden'] = None 
        self.container['is_lock_aspect_ratio'] = None 
        self.container['is_locked'] = None 
        self.container['is_printable'] = None 
        self.container['is_text_wrapped'] = None 
        self.container['is_word_art'] = None 
        self.container['linked_cell'] = None 
        self.container['z_order_position'] = None 
        self.container['font'] = None 
        self.container['hyperlink'] = None 
        self.container['link'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.mso_drawing_type = mso_drawing_type
        if 'mso_drawing_type' in params:
            self.mso_drawing_type = params["mso_drawing_type"]


             
        self.auto_shape_type = auto_shape_type
        if 'auto_shape_type' in params:
            self.auto_shape_type = params["auto_shape_type"]


             
        self.placement = placement
        if 'placement' in params:
            self.placement = params["placement"]


             
        self.upper_left_row = upper_left_row
        if 'upper_left_row' in params:
            self.upper_left_row = params["upper_left_row"]


             
        self.top = top
        if 'top' in params:
            self.top = params["top"]


             
        self.upper_left_column = upper_left_column
        if 'upper_left_column' in params:
            self.upper_left_column = params["upper_left_column"]


             
        self.left = left
        if 'left' in params:
            self.left = params["left"]


             
        self.lower_right_row = lower_right_row
        if 'lower_right_row' in params:
            self.lower_right_row = params["lower_right_row"]


             
        self.bottom = bottom
        if 'bottom' in params:
            self.bottom = params["bottom"]


             
        self.lower_right_column = lower_right_column
        if 'lower_right_column' in params:
            self.lower_right_column = params["lower_right_column"]


             
        self.right = right
        if 'right' in params:
            self.right = params["right"]


             
        self.width = width
        if 'width' in params:
            self.width = params["width"]


             
        self.height = height
        if 'height' in params:
            self.height = params["height"]


             
        self.x = x
        if 'x' in params:
            self.x = params["x"]


             
        self.y = y
        if 'y' in params:
            self.y = params["y"]


             
        self.rotation_angle = rotation_angle
        if 'rotation_angle' in params:
            self.rotation_angle = params["rotation_angle"]


             
        self.html_text = html_text
        if 'html_text' in params:
            self.html_text = params["html_text"]


             
        self.text = text
        if 'text' in params:
            self.text = params["text"]


             
        self.alternative_text = alternative_text
        if 'alternative_text' in params:
            self.alternative_text = params["alternative_text"]


             
        self.text_horizontal_alignment = text_horizontal_alignment
        if 'text_horizontal_alignment' in params:
            self.text_horizontal_alignment = params["text_horizontal_alignment"]


             
        self.text_horizontal_overflow = text_horizontal_overflow
        if 'text_horizontal_overflow' in params:
            self.text_horizontal_overflow = params["text_horizontal_overflow"]


             
        self.text_orientation_type = text_orientation_type
        if 'text_orientation_type' in params:
            self.text_orientation_type = params["text_orientation_type"]


             
        self.text_vertical_alignment = text_vertical_alignment
        if 'text_vertical_alignment' in params:
            self.text_vertical_alignment = params["text_vertical_alignment"]


             
        self.text_vertical_overflow = text_vertical_overflow
        if 'text_vertical_overflow' in params:
            self.text_vertical_overflow = params["text_vertical_overflow"]


             
        self.is_group = is_group
        if 'is_group' in params:
            self.is_group = params["is_group"]


             
        self.is_hidden = is_hidden
        if 'is_hidden' in params:
            self.is_hidden = params["is_hidden"]


             
        self.is_lock_aspect_ratio = is_lock_aspect_ratio
        if 'is_lock_aspect_ratio' in params:
            self.is_lock_aspect_ratio = params["is_lock_aspect_ratio"]


             
        self.is_locked = is_locked
        if 'is_locked' in params:
            self.is_locked = params["is_locked"]


             
        self.is_printable = is_printable
        if 'is_printable' in params:
            self.is_printable = params["is_printable"]


             
        self.is_text_wrapped = is_text_wrapped
        if 'is_text_wrapped' in params:
            self.is_text_wrapped = params["is_text_wrapped"]


             
        self.is_word_art = is_word_art
        if 'is_word_art' in params:
            self.is_word_art = params["is_word_art"]


             
        self.linked_cell = linked_cell
        if 'linked_cell' in params:
            self.linked_cell = params["linked_cell"]


             
        self.z_order_position = z_order_position
        if 'z_order_position' in params:
            self.z_order_position = params["z_order_position"]


             
        self.font = font
        if 'font' in params:
            self.font = params["font"]


             
        self.hyperlink = hyperlink
        if 'hyperlink' in params:
            self.hyperlink = params["hyperlink"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def mso_drawing_type(self):
        return self.container['mso_drawing_type']

    @mso_drawing_type.setter
    def mso_drawing_type(self, mso_drawing_type):
        self.container['mso_drawing_type'] = mso_drawing_type 
    @property
    def auto_shape_type(self):
        return self.container['auto_shape_type']

    @auto_shape_type.setter
    def auto_shape_type(self, auto_shape_type):
        self.container['auto_shape_type'] = auto_shape_type 
    @property
    def placement(self):
        return self.container['placement']

    @placement.setter
    def placement(self, placement):
        self.container['placement'] = placement 
    @property
    def upper_left_row(self):
        return self.container['upper_left_row']

    @upper_left_row.setter
    def upper_left_row(self, upper_left_row):
        self.container['upper_left_row'] = upper_left_row 
    @property
    def top(self):
        return self.container['top']

    @top.setter
    def top(self, top):
        self.container['top'] = top 
    @property
    def upper_left_column(self):
        return self.container['upper_left_column']

    @upper_left_column.setter
    def upper_left_column(self, upper_left_column):
        self.container['upper_left_column'] = upper_left_column 
    @property
    def left(self):
        return self.container['left']

    @left.setter
    def left(self, left):
        self.container['left'] = left 
    @property
    def lower_right_row(self):
        return self.container['lower_right_row']

    @lower_right_row.setter
    def lower_right_row(self, lower_right_row):
        self.container['lower_right_row'] = lower_right_row 
    @property
    def bottom(self):
        return self.container['bottom']

    @bottom.setter
    def bottom(self, bottom):
        self.container['bottom'] = bottom 
    @property
    def lower_right_column(self):
        return self.container['lower_right_column']

    @lower_right_column.setter
    def lower_right_column(self, lower_right_column):
        self.container['lower_right_column'] = lower_right_column 
    @property
    def right(self):
        return self.container['right']

    @right.setter
    def right(self, right):
        self.container['right'] = right 
    @property
    def width(self):
        return self.container['width']

    @width.setter
    def width(self, width):
        self.container['width'] = width 
    @property
    def height(self):
        return self.container['height']

    @height.setter
    def height(self, height):
        self.container['height'] = height 
    @property
    def x(self):
        return self.container['x']

    @x.setter
    def x(self, x):
        self.container['x'] = x 
    @property
    def y(self):
        return self.container['y']

    @y.setter
    def y(self, y):
        self.container['y'] = y 
    @property
    def rotation_angle(self):
        return self.container['rotation_angle']

    @rotation_angle.setter
    def rotation_angle(self, rotation_angle):
        self.container['rotation_angle'] = rotation_angle 
    @property
    def html_text(self):
        return self.container['html_text']

    @html_text.setter
    def html_text(self, html_text):
        self.container['html_text'] = html_text 
    @property
    def text(self):
        return self.container['text']

    @text.setter
    def text(self, text):
        self.container['text'] = text 
    @property
    def alternative_text(self):
        return self.container['alternative_text']

    @alternative_text.setter
    def alternative_text(self, alternative_text):
        self.container['alternative_text'] = alternative_text 
    @property
    def text_horizontal_alignment(self):
        return self.container['text_horizontal_alignment']

    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, text_horizontal_alignment):
        self.container['text_horizontal_alignment'] = text_horizontal_alignment 
    @property
    def text_horizontal_overflow(self):
        return self.container['text_horizontal_overflow']

    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, text_horizontal_overflow):
        self.container['text_horizontal_overflow'] = text_horizontal_overflow 
    @property
    def text_orientation_type(self):
        return self.container['text_orientation_type']

    @text_orientation_type.setter
    def text_orientation_type(self, text_orientation_type):
        self.container['text_orientation_type'] = text_orientation_type 
    @property
    def text_vertical_alignment(self):
        return self.container['text_vertical_alignment']

    @text_vertical_alignment.setter
    def text_vertical_alignment(self, text_vertical_alignment):
        self.container['text_vertical_alignment'] = text_vertical_alignment 
    @property
    def text_vertical_overflow(self):
        return self.container['text_vertical_overflow']

    @text_vertical_overflow.setter
    def text_vertical_overflow(self, text_vertical_overflow):
        self.container['text_vertical_overflow'] = text_vertical_overflow 
    @property
    def is_group(self):
        return self.container['is_group']

    @is_group.setter
    def is_group(self, is_group):
        self.container['is_group'] = is_group 
    @property
    def is_hidden(self):
        return self.container['is_hidden']

    @is_hidden.setter
    def is_hidden(self, is_hidden):
        self.container['is_hidden'] = is_hidden 
    @property
    def is_lock_aspect_ratio(self):
        return self.container['is_lock_aspect_ratio']

    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, is_lock_aspect_ratio):
        self.container['is_lock_aspect_ratio'] = is_lock_aspect_ratio 
    @property
    def is_locked(self):
        return self.container['is_locked']

    @is_locked.setter
    def is_locked(self, is_locked):
        self.container['is_locked'] = is_locked 
    @property
    def is_printable(self):
        return self.container['is_printable']

    @is_printable.setter
    def is_printable(self, is_printable):
        self.container['is_printable'] = is_printable 
    @property
    def is_text_wrapped(self):
        return self.container['is_text_wrapped']

    @is_text_wrapped.setter
    def is_text_wrapped(self, is_text_wrapped):
        self.container['is_text_wrapped'] = is_text_wrapped 
    @property
    def is_word_art(self):
        return self.container['is_word_art']

    @is_word_art.setter
    def is_word_art(self, is_word_art):
        self.container['is_word_art'] = is_word_art 
    @property
    def linked_cell(self):
        return self.container['linked_cell']

    @linked_cell.setter
    def linked_cell(self, linked_cell):
        self.container['linked_cell'] = linked_cell 
    @property
    def z_order_position(self):
        return self.container['z_order_position']

    @z_order_position.setter
    def z_order_position(self, z_order_position):
        self.container['z_order_position'] = z_order_position 
    @property
    def font(self):
        return self.container['font']

    @font.setter
    def font(self, font):
        self.container['font'] = font 
    @property
    def hyperlink(self):
        return self.container['hyperlink']

    @hyperlink.setter
    def hyperlink(self, hyperlink):
        self.container['hyperlink'] = hyperlink 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CellsDrawing):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    