# coding: utf-8
"""
<copyright company="Aspose" file="Chartpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Chart(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_scaling' : 'bool',
        'back_wall' : 'Walls',
        'category_axis' : 'Axis',
        'chart_area' : 'ChartArea',
        'chart_data_table' : 'ChartDataTable',
        'chart_object' : 'LinkElement',
        'depth_percent' : 'int',
        'elevation' : 'int',
        'first_slice_angle' : 'int',
        'floor' : 'Floor',
        'gap_depth' : 'int',
        'gap_width' : 'int',
        'height_percent' : 'int',
        'hide_pivot_field_buttons' : 'bool',
        'is3_d' : 'bool',
        'is_rectangular_cornered' : 'bool',
        'legend' : 'Legend',
        'name' : 'str',
        'n_series' : 'SeriesItems',
        'page_setup' : 'LinkElement',
        'perspective' : 'int',
        'pivot_source' : 'str',
        'placement' : 'str',
        'plot_area' : 'PlotArea',
        'plot_empty_cells_type' : 'str',
        'plot_visible_cells' : 'bool',
        'print_size' : 'str',
        'right_angle_axes' : 'bool',
        'rotation_angle' : 'int',
        'second_category_axis' : 'LinkElement',
        'second_value_axis' : 'LinkElement',
        'series_axis' : 'LinkElement',
        'shapes' : 'LinkElement',
        'show_data_table' : 'bool',
        'show_legend' : 'bool',
        'side_wall' : 'LinkElement',
        'size_with_window' : 'bool',
        'style' : 'int',
        'title' : 'LinkElement',
        'type' : 'str',
        'value_axis' : 'Axis',
        'walls' : 'LinkElement',
        'walls_and_gridlines2_d' : 'bool',
        'link' : 'Link'
    }

    attribute_map = {
        'auto_scaling' : 'AutoScaling' ,
        'back_wall' : 'BackWall' ,
        'category_axis' : 'CategoryAxis' ,
        'chart_area' : 'ChartArea' ,
        'chart_data_table' : 'ChartDataTable' ,
        'chart_object' : 'ChartObject' ,
        'depth_percent' : 'DepthPercent' ,
        'elevation' : 'Elevation' ,
        'first_slice_angle' : 'FirstSliceAngle' ,
        'floor' : 'Floor' ,
        'gap_depth' : 'GapDepth' ,
        'gap_width' : 'GapWidth' ,
        'height_percent' : 'HeightPercent' ,
        'hide_pivot_field_buttons' : 'HidePivotFieldButtons' ,
        'is3_d' : 'Is3D' ,
        'is_rectangular_cornered' : 'IsRectangularCornered' ,
        'legend' : 'Legend' ,
        'name' : 'Name' ,
        'n_series' : 'NSeries' ,
        'page_setup' : 'PageSetup' ,
        'perspective' : 'Perspective' ,
        'pivot_source' : 'PivotSource' ,
        'placement' : 'Placement' ,
        'plot_area' : 'PlotArea' ,
        'plot_empty_cells_type' : 'PlotEmptyCellsType' ,
        'plot_visible_cells' : 'PlotVisibleCells' ,
        'print_size' : 'PrintSize' ,
        'right_angle_axes' : 'RightAngleAxes' ,
        'rotation_angle' : 'RotationAngle' ,
        'second_category_axis' : 'SecondCategoryAxis' ,
        'second_value_axis' : 'SecondValueAxis' ,
        'series_axis' : 'SeriesAxis' ,
        'shapes' : 'Shapes' ,
        'show_data_table' : 'ShowDataTable' ,
        'show_legend' : 'ShowLegend' ,
        'side_wall' : 'SideWall' ,
        'size_with_window' : 'SizeWithWindow' ,
        'style' : 'Style' ,
        'title' : 'Title' ,
        'type' : 'Type' ,
        'value_axis' : 'ValueAxis' ,
        'walls' : 'Walls' ,
        'walls_and_gridlines2_d' : 'WallsAndGridlines2D' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Chart.swagger_types

    @staticmethod
    def get_attribute_map():
        return Chart.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_scaling=None ,back_wall=None ,category_axis=None ,chart_area=None ,chart_data_table=None ,chart_object=None ,depth_percent=None ,elevation=None ,first_slice_angle=None ,floor=None ,gap_depth=None ,gap_width=None ,height_percent=None ,hide_pivot_field_buttons=None ,is3_d=None ,is_rectangular_cornered=None ,legend=None ,name=None ,n_series=None ,page_setup=None ,perspective=None ,pivot_source=None ,placement=None ,plot_area=None ,plot_empty_cells_type=None ,plot_visible_cells=None ,print_size=None ,right_angle_axes=None ,rotation_angle=None ,second_category_axis=None ,second_value_axis=None ,series_axis=None ,shapes=None ,show_data_table=None ,show_legend=None ,side_wall=None ,size_with_window=None ,style=None ,title=None ,type=None ,value_axis=None ,walls=None ,walls_and_gridlines2_d=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Chart - a model defined in Swagger
        """
        self.container['auto_scaling'] = None 
        self.container['back_wall'] = None 
        self.container['category_axis'] = None 
        self.container['chart_area'] = None 
        self.container['chart_data_table'] = None 
        self.container['chart_object'] = None 
        self.container['depth_percent'] = None 
        self.container['elevation'] = None 
        self.container['first_slice_angle'] = None 
        self.container['floor'] = None 
        self.container['gap_depth'] = None 
        self.container['gap_width'] = None 
        self.container['height_percent'] = None 
        self.container['hide_pivot_field_buttons'] = None 
        self.container['is3_d'] = None 
        self.container['is_rectangular_cornered'] = None 
        self.container['legend'] = None 
        self.container['name'] = None 
        self.container['n_series'] = None 
        self.container['page_setup'] = None 
        self.container['perspective'] = None 
        self.container['pivot_source'] = None 
        self.container['placement'] = None 
        self.container['plot_area'] = None 
        self.container['plot_empty_cells_type'] = None 
        self.container['plot_visible_cells'] = None 
        self.container['print_size'] = None 
        self.container['right_angle_axes'] = None 
        self.container['rotation_angle'] = None 
        self.container['second_category_axis'] = None 
        self.container['second_value_axis'] = None 
        self.container['series_axis'] = None 
        self.container['shapes'] = None 
        self.container['show_data_table'] = None 
        self.container['show_legend'] = None 
        self.container['side_wall'] = None 
        self.container['size_with_window'] = None 
        self.container['style'] = None 
        self.container['title'] = None 
        self.container['type'] = None 
        self.container['value_axis'] = None 
        self.container['walls'] = None 
        self.container['walls_and_gridlines2_d'] = None 
        self.container['link'] = None 
        params = locals()
        self.auto_scaling = auto_scaling
        if 'auto_scaling' in params:
            self.auto_scaling = params["auto_scaling"]


             
        self.back_wall = back_wall
        if 'back_wall' in params:
            self.back_wall = params["back_wall"]


             
        self.category_axis = category_axis
        if 'category_axis' in params:
            self.category_axis = params["category_axis"]


             
        self.chart_area = chart_area
        if 'chart_area' in params:
            self.chart_area = params["chart_area"]


             
        self.chart_data_table = chart_data_table
        if 'chart_data_table' in params:
            self.chart_data_table = params["chart_data_table"]


             
        self.chart_object = chart_object
        if 'chart_object' in params:
            self.chart_object = params["chart_object"]


             
        self.depth_percent = depth_percent
        if 'depth_percent' in params:
            self.depth_percent = params["depth_percent"]


             
        self.elevation = elevation
        if 'elevation' in params:
            self.elevation = params["elevation"]


             
        self.first_slice_angle = first_slice_angle
        if 'first_slice_angle' in params:
            self.first_slice_angle = params["first_slice_angle"]


             
        self.floor = floor
        if 'floor' in params:
            self.floor = params["floor"]


             
        self.gap_depth = gap_depth
        if 'gap_depth' in params:
            self.gap_depth = params["gap_depth"]


             
        self.gap_width = gap_width
        if 'gap_width' in params:
            self.gap_width = params["gap_width"]


             
        self.height_percent = height_percent
        if 'height_percent' in params:
            self.height_percent = params["height_percent"]


             
        self.hide_pivot_field_buttons = hide_pivot_field_buttons
        if 'hide_pivot_field_buttons' in params:
            self.hide_pivot_field_buttons = params["hide_pivot_field_buttons"]


             
        self.is3_d = is3_d
        if 'is3_d' in params:
            self.is3_d = params["is3_d"]


             
        self.is_rectangular_cornered = is_rectangular_cornered
        if 'is_rectangular_cornered' in params:
            self.is_rectangular_cornered = params["is_rectangular_cornered"]


             
        self.legend = legend
        if 'legend' in params:
            self.legend = params["legend"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.n_series = n_series
        if 'n_series' in params:
            self.n_series = params["n_series"]


             
        self.page_setup = page_setup
        if 'page_setup' in params:
            self.page_setup = params["page_setup"]


             
        self.perspective = perspective
        if 'perspective' in params:
            self.perspective = params["perspective"]


             
        self.pivot_source = pivot_source
        if 'pivot_source' in params:
            self.pivot_source = params["pivot_source"]


             
        self.placement = placement
        if 'placement' in params:
            self.placement = params["placement"]


             
        self.plot_area = plot_area
        if 'plot_area' in params:
            self.plot_area = params["plot_area"]


             
        self.plot_empty_cells_type = plot_empty_cells_type
        if 'plot_empty_cells_type' in params:
            self.plot_empty_cells_type = params["plot_empty_cells_type"]


             
        self.plot_visible_cells = plot_visible_cells
        if 'plot_visible_cells' in params:
            self.plot_visible_cells = params["plot_visible_cells"]


             
        self.print_size = print_size
        if 'print_size' in params:
            self.print_size = params["print_size"]


             
        self.right_angle_axes = right_angle_axes
        if 'right_angle_axes' in params:
            self.right_angle_axes = params["right_angle_axes"]


             
        self.rotation_angle = rotation_angle
        if 'rotation_angle' in params:
            self.rotation_angle = params["rotation_angle"]


             
        self.second_category_axis = second_category_axis
        if 'second_category_axis' in params:
            self.second_category_axis = params["second_category_axis"]


             
        self.second_value_axis = second_value_axis
        if 'second_value_axis' in params:
            self.second_value_axis = params["second_value_axis"]


             
        self.series_axis = series_axis
        if 'series_axis' in params:
            self.series_axis = params["series_axis"]


             
        self.shapes = shapes
        if 'shapes' in params:
            self.shapes = params["shapes"]


             
        self.show_data_table = show_data_table
        if 'show_data_table' in params:
            self.show_data_table = params["show_data_table"]


             
        self.show_legend = show_legend
        if 'show_legend' in params:
            self.show_legend = params["show_legend"]


             
        self.side_wall = side_wall
        if 'side_wall' in params:
            self.side_wall = params["side_wall"]


             
        self.size_with_window = size_with_window
        if 'size_with_window' in params:
            self.size_with_window = params["size_with_window"]


             
        self.style = style
        if 'style' in params:
            self.style = params["style"]


             
        self.title = title
        if 'title' in params:
            self.title = params["title"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.value_axis = value_axis
        if 'value_axis' in params:
            self.value_axis = params["value_axis"]


             
        self.walls = walls
        if 'walls' in params:
            self.walls = params["walls"]


             
        self.walls_and_gridlines2_d = walls_and_gridlines2_d
        if 'walls_and_gridlines2_d' in params:
            self.walls_and_gridlines2_d = params["walls_and_gridlines2_d"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def auto_scaling(self):
        return self.container['auto_scaling']

    @auto_scaling.setter
    def auto_scaling(self, auto_scaling):
        self.container['auto_scaling'] = auto_scaling 
    @property
    def back_wall(self):
        return self.container['back_wall']

    @back_wall.setter
    def back_wall(self, back_wall):
        self.container['back_wall'] = back_wall 
    @property
    def category_axis(self):
        return self.container['category_axis']

    @category_axis.setter
    def category_axis(self, category_axis):
        self.container['category_axis'] = category_axis 
    @property
    def chart_area(self):
        return self.container['chart_area']

    @chart_area.setter
    def chart_area(self, chart_area):
        self.container['chart_area'] = chart_area 
    @property
    def chart_data_table(self):
        return self.container['chart_data_table']

    @chart_data_table.setter
    def chart_data_table(self, chart_data_table):
        self.container['chart_data_table'] = chart_data_table 
    @property
    def chart_object(self):
        return self.container['chart_object']

    @chart_object.setter
    def chart_object(self, chart_object):
        self.container['chart_object'] = chart_object 
    @property
    def depth_percent(self):
        return self.container['depth_percent']

    @depth_percent.setter
    def depth_percent(self, depth_percent):
        self.container['depth_percent'] = depth_percent 
    @property
    def elevation(self):
        return self.container['elevation']

    @elevation.setter
    def elevation(self, elevation):
        self.container['elevation'] = elevation 
    @property
    def first_slice_angle(self):
        return self.container['first_slice_angle']

    @first_slice_angle.setter
    def first_slice_angle(self, first_slice_angle):
        self.container['first_slice_angle'] = first_slice_angle 
    @property
    def floor(self):
        return self.container['floor']

    @floor.setter
    def floor(self, floor):
        self.container['floor'] = floor 
    @property
    def gap_depth(self):
        return self.container['gap_depth']

    @gap_depth.setter
    def gap_depth(self, gap_depth):
        self.container['gap_depth'] = gap_depth 
    @property
    def gap_width(self):
        return self.container['gap_width']

    @gap_width.setter
    def gap_width(self, gap_width):
        self.container['gap_width'] = gap_width 
    @property
    def height_percent(self):
        return self.container['height_percent']

    @height_percent.setter
    def height_percent(self, height_percent):
        self.container['height_percent'] = height_percent 
    @property
    def hide_pivot_field_buttons(self):
        return self.container['hide_pivot_field_buttons']

    @hide_pivot_field_buttons.setter
    def hide_pivot_field_buttons(self, hide_pivot_field_buttons):
        self.container['hide_pivot_field_buttons'] = hide_pivot_field_buttons 
    @property
    def is3_d(self):
        return self.container['is3_d']

    @is3_d.setter
    def is3_d(self, is3_d):
        self.container['is3_d'] = is3_d 
    @property
    def is_rectangular_cornered(self):
        return self.container['is_rectangular_cornered']

    @is_rectangular_cornered.setter
    def is_rectangular_cornered(self, is_rectangular_cornered):
        self.container['is_rectangular_cornered'] = is_rectangular_cornered 
    @property
    def legend(self):
        return self.container['legend']

    @legend.setter
    def legend(self, legend):
        self.container['legend'] = legend 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def n_series(self):
        return self.container['n_series']

    @n_series.setter
    def n_series(self, n_series):
        self.container['n_series'] = n_series 
    @property
    def page_setup(self):
        return self.container['page_setup']

    @page_setup.setter
    def page_setup(self, page_setup):
        self.container['page_setup'] = page_setup 
    @property
    def perspective(self):
        return self.container['perspective']

    @perspective.setter
    def perspective(self, perspective):
        self.container['perspective'] = perspective 
    @property
    def pivot_source(self):
        return self.container['pivot_source']

    @pivot_source.setter
    def pivot_source(self, pivot_source):
        self.container['pivot_source'] = pivot_source 
    @property
    def placement(self):
        return self.container['placement']

    @placement.setter
    def placement(self, placement):
        self.container['placement'] = placement 
    @property
    def plot_area(self):
        return self.container['plot_area']

    @plot_area.setter
    def plot_area(self, plot_area):
        self.container['plot_area'] = plot_area 
    @property
    def plot_empty_cells_type(self):
        return self.container['plot_empty_cells_type']

    @plot_empty_cells_type.setter
    def plot_empty_cells_type(self, plot_empty_cells_type):
        self.container['plot_empty_cells_type'] = plot_empty_cells_type 
    @property
    def plot_visible_cells(self):
        return self.container['plot_visible_cells']

    @plot_visible_cells.setter
    def plot_visible_cells(self, plot_visible_cells):
        self.container['plot_visible_cells'] = plot_visible_cells 
    @property
    def print_size(self):
        return self.container['print_size']

    @print_size.setter
    def print_size(self, print_size):
        self.container['print_size'] = print_size 
    @property
    def right_angle_axes(self):
        return self.container['right_angle_axes']

    @right_angle_axes.setter
    def right_angle_axes(self, right_angle_axes):
        self.container['right_angle_axes'] = right_angle_axes 
    @property
    def rotation_angle(self):
        return self.container['rotation_angle']

    @rotation_angle.setter
    def rotation_angle(self, rotation_angle):
        self.container['rotation_angle'] = rotation_angle 
    @property
    def second_category_axis(self):
        return self.container['second_category_axis']

    @second_category_axis.setter
    def second_category_axis(self, second_category_axis):
        self.container['second_category_axis'] = second_category_axis 
    @property
    def second_value_axis(self):
        return self.container['second_value_axis']

    @second_value_axis.setter
    def second_value_axis(self, second_value_axis):
        self.container['second_value_axis'] = second_value_axis 
    @property
    def series_axis(self):
        return self.container['series_axis']

    @series_axis.setter
    def series_axis(self, series_axis):
        self.container['series_axis'] = series_axis 
    @property
    def shapes(self):
        return self.container['shapes']

    @shapes.setter
    def shapes(self, shapes):
        self.container['shapes'] = shapes 
    @property
    def show_data_table(self):
        return self.container['show_data_table']

    @show_data_table.setter
    def show_data_table(self, show_data_table):
        self.container['show_data_table'] = show_data_table 
    @property
    def show_legend(self):
        return self.container['show_legend']

    @show_legend.setter
    def show_legend(self, show_legend):
        self.container['show_legend'] = show_legend 
    @property
    def side_wall(self):
        return self.container['side_wall']

    @side_wall.setter
    def side_wall(self, side_wall):
        self.container['side_wall'] = side_wall 
    @property
    def size_with_window(self):
        return self.container['size_with_window']

    @size_with_window.setter
    def size_with_window(self, size_with_window):
        self.container['size_with_window'] = size_with_window 
    @property
    def style(self):
        return self.container['style']

    @style.setter
    def style(self, style):
        self.container['style'] = style 
    @property
    def title(self):
        return self.container['title']

    @title.setter
    def title(self, title):
        self.container['title'] = title 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def value_axis(self):
        return self.container['value_axis']

    @value_axis.setter
    def value_axis(self, value_axis):
        self.container['value_axis'] = value_axis 
    @property
    def walls(self):
        return self.container['walls']

    @walls.setter
    def walls(self, walls):
        self.container['walls'] = walls 
    @property
    def walls_and_gridlines2_d(self):
        return self.container['walls_and_gridlines2_d']

    @walls_and_gridlines2_d.setter
    def walls_and_gridlines2_d(self, walls_and_gridlines2_d):
        self.container['walls_and_gridlines2_d'] = walls_and_gridlines2_d 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Chart):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    