# coding: utf-8
"""
<copyright company="Aspose" file="ColorFilterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ColorFilter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'filter_by_fill_color' : 'bool',
        'pattern' : 'str',
        'color' : 'CellsColor',
        'foreground_color_color' : 'CellsColor',
        'background_color' : 'CellsColor'
    }

    attribute_map = {
        'filter_by_fill_color' : 'FilterByFillColor' ,
        'pattern' : 'Pattern' ,
        'color' : 'Color' ,
        'foreground_color_color' : 'ForegroundColorColor' ,
        'background_color' : 'BackgroundColor' 
    }

    @staticmethod
    def get_swagger_types():
        return ColorFilter.swagger_types

    @staticmethod
    def get_attribute_map():
        return ColorFilter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,filter_by_fill_color=None ,pattern=None ,color=None ,foreground_color_color=None ,background_color=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ColorFilter - a model defined in Swagger
        """
        self.container['filter_by_fill_color'] = None 
        self.container['pattern'] = None 
        self.container['color'] = None 
        self.container['foreground_color_color'] = None 
        self.container['background_color'] = None 
        params = locals()
        self.filter_by_fill_color = filter_by_fill_color
        if 'filter_by_fill_color' in params:
            self.filter_by_fill_color = params["filter_by_fill_color"]


             
        self.pattern = pattern
        if 'pattern' in params:
            self.pattern = params["pattern"]


             
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.foreground_color_color = foreground_color_color
        if 'foreground_color_color' in params:
            self.foreground_color_color = params["foreground_color_color"]


             
        self.background_color = background_color
        if 'background_color' in params:
            self.background_color = params["background_color"]


             

    @property
    def filter_by_fill_color(self):
        return self.container['filter_by_fill_color']

    @filter_by_fill_color.setter
    def filter_by_fill_color(self, filter_by_fill_color):
        self.container['filter_by_fill_color'] = filter_by_fill_color 
    @property
    def pattern(self):
        return self.container['pattern']

    @pattern.setter
    def pattern(self, pattern):
        self.container['pattern'] = pattern 
    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def foreground_color_color(self):
        return self.container['foreground_color_color']

    @foreground_color_color.setter
    def foreground_color_color(self, foreground_color_color):
        self.container['foreground_color_color'] = foreground_color_color 
    @property
    def background_color(self):
        return self.container['background_color']

    @background_color.setter
    def background_color(self, background_color):
        self.container['background_color'] = background_color 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ColorFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    