# coding: utf-8
"""
<copyright company="Aspose" file="ColorScalepy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ColorScale(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'max_cfvo' : 'ConditionalFormattingValue',
        'max_color' : 'Color',
        'mid_cfvo' : 'ConditionalFormattingValue',
        'mid_color' : 'Color',
        'min_cfvo' : 'ConditionalFormattingValue',
        'min_color' : 'Color'
    }

    attribute_map = {
        'max_cfvo' : 'MaxCfvo' ,
        'max_color' : 'MaxColor' ,
        'mid_cfvo' : 'MidCfvo' ,
        'mid_color' : 'MidColor' ,
        'min_cfvo' : 'MinCfvo' ,
        'min_color' : 'MinColor' 
    }

    @staticmethod
    def get_swagger_types():
        return ColorScale.swagger_types

    @staticmethod
    def get_attribute_map():
        return ColorScale.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,max_cfvo=None ,max_color=None ,mid_cfvo=None ,mid_color=None ,min_cfvo=None ,min_color=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ColorScale - a model defined in Swagger
        """
        self.container['max_cfvo'] = None 
        self.container['max_color'] = None 
        self.container['mid_cfvo'] = None 
        self.container['mid_color'] = None 
        self.container['min_cfvo'] = None 
        self.container['min_color'] = None 
        params = locals()
        self.max_cfvo = max_cfvo
        if 'max_cfvo' in params:
            self.max_cfvo = params["max_cfvo"]


             
        self.max_color = max_color
        if 'max_color' in params:
            self.max_color = params["max_color"]


             
        self.mid_cfvo = mid_cfvo
        if 'mid_cfvo' in params:
            self.mid_cfvo = params["mid_cfvo"]


             
        self.mid_color = mid_color
        if 'mid_color' in params:
            self.mid_color = params["mid_color"]


             
        self.min_cfvo = min_cfvo
        if 'min_cfvo' in params:
            self.min_cfvo = params["min_cfvo"]


             
        self.min_color = min_color
        if 'min_color' in params:
            self.min_color = params["min_color"]


             

    @property
    def max_cfvo(self):
        return self.container['max_cfvo']

    @max_cfvo.setter
    def max_cfvo(self, max_cfvo):
        self.container['max_cfvo'] = max_cfvo 
    @property
    def max_color(self):
        return self.container['max_color']

    @max_color.setter
    def max_color(self, max_color):
        self.container['max_color'] = max_color 
    @property
    def mid_cfvo(self):
        return self.container['mid_cfvo']

    @mid_cfvo.setter
    def mid_cfvo(self, mid_cfvo):
        self.container['mid_cfvo'] = mid_cfvo 
    @property
    def mid_color(self):
        return self.container['mid_color']

    @mid_color.setter
    def mid_color(self, mid_color):
        self.container['mid_color'] = mid_color 
    @property
    def min_cfvo(self):
        return self.container['min_cfvo']

    @min_cfvo.setter
    def min_cfvo(self, min_cfvo):
        self.container['min_cfvo'] = min_cfvo 
    @property
    def min_color(self):
        return self.container['min_color']

    @min_color.setter
    def min_color(self, min_color):
        self.container['min_color'] = min_color 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ColorScale):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    