# coding: utf-8
"""
<copyright company="Aspose" file="CombinationSourceDatapy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class CombinationSourceData(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'tag' : 'str',
        'data_source' : 'DataSource',
        'file_info' : 'FileInfo',
        'worksheet' : 'str',
        'table_name' : 'str',
        'cell_area' : 'str',
        'has_header' : 'bool'
    }

    attribute_map = {
        'tag' : 'Tag' ,
        'data_source' : 'DataSource' ,
        'file_info' : 'FileInfo' ,
        'worksheet' : 'Worksheet' ,
        'table_name' : 'TableName' ,
        'cell_area' : 'CellArea' ,
        'has_header' : 'HasHeader' 
    }

    @staticmethod
    def get_swagger_types():
        return CombinationSourceData.swagger_types

    @staticmethod
    def get_attribute_map():
        return CombinationSourceData.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,tag=None ,data_source=None ,file_info=None ,worksheet=None ,table_name=None ,cell_area=None ,has_header=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        CombinationSourceData - a model defined in Swagger
        """
        self.container['tag'] = None 
        self.container['data_source'] = None 
        self.container['file_info'] = None 
        self.container['worksheet'] = None 
        self.container['table_name'] = None 
        self.container['cell_area'] = None 
        self.container['has_header'] = None 
        params = locals()
        self.tag = tag
        if 'tag' in params:
            self.tag = params["tag"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.file_info = file_info
        if 'file_info' in params:
            self.file_info = params["file_info"]


             
        self.worksheet = worksheet
        if 'worksheet' in params:
            self.worksheet = params["worksheet"]


             
        self.table_name = table_name
        if 'table_name' in params:
            self.table_name = params["table_name"]


             
        self.cell_area = cell_area
        if 'cell_area' in params:
            self.cell_area = params["cell_area"]


             
        self.has_header = has_header
        if 'has_header' in params:
            self.has_header = params["has_header"]


             

    @property
    def tag(self):
        return self.container['tag']

    @tag.setter
    def tag(self, tag):
        self.container['tag'] = tag 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def file_info(self):
        return self.container['file_info']

    @file_info.setter
    def file_info(self, file_info):
        self.container['file_info'] = file_info 
    @property
    def worksheet(self):
        return self.container['worksheet']

    @worksheet.setter
    def worksheet(self, worksheet):
        self.container['worksheet'] = worksheet 
    @property
    def table_name(self):
        return self.container['table_name']

    @table_name.setter
    def table_name(self, table_name):
        self.container['table_name'] = table_name 
    @property
    def cell_area(self):
        return self.container['cell_area']

    @cell_area.setter
    def cell_area(self, cell_area):
        self.container['cell_area'] = cell_area 
    @property
    def has_header(self):
        return self.container['has_header']

    @has_header.setter
    def has_header(self, has_header):
        self.container['has_header'] = has_header 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CombinationSourceData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    