# coding: utf-8
"""
<copyright company="Aspose" file="Commentpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Comment(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'cell_name' : 'str',
        'author' : 'str',
        'html_note' : 'str',
        'note' : 'str',
        'auto_size' : 'bool',
        'is_visible' : 'bool',
        'width' : 'int',
        'height' : 'int',
        'text_horizontal_alignment' : 'str',
        'text_orientation_type' : 'str',
        'text_vertical_alignment' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'cell_name' : 'CellName' ,
        'author' : 'Author' ,
        'html_note' : 'HtmlNote' ,
        'note' : 'Note' ,
        'auto_size' : 'AutoSize' ,
        'is_visible' : 'IsVisible' ,
        'width' : 'Width' ,
        'height' : 'Height' ,
        'text_horizontal_alignment' : 'TextHorizontalAlignment' ,
        'text_orientation_type' : 'TextOrientationType' ,
        'text_vertical_alignment' : 'TextVerticalAlignment' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Comment.swagger_types

    @staticmethod
    def get_attribute_map():
        return Comment.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,cell_name=None ,author=None ,html_note=None ,note=None ,auto_size=None ,is_visible=None ,width=None ,height=None ,text_horizontal_alignment=None ,text_orientation_type=None ,text_vertical_alignment=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Comment - a model defined in Swagger
        """
        self.container['cell_name'] = None 
        self.container['author'] = None 
        self.container['html_note'] = None 
        self.container['note'] = None 
        self.container['auto_size'] = None 
        self.container['is_visible'] = None 
        self.container['width'] = None 
        self.container['height'] = None 
        self.container['text_horizontal_alignment'] = None 
        self.container['text_orientation_type'] = None 
        self.container['text_vertical_alignment'] = None 
        self.container['link'] = None 
        params = locals()
        self.cell_name = cell_name
        if 'cell_name' in params:
            self.cell_name = params["cell_name"]


             
        self.author = author
        if 'author' in params:
            self.author = params["author"]


             
        self.html_note = html_note
        if 'html_note' in params:
            self.html_note = params["html_note"]


             
        self.note = note
        if 'note' in params:
            self.note = params["note"]


             
        self.auto_size = auto_size
        if 'auto_size' in params:
            self.auto_size = params["auto_size"]


             
        self.is_visible = is_visible
        if 'is_visible' in params:
            self.is_visible = params["is_visible"]


             
        self.width = width
        if 'width' in params:
            self.width = params["width"]


             
        self.height = height
        if 'height' in params:
            self.height = params["height"]


             
        self.text_horizontal_alignment = text_horizontal_alignment
        if 'text_horizontal_alignment' in params:
            self.text_horizontal_alignment = params["text_horizontal_alignment"]


             
        self.text_orientation_type = text_orientation_type
        if 'text_orientation_type' in params:
            self.text_orientation_type = params["text_orientation_type"]


             
        self.text_vertical_alignment = text_vertical_alignment
        if 'text_vertical_alignment' in params:
            self.text_vertical_alignment = params["text_vertical_alignment"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def cell_name(self):
        return self.container['cell_name']

    @cell_name.setter
    def cell_name(self, cell_name):
        self.container['cell_name'] = cell_name 
    @property
    def author(self):
        return self.container['author']

    @author.setter
    def author(self, author):
        self.container['author'] = author 
    @property
    def html_note(self):
        return self.container['html_note']

    @html_note.setter
    def html_note(self, html_note):
        self.container['html_note'] = html_note 
    @property
    def note(self):
        return self.container['note']

    @note.setter
    def note(self, note):
        self.container['note'] = note 
    @property
    def auto_size(self):
        return self.container['auto_size']

    @auto_size.setter
    def auto_size(self, auto_size):
        self.container['auto_size'] = auto_size 
    @property
    def is_visible(self):
        return self.container['is_visible']

    @is_visible.setter
    def is_visible(self, is_visible):
        self.container['is_visible'] = is_visible 
    @property
    def width(self):
        return self.container['width']

    @width.setter
    def width(self, width):
        self.container['width'] = width 
    @property
    def height(self):
        return self.container['height']

    @height.setter
    def height(self, height):
        self.container['height'] = height 
    @property
    def text_horizontal_alignment(self):
        return self.container['text_horizontal_alignment']

    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, text_horizontal_alignment):
        self.container['text_horizontal_alignment'] = text_horizontal_alignment 
    @property
    def text_orientation_type(self):
        return self.container['text_orientation_type']

    @text_orientation_type.setter
    def text_orientation_type(self, text_orientation_type):
        self.container['text_orientation_type'] = text_orientation_type 
    @property
    def text_vertical_alignment(self):
        return self.container['text_vertical_alignment']

    @text_vertical_alignment.setter
    def text_vertical_alignment(self, text_vertical_alignment):
        self.container['text_vertical_alignment'] = text_vertical_alignment 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Comment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    