# coding: utf-8
"""
<copyright company="Aspose" file="ConvertTaskParameterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ConvertTaskParameter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'data_source' : 'DataSource',
        'workbook' : 'FileSource',
        'destination_file' : 'str',
        'region' : 'str',
        'save_options' : 'SaveOptions'
    }

    attribute_map = {
        'data_source' : 'DataSource' ,
        'workbook' : 'Workbook' ,
        'destination_file' : 'DestinationFile' ,
        'region' : 'Region' ,
        'save_options' : 'SaveOptions' 
    }

    @staticmethod
    def get_swagger_types():
        return ConvertTaskParameter.swagger_types

    @staticmethod
    def get_attribute_map():
        return ConvertTaskParameter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,data_source=None ,workbook=None ,destination_file=None ,region=None ,save_options=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ConvertTaskParameter - a model defined in Swagger
        """
        self.container['data_source'] = None 
        self.container['workbook'] = None 
        self.container['destination_file'] = None 
        self.container['region'] = None 
        self.container['save_options'] = None 
        params = locals()
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.workbook = workbook
        if 'workbook' in params:
            self.workbook = params["workbook"]


             
        self.destination_file = destination_file
        if 'destination_file' in params:
            self.destination_file = params["destination_file"]


             
        self.region = region
        if 'region' in params:
            self.region = params["region"]


             
        self.save_options = save_options
        if 'save_options' in params:
            self.save_options = params["save_options"]


             

    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def workbook(self):
        return self.container['workbook']

    @workbook.setter
    def workbook(self, workbook):
        self.container['workbook'] = workbook 
    @property
    def destination_file(self):
        return self.container['destination_file']

    @destination_file.setter
    def destination_file(self, destination_file):
        self.container['destination_file'] = destination_file 
    @property
    def region(self):
        return self.container['region']

    @region.setter
    def region(self, region):
        self.container['region'] = region 
    @property
    def save_options(self):
        return self.container['save_options']

    @save_options.setter
    def save_options(self, save_options):
        self.container['save_options'] = save_options 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ConvertTaskParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    