# coding: utf-8
"""
<copyright company="Aspose" file="ConvertWorksheetTaskParameterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ConvertWorksheetTaskParameter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'data_source' : 'DataSource',
        'workbook' : 'FileSource',
        'sheet' : 'str',
        'target_data_source' : 'DataSource',
        'target' : 'FileSource',
        'format' : 'str',
        'area' : 'str',
        'page_index' : 'int',
        'vertical_resolution' : 'int',
        'horizontal_resolution' : 'int'
    }

    attribute_map = {
        'data_source' : 'DataSource' ,
        'workbook' : 'Workbook' ,
        'sheet' : 'Sheet' ,
        'target_data_source' : 'TargetDataSource' ,
        'target' : 'Target' ,
        'format' : 'Format' ,
        'area' : 'Area' ,
        'page_index' : 'PageIndex' ,
        'vertical_resolution' : 'VerticalResolution' ,
        'horizontal_resolution' : 'HorizontalResolution' 
    }

    @staticmethod
    def get_swagger_types():
        return ConvertWorksheetTaskParameter.swagger_types

    @staticmethod
    def get_attribute_map():
        return ConvertWorksheetTaskParameter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,data_source=None ,workbook=None ,sheet=None ,target_data_source=None ,target=None ,format=None ,area=None ,page_index=None ,vertical_resolution=None ,horizontal_resolution=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ConvertWorksheetTaskParameter - a model defined in Swagger
        """
        self.container['data_source'] = None 
        self.container['workbook'] = None 
        self.container['sheet'] = None 
        self.container['target_data_source'] = None 
        self.container['target'] = None 
        self.container['format'] = None 
        self.container['area'] = None 
        self.container['page_index'] = None 
        self.container['vertical_resolution'] = None 
        self.container['horizontal_resolution'] = None 
        params = locals()
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.workbook = workbook
        if 'workbook' in params:
            self.workbook = params["workbook"]


             
        self.sheet = sheet
        if 'sheet' in params:
            self.sheet = params["sheet"]


             
        self.target_data_source = target_data_source
        if 'target_data_source' in params:
            self.target_data_source = params["target_data_source"]


             
        self.target = target
        if 'target' in params:
            self.target = params["target"]


             
        self.format = format
        if 'format' in params:
            self.format = params["format"]


             
        self.area = area
        if 'area' in params:
            self.area = params["area"]


             
        self.page_index = page_index
        if 'page_index' in params:
            self.page_index = params["page_index"]


             
        self.vertical_resolution = vertical_resolution
        if 'vertical_resolution' in params:
            self.vertical_resolution = params["vertical_resolution"]


             
        self.horizontal_resolution = horizontal_resolution
        if 'horizontal_resolution' in params:
            self.horizontal_resolution = params["horizontal_resolution"]


             

    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def workbook(self):
        return self.container['workbook']

    @workbook.setter
    def workbook(self, workbook):
        self.container['workbook'] = workbook 
    @property
    def sheet(self):
        return self.container['sheet']

    @sheet.setter
    def sheet(self, sheet):
        self.container['sheet'] = sheet 
    @property
    def target_data_source(self):
        return self.container['target_data_source']

    @target_data_source.setter
    def target_data_source(self, target_data_source):
        self.container['target_data_source'] = target_data_source 
    @property
    def target(self):
        return self.container['target']

    @target.setter
    def target(self, target):
        self.container['target'] = target 
    @property
    def format(self):
        return self.container['format']

    @format.setter
    def format(self, format):
        self.container['format'] = format 
    @property
    def area(self):
        return self.container['area']

    @area.setter
    def area(self, area):
        self.container['area'] = area 
    @property
    def page_index(self):
        return self.container['page_index']

    @page_index.setter
    def page_index(self, page_index):
        self.container['page_index'] = page_index 
    @property
    def vertical_resolution(self):
        return self.container['vertical_resolution']

    @vertical_resolution.setter
    def vertical_resolution(self, vertical_resolution):
        self.container['vertical_resolution'] = vertical_resolution 
    @property
    def horizontal_resolution(self):
        return self.container['horizontal_resolution']

    @horizontal_resolution.setter
    def horizontal_resolution(self, horizontal_resolution):
        self.container['horizontal_resolution'] = horizontal_resolution 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ConvertWorksheetTaskParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    