# coding: utf-8
"""
<copyright company="Aspose" file="DataSorterKeypy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DataSorterKey(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'order' : 'str',
        'index' : 'int',
        'type' : 'str',
        'icon_set_type' : 'str',
        'icon_id' : 'int',
        'color' : 'Color'
    }

    attribute_map = {
        'order' : 'Order' ,
        'index' : 'Index' ,
        'type' : 'Type' ,
        'icon_set_type' : 'IconSetType' ,
        'icon_id' : 'IconId' ,
        'color' : 'Color' 
    }

    @staticmethod
    def get_swagger_types():
        return DataSorterKey.swagger_types

    @staticmethod
    def get_attribute_map():
        return DataSorterKey.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,order=None ,index=None ,type=None ,icon_set_type=None ,icon_id=None ,color=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DataSorterKey - a model defined in Swagger
        """
        self.container['order'] = None 
        self.container['index'] = None 
        self.container['type'] = None 
        self.container['icon_set_type'] = None 
        self.container['icon_id'] = None 
        self.container['color'] = None 
        params = locals()
        self.order = order
        if 'order' in params:
            self.order = params["order"]


             
        self.index = index
        if 'index' in params:
            self.index = params["index"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.icon_set_type = icon_set_type
        if 'icon_set_type' in params:
            self.icon_set_type = params["icon_set_type"]


             
        self.icon_id = icon_id
        if 'icon_id' in params:
            self.icon_id = params["icon_id"]


             
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             

    @property
    def order(self):
        return self.container['order']

    @order.setter
    def order(self, order):
        self.container['order'] = order 
    @property
    def index(self):
        return self.container['index']

    @index.setter
    def index(self, index):
        self.container['index'] = index 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def icon_set_type(self):
        return self.container['icon_set_type']

    @icon_set_type.setter
    def icon_set_type(self, icon_set_type):
        self.container['icon_set_type'] = icon_set_type 
    @property
    def icon_id(self):
        return self.container['icon_id']

    @icon_id.setter
    def icon_id(self, icon_id):
        self.container['icon_id'] = icon_id 
    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataSorterKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    