# coding: utf-8
"""
<copyright company="Aspose" file="DiscoverChartpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DiscoverChart(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'sheet_name' : 'str',
        'title' : 'str',
        'type' : 'str',
        'data_range' : 'str',
        'thumbnail' : 'str'
    }

    attribute_map = {
        'name' : 'Name' ,
        'sheet_name' : 'SheetName' ,
        'title' : 'Title' ,
        'type' : 'Type' ,
        'data_range' : 'DataRange' ,
        'thumbnail' : 'Thumbnail' 
    }

    @staticmethod
    def get_swagger_types():
        return DiscoverChart.swagger_types

    @staticmethod
    def get_attribute_map():
        return DiscoverChart.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,sheet_name=None ,title=None ,type=None ,data_range=None ,thumbnail=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DiscoverChart - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['sheet_name'] = None 
        self.container['title'] = None 
        self.container['type'] = None 
        self.container['data_range'] = None 
        self.container['thumbnail'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.sheet_name = sheet_name
        if 'sheet_name' in params:
            self.sheet_name = params["sheet_name"]


             
        self.title = title
        if 'title' in params:
            self.title = params["title"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.data_range = data_range
        if 'data_range' in params:
            self.data_range = params["data_range"]


             
        self.thumbnail = thumbnail
        if 'thumbnail' in params:
            self.thumbnail = params["thumbnail"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def sheet_name(self):
        return self.container['sheet_name']

    @sheet_name.setter
    def sheet_name(self, sheet_name):
        self.container['sheet_name'] = sheet_name 
    @property
    def title(self):
        return self.container['title']

    @title.setter
    def title(self, title):
        self.container['title'] = title 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def data_range(self):
        return self.container['data_range']

    @data_range.setter
    def data_range(self, data_range):
        self.container['data_range'] = data_range 
    @property
    def thumbnail(self):
        return self.container['thumbnail']

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        self.container['thumbnail'] = thumbnail 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DiscoverChart):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    