# coding: utf-8
"""
<copyright company="Aspose" file="DiscoverPivotTablepy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DiscoverPivotTable(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'title' : 'str',
        'data_range' : 'str',
        'pivot_field_rows' : 'list[int]',
        'pivot_field_columns' : 'list[int]',
        'pivot_field_data' : 'list[int]',
        'thumbnail' : 'str'
    }

    attribute_map = {
        'name' : 'Name' ,
        'title' : 'Title' ,
        'data_range' : 'DataRange' ,
        'pivot_field_rows' : 'PivotFieldRows' ,
        'pivot_field_columns' : 'PivotFieldColumns' ,
        'pivot_field_data' : 'PivotFieldData' ,
        'thumbnail' : 'Thumbnail' 
    }

    @staticmethod
    def get_swagger_types():
        return DiscoverPivotTable.swagger_types

    @staticmethod
    def get_attribute_map():
        return DiscoverPivotTable.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,title=None ,data_range=None ,pivot_field_rows=None ,pivot_field_columns=None ,pivot_field_data=None ,thumbnail=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DiscoverPivotTable - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['title'] = None 
        self.container['data_range'] = None 
        self.container['pivot_field_rows'] = None 
        self.container['pivot_field_columns'] = None 
        self.container['pivot_field_data'] = None 
        self.container['thumbnail'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.title = title
        if 'title' in params:
            self.title = params["title"]


             
        self.data_range = data_range
        if 'data_range' in params:
            self.data_range = params["data_range"]


             
        self.pivot_field_rows = pivot_field_rows
        if 'pivot_field_rows' in params:
            self.pivot_field_rows = params["pivot_field_rows"]


             
        self.pivot_field_columns = pivot_field_columns
        if 'pivot_field_columns' in params:
            self.pivot_field_columns = params["pivot_field_columns"]


             
        self.pivot_field_data = pivot_field_data
        if 'pivot_field_data' in params:
            self.pivot_field_data = params["pivot_field_data"]


             
        self.thumbnail = thumbnail
        if 'thumbnail' in params:
            self.thumbnail = params["thumbnail"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def title(self):
        return self.container['title']

    @title.setter
    def title(self, title):
        self.container['title'] = title 
    @property
    def data_range(self):
        return self.container['data_range']

    @data_range.setter
    def data_range(self, data_range):
        self.container['data_range'] = data_range 
    @property
    def pivot_field_rows(self):
        return self.container['pivot_field_rows']

    @pivot_field_rows.setter
    def pivot_field_rows(self, pivot_field_rows):
        self.container['pivot_field_rows'] = pivot_field_rows 
    @property
    def pivot_field_columns(self):
        return self.container['pivot_field_columns']

    @pivot_field_columns.setter
    def pivot_field_columns(self, pivot_field_columns):
        self.container['pivot_field_columns'] = pivot_field_columns 
    @property
    def pivot_field_data(self):
        return self.container['pivot_field_data']

    @pivot_field_data.setter
    def pivot_field_data(self, pivot_field_data):
        self.container['pivot_field_data'] = pivot_field_data 
    @property
    def thumbnail(self):
        return self.container['thumbnail']

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        self.container['thumbnail'] = thumbnail 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DiscoverPivotTable):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    