# coding: utf-8
"""
<copyright company="Aspose" file="DynamicFilterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DynamicFilter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'dynamic_filter_type' : 'str',
        'max_value' : 'str',
        'value' : 'str'
    }

    attribute_map = {
        'dynamic_filter_type' : 'DynamicFilterType' ,
        'max_value' : 'MaxValue' ,
        'value' : 'Value' 
    }

    @staticmethod
    def get_swagger_types():
        return DynamicFilter.swagger_types

    @staticmethod
    def get_attribute_map():
        return DynamicFilter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,dynamic_filter_type=None ,max_value=None ,value=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DynamicFilter - a model defined in Swagger
        """
        self.container['dynamic_filter_type'] = None 
        self.container['max_value'] = None 
        self.container['value'] = None 
        params = locals()
        self.dynamic_filter_type = dynamic_filter_type
        if 'dynamic_filter_type' in params:
            self.dynamic_filter_type = params["dynamic_filter_type"]


             
        self.max_value = max_value
        if 'max_value' in params:
            self.max_value = params["max_value"]


             
        self.value = value
        if 'value' in params:
            self.value = params["value"]


             

    @property
    def dynamic_filter_type(self):
        return self.container['dynamic_filter_type']

    @dynamic_filter_type.setter
    def dynamic_filter_type(self, dynamic_filter_type):
        self.container['dynamic_filter_type'] = dynamic_filter_type 
    @property
    def max_value(self):
        return self.container['max_value']

    @max_value.setter
    def max_value(self, max_value):
        self.container['max_value'] = max_value 
    @property
    def value(self):
        return self.container['value']

    @value.setter
    def value(self, value):
        self.container['value'] = value 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DynamicFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    