# coding: utf-8
"""
<copyright company="Aspose" file="FilterColumnpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class FilterColumn(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'field_index' : 'int',
        'filter_type' : 'str',
        'multiple_filters' : 'MultipleFilters',
        'color_filter' : 'ColorFilter',
        'custom_filters' : 'list[CustomFilter]',
        'dynamic_filter' : 'DynamicFilter',
        'icon_filter' : 'IconFilter',
        'top10_filter' : 'Top10Filter',
        'visibledropdown' : 'str'
    }

    attribute_map = {
        'field_index' : 'FieldIndex' ,
        'filter_type' : 'FilterType' ,
        'multiple_filters' : 'MultipleFilters' ,
        'color_filter' : 'ColorFilter' ,
        'custom_filters' : 'CustomFilters' ,
        'dynamic_filter' : 'DynamicFilter' ,
        'icon_filter' : 'IconFilter' ,
        'top10_filter' : 'Top10Filter' ,
        'visibledropdown' : 'Visibledropdown' 
    }

    @staticmethod
    def get_swagger_types():
        return FilterColumn.swagger_types

    @staticmethod
    def get_attribute_map():
        return FilterColumn.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,field_index=None ,filter_type=None ,multiple_filters=None ,color_filter=None ,custom_filters=None ,dynamic_filter=None ,icon_filter=None ,top10_filter=None ,visibledropdown=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        FilterColumn - a model defined in Swagger
        """
        self.container['field_index'] = None 
        self.container['filter_type'] = None 
        self.container['multiple_filters'] = None 
        self.container['color_filter'] = None 
        self.container['custom_filters'] = None 
        self.container['dynamic_filter'] = None 
        self.container['icon_filter'] = None 
        self.container['top10_filter'] = None 
        self.container['visibledropdown'] = None 
        params = locals()
        self.field_index = field_index
        if 'field_index' in params:
            self.field_index = params["field_index"]


             
        self.filter_type = filter_type
        if 'filter_type' in params:
            self.filter_type = params["filter_type"]


             
        self.multiple_filters = multiple_filters
        if 'multiple_filters' in params:
            self.multiple_filters = params["multiple_filters"]


             
        self.color_filter = color_filter
        if 'color_filter' in params:
            self.color_filter = params["color_filter"]


             
        self.custom_filters = custom_filters
        if 'custom_filters' in params:
            self.custom_filters = params["custom_filters"]


             
        self.dynamic_filter = dynamic_filter
        if 'dynamic_filter' in params:
            self.dynamic_filter = params["dynamic_filter"]


             
        self.icon_filter = icon_filter
        if 'icon_filter' in params:
            self.icon_filter = params["icon_filter"]


             
        self.top10_filter = top10_filter
        if 'top10_filter' in params:
            self.top10_filter = params["top10_filter"]


             
        self.visibledropdown = visibledropdown
        if 'visibledropdown' in params:
            self.visibledropdown = params["visibledropdown"]


             

    @property
    def field_index(self):
        return self.container['field_index']

    @field_index.setter
    def field_index(self, field_index):
        self.container['field_index'] = field_index 
    @property
    def filter_type(self):
        return self.container['filter_type']

    @filter_type.setter
    def filter_type(self, filter_type):
        self.container['filter_type'] = filter_type 
    @property
    def multiple_filters(self):
        return self.container['multiple_filters']

    @multiple_filters.setter
    def multiple_filters(self, multiple_filters):
        self.container['multiple_filters'] = multiple_filters 
    @property
    def color_filter(self):
        return self.container['color_filter']

    @color_filter.setter
    def color_filter(self, color_filter):
        self.container['color_filter'] = color_filter 
    @property
    def custom_filters(self):
        return self.container['custom_filters']

    @custom_filters.setter
    def custom_filters(self, custom_filters):
        self.container['custom_filters'] = custom_filters 
    @property
    def dynamic_filter(self):
        return self.container['dynamic_filter']

    @dynamic_filter.setter
    def dynamic_filter(self, dynamic_filter):
        self.container['dynamic_filter'] = dynamic_filter 
    @property
    def icon_filter(self):
        return self.container['icon_filter']

    @icon_filter.setter
    def icon_filter(self, icon_filter):
        self.container['icon_filter'] = icon_filter 
    @property
    def top10_filter(self):
        return self.container['top10_filter']

    @top10_filter.setter
    def top10_filter(self, top10_filter):
        self.container['top10_filter'] = top10_filter 
    @property
    def visibledropdown(self):
        return self.container['visibledropdown']

    @visibledropdown.setter
    def visibledropdown(self, visibledropdown):
        self.container['visibledropdown'] = visibledropdown 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FilterColumn):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    