# coding: utf-8
"""
<copyright company="Aspose" file="FormulaFormatConditionpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class FormulaFormatCondition(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'formula1' : 'str',
        'formula2' : 'str',
        'operator' : 'str'
    }

    attribute_map = {
        'formula1' : 'Formula1' ,
        'formula2' : 'Formula2' ,
        'operator' : 'Operator' 
    }

    @staticmethod
    def get_swagger_types():
        return FormulaFormatCondition.swagger_types

    @staticmethod
    def get_attribute_map():
        return FormulaFormatCondition.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,formula1=None ,formula2=None ,operator=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        FormulaFormatCondition - a model defined in Swagger
        """
        self.container['formula1'] = None 
        self.container['formula2'] = None 
        self.container['operator'] = None 
        params = locals()
        self.formula1 = formula1
        if 'formula1' in params:
            self.formula1 = params["formula1"]


             
        self.formula2 = formula2
        if 'formula2' in params:
            self.formula2 = params["formula2"]


             
        self.operator = operator
        if 'operator' in params:
            self.operator = params["operator"]


             

    @property
    def formula1(self):
        return self.container['formula1']

    @formula1.setter
    def formula1(self, formula1):
        self.container['formula1'] = formula1 
    @property
    def formula2(self):
        return self.container['formula2']

    @formula2.setter
    def formula2(self, formula2):
        self.container['formula2'] = formula2 
    @property
    def operator(self):
        return self.container['operator']

    @operator.setter
    def operator(self, operator):
        self.container['operator'] = operator 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FormulaFormatCondition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    