# coding: utf-8
"""
<copyright company="Aspose" file="GlobalizationSettingspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class GlobalizationSettings(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'chart_settings' : 'ChartGlobalizationSettings',
        'pivot_settings' : 'PivotGlobalizationSettings',
        'list_separator' : 'str',
        'row_separator_of_formula_array' : 'str',
        'column_separator_of_formula_array' : 'str'
    }

    attribute_map = {
        'chart_settings' : 'ChartSettings' ,
        'pivot_settings' : 'PivotSettings' ,
        'list_separator' : 'ListSeparator' ,
        'row_separator_of_formula_array' : 'RowSeparatorOfFormulaArray' ,
        'column_separator_of_formula_array' : 'ColumnSeparatorOfFormulaArray' 
    }

    @staticmethod
    def get_swagger_types():
        return GlobalizationSettings.swagger_types

    @staticmethod
    def get_attribute_map():
        return GlobalizationSettings.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,chart_settings=None ,pivot_settings=None ,list_separator=None ,row_separator_of_formula_array=None ,column_separator_of_formula_array=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        GlobalizationSettings - a model defined in Swagger
        """
        self.container['chart_settings'] = None 
        self.container['pivot_settings'] = None 
        self.container['list_separator'] = None 
        self.container['row_separator_of_formula_array'] = None 
        self.container['column_separator_of_formula_array'] = None 
        params = locals()
        self.chart_settings = chart_settings
        if 'chart_settings' in params:
            self.chart_settings = params["chart_settings"]


             
        self.pivot_settings = pivot_settings
        if 'pivot_settings' in params:
            self.pivot_settings = params["pivot_settings"]


             
        self.list_separator = list_separator
        if 'list_separator' in params:
            self.list_separator = params["list_separator"]


             
        self.row_separator_of_formula_array = row_separator_of_formula_array
        if 'row_separator_of_formula_array' in params:
            self.row_separator_of_formula_array = params["row_separator_of_formula_array"]


             
        self.column_separator_of_formula_array = column_separator_of_formula_array
        if 'column_separator_of_formula_array' in params:
            self.column_separator_of_formula_array = params["column_separator_of_formula_array"]


             

    @property
    def chart_settings(self):
        return self.container['chart_settings']

    @chart_settings.setter
    def chart_settings(self, chart_settings):
        self.container['chart_settings'] = chart_settings 
    @property
    def pivot_settings(self):
        return self.container['pivot_settings']

    @pivot_settings.setter
    def pivot_settings(self, pivot_settings):
        self.container['pivot_settings'] = pivot_settings 
    @property
    def list_separator(self):
        return self.container['list_separator']

    @list_separator.setter
    def list_separator(self, list_separator):
        self.container['list_separator'] = list_separator 
    @property
    def row_separator_of_formula_array(self):
        return self.container['row_separator_of_formula_array']

    @row_separator_of_formula_array.setter
    def row_separator_of_formula_array(self, row_separator_of_formula_array):
        self.container['row_separator_of_formula_array'] = row_separator_of_formula_array 
    @property
    def column_separator_of_formula_array(self):
        return self.container['column_separator_of_formula_array']

    @column_separator_of_formula_array.setter
    def column_separator_of_formula_array(self, column_separator_of_formula_array):
        self.container['column_separator_of_formula_array'] = column_separator_of_formula_array 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, GlobalizationSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    