# coding: utf-8
"""
<copyright company="Aspose" file="Hyperlinkpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Hyperlink(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'address' : 'str',
        'area' : 'CellArea',
        'screen_tip' : 'str',
        'text_to_display' : 'str',
        'link_type' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'address' : 'Address' ,
        'area' : 'Area' ,
        'screen_tip' : 'ScreenTip' ,
        'text_to_display' : 'TextToDisplay' ,
        'link_type' : 'LinkType' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Hyperlink.swagger_types

    @staticmethod
    def get_attribute_map():
        return Hyperlink.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,address=None ,area=None ,screen_tip=None ,text_to_display=None ,link_type=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Hyperlink - a model defined in Swagger
        """
        self.container['address'] = None 
        self.container['area'] = None 
        self.container['screen_tip'] = None 
        self.container['text_to_display'] = None 
        self.container['link_type'] = None 
        self.container['link'] = None 
        params = locals()
        self.address = address
        if 'address' in params:
            self.address = params["address"]


             
        self.area = area
        if 'area' in params:
            self.area = params["area"]


             
        self.screen_tip = screen_tip
        if 'screen_tip' in params:
            self.screen_tip = params["screen_tip"]


             
        self.text_to_display = text_to_display
        if 'text_to_display' in params:
            self.text_to_display = params["text_to_display"]


             
        self.link_type = link_type
        if 'link_type' in params:
            self.link_type = params["link_type"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def address(self):
        return self.container['address']

    @address.setter
    def address(self, address):
        self.container['address'] = address 
    @property
    def area(self):
        return self.container['area']

    @area.setter
    def area(self, area):
        self.container['area'] = area 
    @property
    def screen_tip(self):
        return self.container['screen_tip']

    @screen_tip.setter
    def screen_tip(self, screen_tip):
        self.container['screen_tip'] = screen_tip 
    @property
    def text_to_display(self):
        return self.container['text_to_display']

    @text_to_display.setter
    def text_to_display(self, text_to_display):
        self.container['text_to_display'] = text_to_display 
    @property
    def link_type(self):
        return self.container['link_type']

    @link_type.setter
    def link_type(self, link_type):
        self.container['link_type'] = link_type 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Hyperlink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    