# coding: utf-8
"""
<copyright company="Aspose" file="IconSetpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class IconSet(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'cf_icons' : 'list[ConditionalFormattingIcon]',
        'cfvos' : 'list[ConditionalFormattingValue]',
        'is_custom' : 'bool',
        'reverse' : 'bool',
        'show_value' : 'bool',
        'icon_set_type' : 'str'
    }

    attribute_map = {
        'cf_icons' : 'CfIcons' ,
        'cfvos' : 'Cfvos' ,
        'is_custom' : 'IsCustom' ,
        'reverse' : 'Reverse' ,
        'show_value' : 'ShowValue' ,
        'icon_set_type' : 'IconSetType' 
    }

    @staticmethod
    def get_swagger_types():
        return IconSet.swagger_types

    @staticmethod
    def get_attribute_map():
        return IconSet.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,cf_icons=None ,cfvos=None ,is_custom=None ,reverse=None ,show_value=None ,icon_set_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        IconSet - a model defined in Swagger
        """
        self.container['cf_icons'] = None 
        self.container['cfvos'] = None 
        self.container['is_custom'] = None 
        self.container['reverse'] = None 
        self.container['show_value'] = None 
        self.container['icon_set_type'] = None 
        params = locals()
        self.cf_icons = cf_icons
        if 'cf_icons' in params:
            self.cf_icons = params["cf_icons"]


             
        self.cfvos = cfvos
        if 'cfvos' in params:
            self.cfvos = params["cfvos"]


             
        self.is_custom = is_custom
        if 'is_custom' in params:
            self.is_custom = params["is_custom"]


             
        self.reverse = reverse
        if 'reverse' in params:
            self.reverse = params["reverse"]


             
        self.show_value = show_value
        if 'show_value' in params:
            self.show_value = params["show_value"]


             
        self.icon_set_type = icon_set_type
        if 'icon_set_type' in params:
            self.icon_set_type = params["icon_set_type"]


             

    @property
    def cf_icons(self):
        return self.container['cf_icons']

    @cf_icons.setter
    def cf_icons(self, cf_icons):
        self.container['cf_icons'] = cf_icons 
    @property
    def cfvos(self):
        return self.container['cfvos']

    @cfvos.setter
    def cfvos(self, cfvos):
        self.container['cfvos'] = cfvos 
    @property
    def is_custom(self):
        return self.container['is_custom']

    @is_custom.setter
    def is_custom(self, is_custom):
        self.container['is_custom'] = is_custom 
    @property
    def reverse(self):
        return self.container['reverse']

    @reverse.setter
    def reverse(self, reverse):
        self.container['reverse'] = reverse 
    @property
    def show_value(self):
        return self.container['show_value']

    @show_value.setter
    def show_value(self, show_value):
        self.container['show_value'] = show_value 
    @property
    def icon_set_type(self):
        return self.container['icon_set_type']

    @icon_set_type.setter
    def icon_set_type(self, icon_set_type):
        self.container['icon_set_type'] = icon_set_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, IconSet):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    