# coding: utf-8
"""
<copyright company="Aspose" file="ImageOrPrintOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ImageOrPrintOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'text_cross_type' : 'str',
        'gridline_type' : 'str',
        'output_blank_page_when_nothing_to_print' : 'bool',
        'check_workbook_default_font' : 'bool',
        'default_font' : 'str',
        'is_optimized' : 'bool',
        'page_count' : 'int',
        'page_index' : 'int',
        'is_font_substitution_char_granularity' : 'bool',
        'transparent' : 'bool',
        'only_area' : 'bool',
        'svg_fit_to_view_port' : 'bool',
        'embeded_image_name_in_svg' : 'str',
        'all_columns_in_one_page_per_sheet' : 'bool',
        'print_with_status_dialog' : 'bool',
        'horizontal_resolution' : 'int',
        'vertical_resolution' : 'int',
        'default_edit_language' : 'str',
        'tiff_color_depth' : 'str',
        'tiff_compression' : 'str',
        'printing_page' : 'str',
        'quality' : 'int',
        'image_type' : 'str',
        'one_page_per_sheet' : 'bool',
        'tiff_binarization_method' : 'str'
    }

    attribute_map = {
        'text_cross_type' : 'TextCrossType' ,
        'gridline_type' : 'GridlineType' ,
        'output_blank_page_when_nothing_to_print' : 'OutputBlankPageWhenNothingToPrint' ,
        'check_workbook_default_font' : 'CheckWorkbookDefaultFont' ,
        'default_font' : 'DefaultFont' ,
        'is_optimized' : 'IsOptimized' ,
        'page_count' : 'PageCount' ,
        'page_index' : 'PageIndex' ,
        'is_font_substitution_char_granularity' : 'IsFontSubstitutionCharGranularity' ,
        'transparent' : 'Transparent' ,
        'only_area' : 'OnlyArea' ,
        'svg_fit_to_view_port' : 'SVGFitToViewPort' ,
        'embeded_image_name_in_svg' : 'EmbededImageNameInSvg' ,
        'all_columns_in_one_page_per_sheet' : 'AllColumnsInOnePagePerSheet' ,
        'print_with_status_dialog' : 'PrintWithStatusDialog' ,
        'horizontal_resolution' : 'HorizontalResolution' ,
        'vertical_resolution' : 'VerticalResolution' ,
        'default_edit_language' : 'DefaultEditLanguage' ,
        'tiff_color_depth' : 'TiffColorDepth' ,
        'tiff_compression' : 'TiffCompression' ,
        'printing_page' : 'PrintingPage' ,
        'quality' : 'Quality' ,
        'image_type' : 'ImageType' ,
        'one_page_per_sheet' : 'OnePagePerSheet' ,
        'tiff_binarization_method' : 'TiffBinarizationMethod' 
    }

    @staticmethod
    def get_swagger_types():
        return ImageOrPrintOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return ImageOrPrintOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,text_cross_type=None ,gridline_type=None ,output_blank_page_when_nothing_to_print=None ,check_workbook_default_font=None ,default_font=None ,is_optimized=None ,page_count=None ,page_index=None ,is_font_substitution_char_granularity=None ,transparent=None ,only_area=None ,svg_fit_to_view_port=None ,embeded_image_name_in_svg=None ,all_columns_in_one_page_per_sheet=None ,print_with_status_dialog=None ,horizontal_resolution=None ,vertical_resolution=None ,default_edit_language=None ,tiff_color_depth=None ,tiff_compression=None ,printing_page=None ,quality=None ,image_type=None ,one_page_per_sheet=None ,tiff_binarization_method=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ImageOrPrintOptions - a model defined in Swagger
        """
        self.container['text_cross_type'] = None 
        self.container['gridline_type'] = None 
        self.container['output_blank_page_when_nothing_to_print'] = None 
        self.container['check_workbook_default_font'] = None 
        self.container['default_font'] = None 
        self.container['is_optimized'] = None 
        self.container['page_count'] = None 
        self.container['page_index'] = None 
        self.container['is_font_substitution_char_granularity'] = None 
        self.container['transparent'] = None 
        self.container['only_area'] = None 
        self.container['svg_fit_to_view_port'] = None 
        self.container['embeded_image_name_in_svg'] = None 
        self.container['all_columns_in_one_page_per_sheet'] = None 
        self.container['print_with_status_dialog'] = None 
        self.container['horizontal_resolution'] = None 
        self.container['vertical_resolution'] = None 
        self.container['default_edit_language'] = None 
        self.container['tiff_color_depth'] = None 
        self.container['tiff_compression'] = None 
        self.container['printing_page'] = None 
        self.container['quality'] = None 
        self.container['image_type'] = None 
        self.container['one_page_per_sheet'] = None 
        self.container['tiff_binarization_method'] = None 
        params = locals()
        self.text_cross_type = text_cross_type
        if 'text_cross_type' in params:
            self.text_cross_type = params["text_cross_type"]


             
        self.gridline_type = gridline_type
        if 'gridline_type' in params:
            self.gridline_type = params["gridline_type"]


             
        self.output_blank_page_when_nothing_to_print = output_blank_page_when_nothing_to_print
        if 'output_blank_page_when_nothing_to_print' in params:
            self.output_blank_page_when_nothing_to_print = params["output_blank_page_when_nothing_to_print"]


             
        self.check_workbook_default_font = check_workbook_default_font
        if 'check_workbook_default_font' in params:
            self.check_workbook_default_font = params["check_workbook_default_font"]


             
        self.default_font = default_font
        if 'default_font' in params:
            self.default_font = params["default_font"]


             
        self.is_optimized = is_optimized
        if 'is_optimized' in params:
            self.is_optimized = params["is_optimized"]


             
        self.page_count = page_count
        if 'page_count' in params:
            self.page_count = params["page_count"]


             
        self.page_index = page_index
        if 'page_index' in params:
            self.page_index = params["page_index"]


             
        self.is_font_substitution_char_granularity = is_font_substitution_char_granularity
        if 'is_font_substitution_char_granularity' in params:
            self.is_font_substitution_char_granularity = params["is_font_substitution_char_granularity"]


             
        self.transparent = transparent
        if 'transparent' in params:
            self.transparent = params["transparent"]


             
        self.only_area = only_area
        if 'only_area' in params:
            self.only_area = params["only_area"]


             
        self.svg_fit_to_view_port = svg_fit_to_view_port
        if 'svg_fit_to_view_port' in params:
            self.svg_fit_to_view_port = params["svg_fit_to_view_port"]


             
        self.embeded_image_name_in_svg = embeded_image_name_in_svg
        if 'embeded_image_name_in_svg' in params:
            self.embeded_image_name_in_svg = params["embeded_image_name_in_svg"]


             
        self.all_columns_in_one_page_per_sheet = all_columns_in_one_page_per_sheet
        if 'all_columns_in_one_page_per_sheet' in params:
            self.all_columns_in_one_page_per_sheet = params["all_columns_in_one_page_per_sheet"]


             
        self.print_with_status_dialog = print_with_status_dialog
        if 'print_with_status_dialog' in params:
            self.print_with_status_dialog = params["print_with_status_dialog"]


             
        self.horizontal_resolution = horizontal_resolution
        if 'horizontal_resolution' in params:
            self.horizontal_resolution = params["horizontal_resolution"]


             
        self.vertical_resolution = vertical_resolution
        if 'vertical_resolution' in params:
            self.vertical_resolution = params["vertical_resolution"]


             
        self.default_edit_language = default_edit_language
        if 'default_edit_language' in params:
            self.default_edit_language = params["default_edit_language"]


             
        self.tiff_color_depth = tiff_color_depth
        if 'tiff_color_depth' in params:
            self.tiff_color_depth = params["tiff_color_depth"]


             
        self.tiff_compression = tiff_compression
        if 'tiff_compression' in params:
            self.tiff_compression = params["tiff_compression"]


             
        self.printing_page = printing_page
        if 'printing_page' in params:
            self.printing_page = params["printing_page"]


             
        self.quality = quality
        if 'quality' in params:
            self.quality = params["quality"]


             
        self.image_type = image_type
        if 'image_type' in params:
            self.image_type = params["image_type"]


             
        self.one_page_per_sheet = one_page_per_sheet
        if 'one_page_per_sheet' in params:
            self.one_page_per_sheet = params["one_page_per_sheet"]


             
        self.tiff_binarization_method = tiff_binarization_method
        if 'tiff_binarization_method' in params:
            self.tiff_binarization_method = params["tiff_binarization_method"]


             

    @property
    def text_cross_type(self):
        return self.container['text_cross_type']

    @text_cross_type.setter
    def text_cross_type(self, text_cross_type):
        self.container['text_cross_type'] = text_cross_type 
    @property
    def gridline_type(self):
        return self.container['gridline_type']

    @gridline_type.setter
    def gridline_type(self, gridline_type):
        self.container['gridline_type'] = gridline_type 
    @property
    def output_blank_page_when_nothing_to_print(self):
        return self.container['output_blank_page_when_nothing_to_print']

    @output_blank_page_when_nothing_to_print.setter
    def output_blank_page_when_nothing_to_print(self, output_blank_page_when_nothing_to_print):
        self.container['output_blank_page_when_nothing_to_print'] = output_blank_page_when_nothing_to_print 
    @property
    def check_workbook_default_font(self):
        return self.container['check_workbook_default_font']

    @check_workbook_default_font.setter
    def check_workbook_default_font(self, check_workbook_default_font):
        self.container['check_workbook_default_font'] = check_workbook_default_font 
    @property
    def default_font(self):
        return self.container['default_font']

    @default_font.setter
    def default_font(self, default_font):
        self.container['default_font'] = default_font 
    @property
    def is_optimized(self):
        return self.container['is_optimized']

    @is_optimized.setter
    def is_optimized(self, is_optimized):
        self.container['is_optimized'] = is_optimized 
    @property
    def page_count(self):
        return self.container['page_count']

    @page_count.setter
    def page_count(self, page_count):
        self.container['page_count'] = page_count 
    @property
    def page_index(self):
        return self.container['page_index']

    @page_index.setter
    def page_index(self, page_index):
        self.container['page_index'] = page_index 
    @property
    def is_font_substitution_char_granularity(self):
        return self.container['is_font_substitution_char_granularity']

    @is_font_substitution_char_granularity.setter
    def is_font_substitution_char_granularity(self, is_font_substitution_char_granularity):
        self.container['is_font_substitution_char_granularity'] = is_font_substitution_char_granularity 
    @property
    def transparent(self):
        return self.container['transparent']

    @transparent.setter
    def transparent(self, transparent):
        self.container['transparent'] = transparent 
    @property
    def only_area(self):
        return self.container['only_area']

    @only_area.setter
    def only_area(self, only_area):
        self.container['only_area'] = only_area 
    @property
    def svg_fit_to_view_port(self):
        return self.container['svg_fit_to_view_port']

    @svg_fit_to_view_port.setter
    def svg_fit_to_view_port(self, svg_fit_to_view_port):
        self.container['svg_fit_to_view_port'] = svg_fit_to_view_port 
    @property
    def embeded_image_name_in_svg(self):
        return self.container['embeded_image_name_in_svg']

    @embeded_image_name_in_svg.setter
    def embeded_image_name_in_svg(self, embeded_image_name_in_svg):
        self.container['embeded_image_name_in_svg'] = embeded_image_name_in_svg 
    @property
    def all_columns_in_one_page_per_sheet(self):
        return self.container['all_columns_in_one_page_per_sheet']

    @all_columns_in_one_page_per_sheet.setter
    def all_columns_in_one_page_per_sheet(self, all_columns_in_one_page_per_sheet):
        self.container['all_columns_in_one_page_per_sheet'] = all_columns_in_one_page_per_sheet 
    @property
    def print_with_status_dialog(self):
        return self.container['print_with_status_dialog']

    @print_with_status_dialog.setter
    def print_with_status_dialog(self, print_with_status_dialog):
        self.container['print_with_status_dialog'] = print_with_status_dialog 
    @property
    def horizontal_resolution(self):
        return self.container['horizontal_resolution']

    @horizontal_resolution.setter
    def horizontal_resolution(self, horizontal_resolution):
        self.container['horizontal_resolution'] = horizontal_resolution 
    @property
    def vertical_resolution(self):
        return self.container['vertical_resolution']

    @vertical_resolution.setter
    def vertical_resolution(self, vertical_resolution):
        self.container['vertical_resolution'] = vertical_resolution 
    @property
    def default_edit_language(self):
        return self.container['default_edit_language']

    @default_edit_language.setter
    def default_edit_language(self, default_edit_language):
        self.container['default_edit_language'] = default_edit_language 
    @property
    def tiff_color_depth(self):
        return self.container['tiff_color_depth']

    @tiff_color_depth.setter
    def tiff_color_depth(self, tiff_color_depth):
        self.container['tiff_color_depth'] = tiff_color_depth 
    @property
    def tiff_compression(self):
        return self.container['tiff_compression']

    @tiff_compression.setter
    def tiff_compression(self, tiff_compression):
        self.container['tiff_compression'] = tiff_compression 
    @property
    def printing_page(self):
        return self.container['printing_page']

    @printing_page.setter
    def printing_page(self, printing_page):
        self.container['printing_page'] = printing_page 
    @property
    def quality(self):
        return self.container['quality']

    @quality.setter
    def quality(self, quality):
        self.container['quality'] = quality 
    @property
    def image_type(self):
        return self.container['image_type']

    @image_type.setter
    def image_type(self, image_type):
        self.container['image_type'] = image_type 
    @property
    def one_page_per_sheet(self):
        return self.container['one_page_per_sheet']

    @one_page_per_sheet.setter
    def one_page_per_sheet(self, one_page_per_sheet):
        self.container['one_page_per_sheet'] = one_page_per_sheet 
    @property
    def tiff_binarization_method(self):
        return self.container['tiff_binarization_method']

    @tiff_binarization_method.setter
    def tiff_binarization_method(self, tiff_binarization_method):
        self.container['tiff_binarization_method'] = tiff_binarization_method 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ImageOrPrintOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    