# coding: utf-8
"""
<copyright company="Aspose" file="ImportCSVDataOptionpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ImportCSVDataOption(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'separator_string' : 'str',
        'convert_numeric_data' : 'bool',
        'first_row' : 'int',
        'first_column' : 'int',
        'source_file' : 'str',
        'custom_parsers' : 'list[CustomParserConfig]',
        'destination_worksheet' : 'str',
        'is_insert' : 'bool',
        'import_data_type' : 'str',
        'data_source' : 'DataSource',
        'source' : 'FileSource'
    }

    attribute_map = {
        'separator_string' : 'SeparatorString' ,
        'convert_numeric_data' : 'ConvertNumericData' ,
        'first_row' : 'FirstRow' ,
        'first_column' : 'FirstColumn' ,
        'source_file' : 'SourceFile' ,
        'custom_parsers' : 'CustomParsers' ,
        'destination_worksheet' : 'DestinationWorksheet' ,
        'is_insert' : 'IsInsert' ,
        'import_data_type' : 'ImportDataType' ,
        'data_source' : 'DataSource' ,
        'source' : 'Source' 
    }

    @staticmethod
    def get_swagger_types():
        return ImportCSVDataOption.swagger_types

    @staticmethod
    def get_attribute_map():
        return ImportCSVDataOption.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,separator_string=None ,convert_numeric_data=None ,first_row=None ,first_column=None ,source_file=None ,custom_parsers=None ,destination_worksheet=None ,is_insert=None ,import_data_type=None ,data_source=None ,source=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ImportCSVDataOption - a model defined in Swagger
        """
        self.container['separator_string'] = None 
        self.container['convert_numeric_data'] = None 
        self.container['first_row'] = None 
        self.container['first_column'] = None 
        self.container['source_file'] = None 
        self.container['custom_parsers'] = None 
        self.container['destination_worksheet'] = None 
        self.container['is_insert'] = None 
        self.container['import_data_type'] = None 
        self.container['data_source'] = None 
        self.container['source'] = None 
        params = locals()
        self.separator_string = separator_string
        if 'separator_string' in params:
            self.separator_string = params["separator_string"]


             
        self.convert_numeric_data = convert_numeric_data
        if 'convert_numeric_data' in params:
            self.convert_numeric_data = params["convert_numeric_data"]


             
        self.first_row = first_row
        if 'first_row' in params:
            self.first_row = params["first_row"]


             
        self.first_column = first_column
        if 'first_column' in params:
            self.first_column = params["first_column"]


             
        self.source_file = source_file
        if 'source_file' in params:
            self.source_file = params["source_file"]


             
        self.custom_parsers = custom_parsers
        if 'custom_parsers' in params:
            self.custom_parsers = params["custom_parsers"]


             
        self.destination_worksheet = destination_worksheet
        if 'destination_worksheet' in params:
            self.destination_worksheet = params["destination_worksheet"]


             
        self.is_insert = is_insert
        if 'is_insert' in params:
            self.is_insert = params["is_insert"]


             
        self.import_data_type = import_data_type
        if 'import_data_type' in params:
            self.import_data_type = params["import_data_type"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.source = source
        if 'source' in params:
            self.source = params["source"]


             

    @property
    def separator_string(self):
        return self.container['separator_string']

    @separator_string.setter
    def separator_string(self, separator_string):
        self.container['separator_string'] = separator_string 
    @property
    def convert_numeric_data(self):
        return self.container['convert_numeric_data']

    @convert_numeric_data.setter
    def convert_numeric_data(self, convert_numeric_data):
        self.container['convert_numeric_data'] = convert_numeric_data 
    @property
    def first_row(self):
        return self.container['first_row']

    @first_row.setter
    def first_row(self, first_row):
        self.container['first_row'] = first_row 
    @property
    def first_column(self):
        return self.container['first_column']

    @first_column.setter
    def first_column(self, first_column):
        self.container['first_column'] = first_column 
    @property
    def source_file(self):
        return self.container['source_file']

    @source_file.setter
    def source_file(self, source_file):
        self.container['source_file'] = source_file 
    @property
    def custom_parsers(self):
        return self.container['custom_parsers']

    @custom_parsers.setter
    def custom_parsers(self, custom_parsers):
        self.container['custom_parsers'] = custom_parsers 
    @property
    def destination_worksheet(self):
        return self.container['destination_worksheet']

    @destination_worksheet.setter
    def destination_worksheet(self, destination_worksheet):
        self.container['destination_worksheet'] = destination_worksheet 
    @property
    def is_insert(self):
        return self.container['is_insert']

    @is_insert.setter
    def is_insert(self, is_insert):
        self.container['is_insert'] = is_insert 
    @property
    def import_data_type(self):
        return self.container['import_data_type']

    @import_data_type.setter
    def import_data_type(self, import_data_type):
        self.container['import_data_type'] = import_data_type 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def source(self):
        return self.container['source']

    @source.setter
    def source(self, source):
        self.container['source'] = source 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ImportCSVDataOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    