# coding: utf-8
"""
<copyright company="Aspose" file="ImportDataTaskParameterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ImportDataTaskParameter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'data_source' : 'DataSource',
        'workbook' : 'FileSource',
        'import_option' : 'ImportOption',
        'target_data_source' : 'DataSource',
        'destination_workbook' : 'FileSource'
    }

    attribute_map = {
        'data_source' : 'DataSource' ,
        'workbook' : 'Workbook' ,
        'import_option' : 'ImportOption' ,
        'target_data_source' : 'TargetDataSource' ,
        'destination_workbook' : 'DestinationWorkbook' 
    }

    @staticmethod
    def get_swagger_types():
        return ImportDataTaskParameter.swagger_types

    @staticmethod
    def get_attribute_map():
        return ImportDataTaskParameter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,data_source=None ,workbook=None ,import_option=None ,target_data_source=None ,destination_workbook=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ImportDataTaskParameter - a model defined in Swagger
        """
        self.container['data_source'] = None 
        self.container['workbook'] = None 
        self.container['import_option'] = None 
        self.container['target_data_source'] = None 
        self.container['destination_workbook'] = None 
        params = locals()
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.workbook = workbook
        if 'workbook' in params:
            self.workbook = params["workbook"]


             
        self.import_option = import_option
        if 'import_option' in params:
            self.import_option = params["import_option"]


             
        self.target_data_source = target_data_source
        if 'target_data_source' in params:
            self.target_data_source = params["target_data_source"]


             
        self.destination_workbook = destination_workbook
        if 'destination_workbook' in params:
            self.destination_workbook = params["destination_workbook"]


             

    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def workbook(self):
        return self.container['workbook']

    @workbook.setter
    def workbook(self, workbook):
        self.container['workbook'] = workbook 
    @property
    def import_option(self):
        return self.container['import_option']

    @import_option.setter
    def import_option(self, import_option):
        self.container['import_option'] = import_option 
    @property
    def target_data_source(self):
        return self.container['target_data_source']

    @target_data_source.setter
    def target_data_source(self, target_data_source):
        self.container['target_data_source'] = target_data_source 
    @property
    def destination_workbook(self):
        return self.container['destination_workbook']

    @destination_workbook.setter
    def destination_workbook(self, destination_workbook):
        self.container['destination_workbook'] = destination_workbook 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ImportDataTaskParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    