# coding: utf-8
"""
<copyright company="Aspose" file="ImportPictureOptionpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ImportPictureOption(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'upper_left_row' : 'int',
        'upper_left_column' : 'int',
        'lower_right_row' : 'int',
        'lower_right_column' : 'int',
        'filename' : 'str',
        'data' : 'str',
        'destination_worksheet' : 'str',
        'is_insert' : 'bool',
        'import_data_type' : 'str',
        'data_source' : 'DataSource',
        'source' : 'FileSource'
    }

    attribute_map = {
        'upper_left_row' : 'UpperLeftRow' ,
        'upper_left_column' : 'UpperLeftColumn' ,
        'lower_right_row' : 'LowerRightRow' ,
        'lower_right_column' : 'LowerRightColumn' ,
        'filename' : 'Filename' ,
        'data' : 'Data' ,
        'destination_worksheet' : 'DestinationWorksheet' ,
        'is_insert' : 'IsInsert' ,
        'import_data_type' : 'ImportDataType' ,
        'data_source' : 'DataSource' ,
        'source' : 'Source' 
    }

    @staticmethod
    def get_swagger_types():
        return ImportPictureOption.swagger_types

    @staticmethod
    def get_attribute_map():
        return ImportPictureOption.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,upper_left_row=None ,upper_left_column=None ,lower_right_row=None ,lower_right_column=None ,filename=None ,data=None ,destination_worksheet=None ,is_insert=None ,import_data_type=None ,data_source=None ,source=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ImportPictureOption - a model defined in Swagger
        """
        self.container['upper_left_row'] = None 
        self.container['upper_left_column'] = None 
        self.container['lower_right_row'] = None 
        self.container['lower_right_column'] = None 
        self.container['filename'] = None 
        self.container['data'] = None 
        self.container['destination_worksheet'] = None 
        self.container['is_insert'] = None 
        self.container['import_data_type'] = None 
        self.container['data_source'] = None 
        self.container['source'] = None 
        params = locals()
        self.upper_left_row = upper_left_row
        if 'upper_left_row' in params:
            self.upper_left_row = params["upper_left_row"]


             
        self.upper_left_column = upper_left_column
        if 'upper_left_column' in params:
            self.upper_left_column = params["upper_left_column"]


             
        self.lower_right_row = lower_right_row
        if 'lower_right_row' in params:
            self.lower_right_row = params["lower_right_row"]


             
        self.lower_right_column = lower_right_column
        if 'lower_right_column' in params:
            self.lower_right_column = params["lower_right_column"]


             
        self.filename = filename
        if 'filename' in params:
            self.filename = params["filename"]


             
        self.data = data
        if 'data' in params:
            self.data = params["data"]


             
        self.destination_worksheet = destination_worksheet
        if 'destination_worksheet' in params:
            self.destination_worksheet = params["destination_worksheet"]


             
        self.is_insert = is_insert
        if 'is_insert' in params:
            self.is_insert = params["is_insert"]


             
        self.import_data_type = import_data_type
        if 'import_data_type' in params:
            self.import_data_type = params["import_data_type"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.source = source
        if 'source' in params:
            self.source = params["source"]


             

    @property
    def upper_left_row(self):
        return self.container['upper_left_row']

    @upper_left_row.setter
    def upper_left_row(self, upper_left_row):
        self.container['upper_left_row'] = upper_left_row 
    @property
    def upper_left_column(self):
        return self.container['upper_left_column']

    @upper_left_column.setter
    def upper_left_column(self, upper_left_column):
        self.container['upper_left_column'] = upper_left_column 
    @property
    def lower_right_row(self):
        return self.container['lower_right_row']

    @lower_right_row.setter
    def lower_right_row(self, lower_right_row):
        self.container['lower_right_row'] = lower_right_row 
    @property
    def lower_right_column(self):
        return self.container['lower_right_column']

    @lower_right_column.setter
    def lower_right_column(self, lower_right_column):
        self.container['lower_right_column'] = lower_right_column 
    @property
    def filename(self):
        return self.container['filename']

    @filename.setter
    def filename(self, filename):
        self.container['filename'] = filename 
    @property
    def data(self):
        return self.container['data']

    @data.setter
    def data(self, data):
        self.container['data'] = data 
    @property
    def destination_worksheet(self):
        return self.container['destination_worksheet']

    @destination_worksheet.setter
    def destination_worksheet(self, destination_worksheet):
        self.container['destination_worksheet'] = destination_worksheet 
    @property
    def is_insert(self):
        return self.container['is_insert']

    @is_insert.setter
    def is_insert(self, is_insert):
        self.container['is_insert'] = is_insert 
    @property
    def import_data_type(self):
        return self.container['import_data_type']

    @import_data_type.setter
    def import_data_type(self, import_data_type):
        self.container['import_data_type'] = import_data_type 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def source(self):
        return self.container['source']

    @source.setter
    def source(self, source):
        self.container['source'] = source 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ImportPictureOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    