# coding: utf-8
"""
<copyright company="Aspose" file="ListObjectpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ListObject(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_filter' : 'AutoFilter',
        'display_name' : 'str',
        'start_column' : 'int',
        'start_row' : 'int',
        'end_column' : 'int',
        'end_row' : 'int',
        'list_columns' : 'list[ListColumn]',
        'show_header_row' : 'bool',
        'show_table_style_column_stripes' : 'bool',
        'show_table_style_first_column' : 'bool',
        'show_table_style_last_column' : 'bool',
        'show_table_style_row_stripes' : 'bool',
        'show_totals' : 'bool',
        'table_style_name' : 'str',
        'table_style_type' : 'str',
        'data_range' : 'Range',
        'data_source_type' : 'str',
        'comment' : 'str',
        'xml_map' : 'XmlMap',
        'alternative_text' : 'str',
        'alternative_description' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'auto_filter' : 'AutoFilter' ,
        'display_name' : 'DisplayName' ,
        'start_column' : 'StartColumn' ,
        'start_row' : 'StartRow' ,
        'end_column' : 'EndColumn' ,
        'end_row' : 'EndRow' ,
        'list_columns' : 'ListColumns' ,
        'show_header_row' : 'ShowHeaderRow' ,
        'show_table_style_column_stripes' : 'ShowTableStyleColumnStripes' ,
        'show_table_style_first_column' : 'ShowTableStyleFirstColumn' ,
        'show_table_style_last_column' : 'ShowTableStyleLastColumn' ,
        'show_table_style_row_stripes' : 'ShowTableStyleRowStripes' ,
        'show_totals' : 'ShowTotals' ,
        'table_style_name' : 'TableStyleName' ,
        'table_style_type' : 'TableStyleType' ,
        'data_range' : 'DataRange' ,
        'data_source_type' : 'DataSourceType' ,
        'comment' : 'Comment' ,
        'xml_map' : 'XmlMap' ,
        'alternative_text' : 'AlternativeText' ,
        'alternative_description' : 'AlternativeDescription' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return ListObject.swagger_types

    @staticmethod
    def get_attribute_map():
        return ListObject.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_filter=None ,display_name=None ,start_column=None ,start_row=None ,end_column=None ,end_row=None ,list_columns=None ,show_header_row=None ,show_table_style_column_stripes=None ,show_table_style_first_column=None ,show_table_style_last_column=None ,show_table_style_row_stripes=None ,show_totals=None ,table_style_name=None ,table_style_type=None ,data_range=None ,data_source_type=None ,comment=None ,xml_map=None ,alternative_text=None ,alternative_description=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ListObject - a model defined in Swagger
        """
        self.container['auto_filter'] = None 
        self.container['display_name'] = None 
        self.container['start_column'] = None 
        self.container['start_row'] = None 
        self.container['end_column'] = None 
        self.container['end_row'] = None 
        self.container['list_columns'] = None 
        self.container['show_header_row'] = None 
        self.container['show_table_style_column_stripes'] = None 
        self.container['show_table_style_first_column'] = None 
        self.container['show_table_style_last_column'] = None 
        self.container['show_table_style_row_stripes'] = None 
        self.container['show_totals'] = None 
        self.container['table_style_name'] = None 
        self.container['table_style_type'] = None 
        self.container['data_range'] = None 
        self.container['data_source_type'] = None 
        self.container['comment'] = None 
        self.container['xml_map'] = None 
        self.container['alternative_text'] = None 
        self.container['alternative_description'] = None 
        self.container['link'] = None 
        params = locals()
        self.auto_filter = auto_filter
        if 'auto_filter' in params:
            self.auto_filter = params["auto_filter"]


             
        self.display_name = display_name
        if 'display_name' in params:
            self.display_name = params["display_name"]


             
        self.start_column = start_column
        if 'start_column' in params:
            self.start_column = params["start_column"]


             
        self.start_row = start_row
        if 'start_row' in params:
            self.start_row = params["start_row"]


             
        self.end_column = end_column
        if 'end_column' in params:
            self.end_column = params["end_column"]


             
        self.end_row = end_row
        if 'end_row' in params:
            self.end_row = params["end_row"]


             
        self.list_columns = list_columns
        if 'list_columns' in params:
            self.list_columns = params["list_columns"]


             
        self.show_header_row = show_header_row
        if 'show_header_row' in params:
            self.show_header_row = params["show_header_row"]


             
        self.show_table_style_column_stripes = show_table_style_column_stripes
        if 'show_table_style_column_stripes' in params:
            self.show_table_style_column_stripes = params["show_table_style_column_stripes"]


             
        self.show_table_style_first_column = show_table_style_first_column
        if 'show_table_style_first_column' in params:
            self.show_table_style_first_column = params["show_table_style_first_column"]


             
        self.show_table_style_last_column = show_table_style_last_column
        if 'show_table_style_last_column' in params:
            self.show_table_style_last_column = params["show_table_style_last_column"]


             
        self.show_table_style_row_stripes = show_table_style_row_stripes
        if 'show_table_style_row_stripes' in params:
            self.show_table_style_row_stripes = params["show_table_style_row_stripes"]


             
        self.show_totals = show_totals
        if 'show_totals' in params:
            self.show_totals = params["show_totals"]


             
        self.table_style_name = table_style_name
        if 'table_style_name' in params:
            self.table_style_name = params["table_style_name"]


             
        self.table_style_type = table_style_type
        if 'table_style_type' in params:
            self.table_style_type = params["table_style_type"]


             
        self.data_range = data_range
        if 'data_range' in params:
            self.data_range = params["data_range"]


             
        self.data_source_type = data_source_type
        if 'data_source_type' in params:
            self.data_source_type = params["data_source_type"]


             
        self.comment = comment
        if 'comment' in params:
            self.comment = params["comment"]


             
        self.xml_map = xml_map
        if 'xml_map' in params:
            self.xml_map = params["xml_map"]


             
        self.alternative_text = alternative_text
        if 'alternative_text' in params:
            self.alternative_text = params["alternative_text"]


             
        self.alternative_description = alternative_description
        if 'alternative_description' in params:
            self.alternative_description = params["alternative_description"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def auto_filter(self):
        return self.container['auto_filter']

    @auto_filter.setter
    def auto_filter(self, auto_filter):
        self.container['auto_filter'] = auto_filter 
    @property
    def display_name(self):
        return self.container['display_name']

    @display_name.setter
    def display_name(self, display_name):
        self.container['display_name'] = display_name 
    @property
    def start_column(self):
        return self.container['start_column']

    @start_column.setter
    def start_column(self, start_column):
        self.container['start_column'] = start_column 
    @property
    def start_row(self):
        return self.container['start_row']

    @start_row.setter
    def start_row(self, start_row):
        self.container['start_row'] = start_row 
    @property
    def end_column(self):
        return self.container['end_column']

    @end_column.setter
    def end_column(self, end_column):
        self.container['end_column'] = end_column 
    @property
    def end_row(self):
        return self.container['end_row']

    @end_row.setter
    def end_row(self, end_row):
        self.container['end_row'] = end_row 
    @property
    def list_columns(self):
        return self.container['list_columns']

    @list_columns.setter
    def list_columns(self, list_columns):
        self.container['list_columns'] = list_columns 
    @property
    def show_header_row(self):
        return self.container['show_header_row']

    @show_header_row.setter
    def show_header_row(self, show_header_row):
        self.container['show_header_row'] = show_header_row 
    @property
    def show_table_style_column_stripes(self):
        return self.container['show_table_style_column_stripes']

    @show_table_style_column_stripes.setter
    def show_table_style_column_stripes(self, show_table_style_column_stripes):
        self.container['show_table_style_column_stripes'] = show_table_style_column_stripes 
    @property
    def show_table_style_first_column(self):
        return self.container['show_table_style_first_column']

    @show_table_style_first_column.setter
    def show_table_style_first_column(self, show_table_style_first_column):
        self.container['show_table_style_first_column'] = show_table_style_first_column 
    @property
    def show_table_style_last_column(self):
        return self.container['show_table_style_last_column']

    @show_table_style_last_column.setter
    def show_table_style_last_column(self, show_table_style_last_column):
        self.container['show_table_style_last_column'] = show_table_style_last_column 
    @property
    def show_table_style_row_stripes(self):
        return self.container['show_table_style_row_stripes']

    @show_table_style_row_stripes.setter
    def show_table_style_row_stripes(self, show_table_style_row_stripes):
        self.container['show_table_style_row_stripes'] = show_table_style_row_stripes 
    @property
    def show_totals(self):
        return self.container['show_totals']

    @show_totals.setter
    def show_totals(self, show_totals):
        self.container['show_totals'] = show_totals 
    @property
    def table_style_name(self):
        return self.container['table_style_name']

    @table_style_name.setter
    def table_style_name(self, table_style_name):
        self.container['table_style_name'] = table_style_name 
    @property
    def table_style_type(self):
        return self.container['table_style_type']

    @table_style_type.setter
    def table_style_type(self, table_style_type):
        self.container['table_style_type'] = table_style_type 
    @property
    def data_range(self):
        return self.container['data_range']

    @data_range.setter
    def data_range(self, data_range):
        self.container['data_range'] = data_range 
    @property
    def data_source_type(self):
        return self.container['data_source_type']

    @data_source_type.setter
    def data_source_type(self, data_source_type):
        self.container['data_source_type'] = data_source_type 
    @property
    def comment(self):
        return self.container['comment']

    @comment.setter
    def comment(self, comment):
        self.container['comment'] = comment 
    @property
    def xml_map(self):
        return self.container['xml_map']

    @xml_map.setter
    def xml_map(self, xml_map):
        self.container['xml_map'] = xml_map 
    @property
    def alternative_text(self):
        return self.container['alternative_text']

    @alternative_text.setter
    def alternative_text(self, alternative_text):
        self.container['alternative_text'] = alternative_text 
    @property
    def alternative_description(self):
        return self.container['alternative_description']

    @alternative_description.setter
    def alternative_description(self, alternative_description):
        self.container['alternative_description'] = alternative_description 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ListObject):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    