# coding: utf-8
"""
<copyright company="Aspose" file="MergeTableOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class MergeTableOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'main_table' : 'CombinationSourceData',
        'secondary_table' : 'CombinationSourceData',
        'data_merge_type' : 'str',
        'overwrite_main_table' : 'bool',
        'sync_data_to_target_workbook' : 'bool',
        'merged_data_to_position' : 'DataOutputLocation'
    }

    attribute_map = {
        'main_table' : 'MainTable' ,
        'secondary_table' : 'SecondaryTable' ,
        'data_merge_type' : 'DataMergeType' ,
        'overwrite_main_table' : 'OverwriteMainTable' ,
        'sync_data_to_target_workbook' : 'SyncDataToTargetWorkbook' ,
        'merged_data_to_position' : 'MergedDataToPosition' 
    }

    @staticmethod
    def get_swagger_types():
        return MergeTableOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return MergeTableOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,main_table=None ,secondary_table=None ,data_merge_type=None ,overwrite_main_table=None ,sync_data_to_target_workbook=None ,merged_data_to_position=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        MergeTableOptions - a model defined in Swagger
        """
        self.container['main_table'] = None 
        self.container['secondary_table'] = None 
        self.container['data_merge_type'] = None 
        self.container['overwrite_main_table'] = None 
        self.container['sync_data_to_target_workbook'] = None 
        self.container['merged_data_to_position'] = None 
        params = locals()
        self.main_table = main_table
        if 'main_table' in params:
            self.main_table = params["main_table"]


             
        self.secondary_table = secondary_table
        if 'secondary_table' in params:
            self.secondary_table = params["secondary_table"]


             
        self.data_merge_type = data_merge_type
        if 'data_merge_type' in params:
            self.data_merge_type = params["data_merge_type"]


             
        self.overwrite_main_table = overwrite_main_table
        if 'overwrite_main_table' in params:
            self.overwrite_main_table = params["overwrite_main_table"]


             
        self.sync_data_to_target_workbook = sync_data_to_target_workbook
        if 'sync_data_to_target_workbook' in params:
            self.sync_data_to_target_workbook = params["sync_data_to_target_workbook"]


             
        self.merged_data_to_position = merged_data_to_position
        if 'merged_data_to_position' in params:
            self.merged_data_to_position = params["merged_data_to_position"]


             

    @property
    def main_table(self):
        return self.container['main_table']

    @main_table.setter
    def main_table(self, main_table):
        self.container['main_table'] = main_table 
    @property
    def secondary_table(self):
        return self.container['secondary_table']

    @secondary_table.setter
    def secondary_table(self, secondary_table):
        self.container['secondary_table'] = secondary_table 
    @property
    def data_merge_type(self):
        return self.container['data_merge_type']

    @data_merge_type.setter
    def data_merge_type(self, data_merge_type):
        self.container['data_merge_type'] = data_merge_type 
    @property
    def overwrite_main_table(self):
        return self.container['overwrite_main_table']

    @overwrite_main_table.setter
    def overwrite_main_table(self, overwrite_main_table):
        self.container['overwrite_main_table'] = overwrite_main_table 
    @property
    def sync_data_to_target_workbook(self):
        return self.container['sync_data_to_target_workbook']

    @sync_data_to_target_workbook.setter
    def sync_data_to_target_workbook(self, sync_data_to_target_workbook):
        self.container['sync_data_to_target_workbook'] = sync_data_to_target_workbook 
    @property
    def merged_data_to_position(self):
        return self.container['merged_data_to_position']

    @merged_data_to_position.setter
    def merged_data_to_position(self, merged_data_to_position):
        self.container['merged_data_to_position'] = merged_data_to_position 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, MergeTableOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    