# coding: utf-8
"""
<copyright company="Aspose" file="OperateObjectPositionpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class OperateObjectPosition(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'data_source' : 'DataSource',
        'workbook' : 'FileSource',
        'sheet_name' : 'str',
        'chart_index' : 'int',
        'shape_index' : 'int',
        'cell_name' : 'str',
        'list_object_index' : 'int'
    }

    attribute_map = {
        'data_source' : 'DataSource' ,
        'workbook' : 'Workbook' ,
        'sheet_name' : 'SheetName' ,
        'chart_index' : 'ChartIndex' ,
        'shape_index' : 'ShapeIndex' ,
        'cell_name' : 'CellName' ,
        'list_object_index' : 'ListObjectIndex' 
    }

    @staticmethod
    def get_swagger_types():
        return OperateObjectPosition.swagger_types

    @staticmethod
    def get_attribute_map():
        return OperateObjectPosition.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,data_source=None ,workbook=None ,sheet_name=None ,chart_index=None ,shape_index=None ,cell_name=None ,list_object_index=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        OperateObjectPosition - a model defined in Swagger
        """
        self.container['data_source'] = None 
        self.container['workbook'] = None 
        self.container['sheet_name'] = None 
        self.container['chart_index'] = None 
        self.container['shape_index'] = None 
        self.container['cell_name'] = None 
        self.container['list_object_index'] = None 
        params = locals()
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.workbook = workbook
        if 'workbook' in params:
            self.workbook = params["workbook"]


             
        self.sheet_name = sheet_name
        if 'sheet_name' in params:
            self.sheet_name = params["sheet_name"]


             
        self.chart_index = chart_index
        if 'chart_index' in params:
            self.chart_index = params["chart_index"]


             
        self.shape_index = shape_index
        if 'shape_index' in params:
            self.shape_index = params["shape_index"]


             
        self.cell_name = cell_name
        if 'cell_name' in params:
            self.cell_name = params["cell_name"]


             
        self.list_object_index = list_object_index
        if 'list_object_index' in params:
            self.list_object_index = params["list_object_index"]


             

    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def workbook(self):
        return self.container['workbook']

    @workbook.setter
    def workbook(self, workbook):
        self.container['workbook'] = workbook 
    @property
    def sheet_name(self):
        return self.container['sheet_name']

    @sheet_name.setter
    def sheet_name(self, sheet_name):
        self.container['sheet_name'] = sheet_name 
    @property
    def chart_index(self):
        return self.container['chart_index']

    @chart_index.setter
    def chart_index(self, chart_index):
        self.container['chart_index'] = chart_index 
    @property
    def shape_index(self):
        return self.container['shape_index']

    @shape_index.setter
    def shape_index(self, shape_index):
        self.container['shape_index'] = shape_index 
    @property
    def cell_name(self):
        return self.container['cell_name']

    @cell_name.setter
    def cell_name(self, cell_name):
        self.container['cell_name'] = cell_name 
    @property
    def list_object_index(self):
        return self.container['list_object_index']

    @list_object_index.setter
    def list_object_index(self, list_object_index):
        self.container['list_object_index'] = list_object_index 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, OperateObjectPosition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    