# coding: utf-8
"""
<copyright company="Aspose" file="PageSetuppy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PageSetup(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'black_and_white' : 'bool',
        'bottom_margin' : 'float',
        'center_horizontally' : 'bool',
        'center_vertically' : 'bool',
        'first_page_number' : 'int',
        'fit_to_pages_tall' : 'int',
        'fit_to_pages_wide' : 'int',
        'footer_margin' : 'float',
        'header_margin' : 'float',
        'is_auto_first_page_number' : 'bool',
        'is_hf_align_margins' : 'bool',
        'is_hf_diff_first' : 'bool',
        'is_hf_diff_odd_even' : 'bool',
        'is_hf_scale_with_doc' : 'bool',
        'is_percent_scale' : 'bool',
        'left_margin' : 'float',
        'order' : 'str',
        'orientation' : 'str',
        'paper_size' : 'str',
        'print_area' : 'str',
        'print_comments' : 'str',
        'print_copies' : 'int',
        'print_draft' : 'bool',
        'print_errors' : 'str',
        'print_gridlines' : 'bool',
        'print_headings' : 'bool',
        'print_quality' : 'int',
        'print_title_columns' : 'str',
        'print_title_rows' : 'str',
        'right_margin' : 'float',
        'top_margin' : 'float',
        'zoom' : 'int',
        'header' : 'list[PageSection]',
        'footer' : 'list[PageSection]'
    }

    attribute_map = {
        'black_and_white' : 'BlackAndWhite' ,
        'bottom_margin' : 'BottomMargin' ,
        'center_horizontally' : 'CenterHorizontally' ,
        'center_vertically' : 'CenterVertically' ,
        'first_page_number' : 'FirstPageNumber' ,
        'fit_to_pages_tall' : 'FitToPagesTall' ,
        'fit_to_pages_wide' : 'FitToPagesWide' ,
        'footer_margin' : 'FooterMargin' ,
        'header_margin' : 'HeaderMargin' ,
        'is_auto_first_page_number' : 'IsAutoFirstPageNumber' ,
        'is_hf_align_margins' : 'IsHFAlignMargins' ,
        'is_hf_diff_first' : 'IsHFDiffFirst' ,
        'is_hf_diff_odd_even' : 'IsHFDiffOddEven' ,
        'is_hf_scale_with_doc' : 'IsHFScaleWithDoc' ,
        'is_percent_scale' : 'IsPercentScale' ,
        'left_margin' : 'LeftMargin' ,
        'order' : 'Order' ,
        'orientation' : 'Orientation' ,
        'paper_size' : 'PaperSize' ,
        'print_area' : 'PrintArea' ,
        'print_comments' : 'PrintComments' ,
        'print_copies' : 'PrintCopies' ,
        'print_draft' : 'PrintDraft' ,
        'print_errors' : 'PrintErrors' ,
        'print_gridlines' : 'PrintGridlines' ,
        'print_headings' : 'PrintHeadings' ,
        'print_quality' : 'PrintQuality' ,
        'print_title_columns' : 'PrintTitleColumns' ,
        'print_title_rows' : 'PrintTitleRows' ,
        'right_margin' : 'RightMargin' ,
        'top_margin' : 'TopMargin' ,
        'zoom' : 'Zoom' ,
        'header' : 'Header' ,
        'footer' : 'Footer' 
    }

    @staticmethod
    def get_swagger_types():
        return PageSetup.swagger_types

    @staticmethod
    def get_attribute_map():
        return PageSetup.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,black_and_white=None ,bottom_margin=None ,center_horizontally=None ,center_vertically=None ,first_page_number=None ,fit_to_pages_tall=None ,fit_to_pages_wide=None ,footer_margin=None ,header_margin=None ,is_auto_first_page_number=None ,is_hf_align_margins=None ,is_hf_diff_first=None ,is_hf_diff_odd_even=None ,is_hf_scale_with_doc=None ,is_percent_scale=None ,left_margin=None ,order=None ,orientation=None ,paper_size=None ,print_area=None ,print_comments=None ,print_copies=None ,print_draft=None ,print_errors=None ,print_gridlines=None ,print_headings=None ,print_quality=None ,print_title_columns=None ,print_title_rows=None ,right_margin=None ,top_margin=None ,zoom=None ,header=None ,footer=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PageSetup - a model defined in Swagger
        """
        self.container['black_and_white'] = None 
        self.container['bottom_margin'] = None 
        self.container['center_horizontally'] = None 
        self.container['center_vertically'] = None 
        self.container['first_page_number'] = None 
        self.container['fit_to_pages_tall'] = None 
        self.container['fit_to_pages_wide'] = None 
        self.container['footer_margin'] = None 
        self.container['header_margin'] = None 
        self.container['is_auto_first_page_number'] = None 
        self.container['is_hf_align_margins'] = None 
        self.container['is_hf_diff_first'] = None 
        self.container['is_hf_diff_odd_even'] = None 
        self.container['is_hf_scale_with_doc'] = None 
        self.container['is_percent_scale'] = None 
        self.container['left_margin'] = None 
        self.container['order'] = None 
        self.container['orientation'] = None 
        self.container['paper_size'] = None 
        self.container['print_area'] = None 
        self.container['print_comments'] = None 
        self.container['print_copies'] = None 
        self.container['print_draft'] = None 
        self.container['print_errors'] = None 
        self.container['print_gridlines'] = None 
        self.container['print_headings'] = None 
        self.container['print_quality'] = None 
        self.container['print_title_columns'] = None 
        self.container['print_title_rows'] = None 
        self.container['right_margin'] = None 
        self.container['top_margin'] = None 
        self.container['zoom'] = None 
        self.container['header'] = None 
        self.container['footer'] = None 
        params = locals()
        self.black_and_white = black_and_white
        if 'black_and_white' in params:
            self.black_and_white = params["black_and_white"]


             
        self.bottom_margin = bottom_margin
        if 'bottom_margin' in params:
            self.bottom_margin = params["bottom_margin"]


             
        self.center_horizontally = center_horizontally
        if 'center_horizontally' in params:
            self.center_horizontally = params["center_horizontally"]


             
        self.center_vertically = center_vertically
        if 'center_vertically' in params:
            self.center_vertically = params["center_vertically"]


             
        self.first_page_number = first_page_number
        if 'first_page_number' in params:
            self.first_page_number = params["first_page_number"]


             
        self.fit_to_pages_tall = fit_to_pages_tall
        if 'fit_to_pages_tall' in params:
            self.fit_to_pages_tall = params["fit_to_pages_tall"]


             
        self.fit_to_pages_wide = fit_to_pages_wide
        if 'fit_to_pages_wide' in params:
            self.fit_to_pages_wide = params["fit_to_pages_wide"]


             
        self.footer_margin = footer_margin
        if 'footer_margin' in params:
            self.footer_margin = params["footer_margin"]


             
        self.header_margin = header_margin
        if 'header_margin' in params:
            self.header_margin = params["header_margin"]


             
        self.is_auto_first_page_number = is_auto_first_page_number
        if 'is_auto_first_page_number' in params:
            self.is_auto_first_page_number = params["is_auto_first_page_number"]


             
        self.is_hf_align_margins = is_hf_align_margins
        if 'is_hf_align_margins' in params:
            self.is_hf_align_margins = params["is_hf_align_margins"]


             
        self.is_hf_diff_first = is_hf_diff_first
        if 'is_hf_diff_first' in params:
            self.is_hf_diff_first = params["is_hf_diff_first"]


             
        self.is_hf_diff_odd_even = is_hf_diff_odd_even
        if 'is_hf_diff_odd_even' in params:
            self.is_hf_diff_odd_even = params["is_hf_diff_odd_even"]


             
        self.is_hf_scale_with_doc = is_hf_scale_with_doc
        if 'is_hf_scale_with_doc' in params:
            self.is_hf_scale_with_doc = params["is_hf_scale_with_doc"]


             
        self.is_percent_scale = is_percent_scale
        if 'is_percent_scale' in params:
            self.is_percent_scale = params["is_percent_scale"]


             
        self.left_margin = left_margin
        if 'left_margin' in params:
            self.left_margin = params["left_margin"]


             
        self.order = order
        if 'order' in params:
            self.order = params["order"]


             
        self.orientation = orientation
        if 'orientation' in params:
            self.orientation = params["orientation"]


             
        self.paper_size = paper_size
        if 'paper_size' in params:
            self.paper_size = params["paper_size"]


             
        self.print_area = print_area
        if 'print_area' in params:
            self.print_area = params["print_area"]


             
        self.print_comments = print_comments
        if 'print_comments' in params:
            self.print_comments = params["print_comments"]


             
        self.print_copies = print_copies
        if 'print_copies' in params:
            self.print_copies = params["print_copies"]


             
        self.print_draft = print_draft
        if 'print_draft' in params:
            self.print_draft = params["print_draft"]


             
        self.print_errors = print_errors
        if 'print_errors' in params:
            self.print_errors = params["print_errors"]


             
        self.print_gridlines = print_gridlines
        if 'print_gridlines' in params:
            self.print_gridlines = params["print_gridlines"]


             
        self.print_headings = print_headings
        if 'print_headings' in params:
            self.print_headings = params["print_headings"]


             
        self.print_quality = print_quality
        if 'print_quality' in params:
            self.print_quality = params["print_quality"]


             
        self.print_title_columns = print_title_columns
        if 'print_title_columns' in params:
            self.print_title_columns = params["print_title_columns"]


             
        self.print_title_rows = print_title_rows
        if 'print_title_rows' in params:
            self.print_title_rows = params["print_title_rows"]


             
        self.right_margin = right_margin
        if 'right_margin' in params:
            self.right_margin = params["right_margin"]


             
        self.top_margin = top_margin
        if 'top_margin' in params:
            self.top_margin = params["top_margin"]


             
        self.zoom = zoom
        if 'zoom' in params:
            self.zoom = params["zoom"]


             
        self.header = header
        if 'header' in params:
            self.header = params["header"]


             
        self.footer = footer
        if 'footer' in params:
            self.footer = params["footer"]


             

    @property
    def black_and_white(self):
        return self.container['black_and_white']

    @black_and_white.setter
    def black_and_white(self, black_and_white):
        self.container['black_and_white'] = black_and_white 
    @property
    def bottom_margin(self):
        return self.container['bottom_margin']

    @bottom_margin.setter
    def bottom_margin(self, bottom_margin):
        self.container['bottom_margin'] = bottom_margin 
    @property
    def center_horizontally(self):
        return self.container['center_horizontally']

    @center_horizontally.setter
    def center_horizontally(self, center_horizontally):
        self.container['center_horizontally'] = center_horizontally 
    @property
    def center_vertically(self):
        return self.container['center_vertically']

    @center_vertically.setter
    def center_vertically(self, center_vertically):
        self.container['center_vertically'] = center_vertically 
    @property
    def first_page_number(self):
        return self.container['first_page_number']

    @first_page_number.setter
    def first_page_number(self, first_page_number):
        self.container['first_page_number'] = first_page_number 
    @property
    def fit_to_pages_tall(self):
        return self.container['fit_to_pages_tall']

    @fit_to_pages_tall.setter
    def fit_to_pages_tall(self, fit_to_pages_tall):
        self.container['fit_to_pages_tall'] = fit_to_pages_tall 
    @property
    def fit_to_pages_wide(self):
        return self.container['fit_to_pages_wide']

    @fit_to_pages_wide.setter
    def fit_to_pages_wide(self, fit_to_pages_wide):
        self.container['fit_to_pages_wide'] = fit_to_pages_wide 
    @property
    def footer_margin(self):
        return self.container['footer_margin']

    @footer_margin.setter
    def footer_margin(self, footer_margin):
        self.container['footer_margin'] = footer_margin 
    @property
    def header_margin(self):
        return self.container['header_margin']

    @header_margin.setter
    def header_margin(self, header_margin):
        self.container['header_margin'] = header_margin 
    @property
    def is_auto_first_page_number(self):
        return self.container['is_auto_first_page_number']

    @is_auto_first_page_number.setter
    def is_auto_first_page_number(self, is_auto_first_page_number):
        self.container['is_auto_first_page_number'] = is_auto_first_page_number 
    @property
    def is_hf_align_margins(self):
        return self.container['is_hf_align_margins']

    @is_hf_align_margins.setter
    def is_hf_align_margins(self, is_hf_align_margins):
        self.container['is_hf_align_margins'] = is_hf_align_margins 
    @property
    def is_hf_diff_first(self):
        return self.container['is_hf_diff_first']

    @is_hf_diff_first.setter
    def is_hf_diff_first(self, is_hf_diff_first):
        self.container['is_hf_diff_first'] = is_hf_diff_first 
    @property
    def is_hf_diff_odd_even(self):
        return self.container['is_hf_diff_odd_even']

    @is_hf_diff_odd_even.setter
    def is_hf_diff_odd_even(self, is_hf_diff_odd_even):
        self.container['is_hf_diff_odd_even'] = is_hf_diff_odd_even 
    @property
    def is_hf_scale_with_doc(self):
        return self.container['is_hf_scale_with_doc']

    @is_hf_scale_with_doc.setter
    def is_hf_scale_with_doc(self, is_hf_scale_with_doc):
        self.container['is_hf_scale_with_doc'] = is_hf_scale_with_doc 
    @property
    def is_percent_scale(self):
        return self.container['is_percent_scale']

    @is_percent_scale.setter
    def is_percent_scale(self, is_percent_scale):
        self.container['is_percent_scale'] = is_percent_scale 
    @property
    def left_margin(self):
        return self.container['left_margin']

    @left_margin.setter
    def left_margin(self, left_margin):
        self.container['left_margin'] = left_margin 
    @property
    def order(self):
        return self.container['order']

    @order.setter
    def order(self, order):
        self.container['order'] = order 
    @property
    def orientation(self):
        return self.container['orientation']

    @orientation.setter
    def orientation(self, orientation):
        self.container['orientation'] = orientation 
    @property
    def paper_size(self):
        return self.container['paper_size']

    @paper_size.setter
    def paper_size(self, paper_size):
        self.container['paper_size'] = paper_size 
    @property
    def print_area(self):
        return self.container['print_area']

    @print_area.setter
    def print_area(self, print_area):
        self.container['print_area'] = print_area 
    @property
    def print_comments(self):
        return self.container['print_comments']

    @print_comments.setter
    def print_comments(self, print_comments):
        self.container['print_comments'] = print_comments 
    @property
    def print_copies(self):
        return self.container['print_copies']

    @print_copies.setter
    def print_copies(self, print_copies):
        self.container['print_copies'] = print_copies 
    @property
    def print_draft(self):
        return self.container['print_draft']

    @print_draft.setter
    def print_draft(self, print_draft):
        self.container['print_draft'] = print_draft 
    @property
    def print_errors(self):
        return self.container['print_errors']

    @print_errors.setter
    def print_errors(self, print_errors):
        self.container['print_errors'] = print_errors 
    @property
    def print_gridlines(self):
        return self.container['print_gridlines']

    @print_gridlines.setter
    def print_gridlines(self, print_gridlines):
        self.container['print_gridlines'] = print_gridlines 
    @property
    def print_headings(self):
        return self.container['print_headings']

    @print_headings.setter
    def print_headings(self, print_headings):
        self.container['print_headings'] = print_headings 
    @property
    def print_quality(self):
        return self.container['print_quality']

    @print_quality.setter
    def print_quality(self, print_quality):
        self.container['print_quality'] = print_quality 
    @property
    def print_title_columns(self):
        return self.container['print_title_columns']

    @print_title_columns.setter
    def print_title_columns(self, print_title_columns):
        self.container['print_title_columns'] = print_title_columns 
    @property
    def print_title_rows(self):
        return self.container['print_title_rows']

    @print_title_rows.setter
    def print_title_rows(self, print_title_rows):
        self.container['print_title_rows'] = print_title_rows 
    @property
    def right_margin(self):
        return self.container['right_margin']

    @right_margin.setter
    def right_margin(self, right_margin):
        self.container['right_margin'] = right_margin 
    @property
    def top_margin(self):
        return self.container['top_margin']

    @top_margin.setter
    def top_margin(self, top_margin):
        self.container['top_margin'] = top_margin 
    @property
    def zoom(self):
        return self.container['zoom']

    @zoom.setter
    def zoom(self, zoom):
        self.container['zoom'] = zoom 
    @property
    def header(self):
        return self.container['header']

    @header.setter
    def header(self, header):
        self.container['header'] = header 
    @property
    def footer(self):
        return self.container['footer']

    @footer.setter
    def footer(self, footer):
        self.container['footer'] = footer 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PageSetup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    