# coding: utf-8
"""
<copyright company="Aspose" file="PdfSaveOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PdfSaveOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'display_doc_title' : 'bool',
        'export_document_structure' : 'bool',
        'emf_render_setting' : 'str',
        'custom_properties_export' : 'str',
        'optimization_type' : 'str',
        'producer' : 'str',
        'pdf_compression' : 'str',
        'font_encoding' : 'str',
        'watermark' : 'RenderingWatermark',
        'calculate_formula' : 'bool',
        'check_font_compatibility' : 'bool',
        'compliance' : 'str',
        'default_font' : 'str',
        'one_page_per_sheet' : 'bool',
        'printing_page_type' : 'str',
        'security_options' : 'PdfSecurityOptions',
        'desired_ppi' : 'int',
        'jpeg_quality' : 'int',
        'image_type' : 'str',
        'save_format' : 'str',
        'cached_file_folder' : 'str',
        'clear_data' : 'bool',
        'create_directory' : 'bool',
        'enable_http_compression' : 'bool',
        'refresh_chart_cache' : 'bool',
        'sort_names' : 'bool',
        'validate_merged_areas' : 'bool',
        'merge_areas' : 'bool',
        'sort_external_names' : 'bool',
        'check_excel_restriction' : 'bool',
        'update_smart_art' : 'bool',
        'encrypt_document_properties' : 'bool'
    }

    attribute_map = {
        'display_doc_title' : 'DisplayDocTitle' ,
        'export_document_structure' : 'ExportDocumentStructure' ,
        'emf_render_setting' : 'EmfRenderSetting' ,
        'custom_properties_export' : 'CustomPropertiesExport' ,
        'optimization_type' : 'OptimizationType' ,
        'producer' : 'Producer' ,
        'pdf_compression' : 'PdfCompression' ,
        'font_encoding' : 'FontEncoding' ,
        'watermark' : 'Watermark' ,
        'calculate_formula' : 'CalculateFormula' ,
        'check_font_compatibility' : 'CheckFontCompatibility' ,
        'compliance' : 'Compliance' ,
        'default_font' : 'DefaultFont' ,
        'one_page_per_sheet' : 'OnePagePerSheet' ,
        'printing_page_type' : 'PrintingPageType' ,
        'security_options' : 'SecurityOptions' ,
        'desired_ppi' : 'desiredPPI' ,
        'jpeg_quality' : 'jpegQuality' ,
        'image_type' : 'ImageType' ,
        'save_format' : 'SaveFormat' ,
        'cached_file_folder' : 'CachedFileFolder' ,
        'clear_data' : 'ClearData' ,
        'create_directory' : 'CreateDirectory' ,
        'enable_http_compression' : 'EnableHTTPCompression' ,
        'refresh_chart_cache' : 'RefreshChartCache' ,
        'sort_names' : 'SortNames' ,
        'validate_merged_areas' : 'ValidateMergedAreas' ,
        'merge_areas' : 'MergeAreas' ,
        'sort_external_names' : 'SortExternalNames' ,
        'check_excel_restriction' : 'CheckExcelRestriction' ,
        'update_smart_art' : 'UpdateSmartArt' ,
        'encrypt_document_properties' : 'EncryptDocumentProperties' 
    }

    @staticmethod
    def get_swagger_types():
        return PdfSaveOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return PdfSaveOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,display_doc_title=None ,export_document_structure=None ,emf_render_setting=None ,custom_properties_export=None ,optimization_type=None ,producer=None ,pdf_compression=None ,font_encoding=None ,watermark=None ,calculate_formula=None ,check_font_compatibility=None ,compliance=None ,default_font=None ,one_page_per_sheet=None ,printing_page_type=None ,security_options=None ,desired_ppi=None ,jpeg_quality=None ,image_type=None ,save_format=None ,cached_file_folder=None ,clear_data=None ,create_directory=None ,enable_http_compression=None ,refresh_chart_cache=None ,sort_names=None ,validate_merged_areas=None ,merge_areas=None ,sort_external_names=None ,check_excel_restriction=None ,update_smart_art=None ,encrypt_document_properties=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PdfSaveOptions - a model defined in Swagger
        """
        self.container['display_doc_title'] = None 
        self.container['export_document_structure'] = None 
        self.container['emf_render_setting'] = None 
        self.container['custom_properties_export'] = None 
        self.container['optimization_type'] = None 
        self.container['producer'] = None 
        self.container['pdf_compression'] = None 
        self.container['font_encoding'] = None 
        self.container['watermark'] = None 
        self.container['calculate_formula'] = None 
        self.container['check_font_compatibility'] = None 
        self.container['compliance'] = None 
        self.container['default_font'] = None 
        self.container['one_page_per_sheet'] = None 
        self.container['printing_page_type'] = None 
        self.container['security_options'] = None 
        self.container['desired_ppi'] = None 
        self.container['jpeg_quality'] = None 
        self.container['image_type'] = None 
        self.container['save_format'] = None 
        self.container['cached_file_folder'] = None 
        self.container['clear_data'] = None 
        self.container['create_directory'] = None 
        self.container['enable_http_compression'] = None 
        self.container['refresh_chart_cache'] = None 
        self.container['sort_names'] = None 
        self.container['validate_merged_areas'] = None 
        self.container['merge_areas'] = None 
        self.container['sort_external_names'] = None 
        self.container['check_excel_restriction'] = None 
        self.container['update_smart_art'] = None 
        self.container['encrypt_document_properties'] = None 
        params = locals()
        self.display_doc_title = display_doc_title
        if 'display_doc_title' in params:
            self.display_doc_title = params["display_doc_title"]


             
        self.export_document_structure = export_document_structure
        if 'export_document_structure' in params:
            self.export_document_structure = params["export_document_structure"]


             
        self.emf_render_setting = emf_render_setting
        if 'emf_render_setting' in params:
            self.emf_render_setting = params["emf_render_setting"]


             
        self.custom_properties_export = custom_properties_export
        if 'custom_properties_export' in params:
            self.custom_properties_export = params["custom_properties_export"]


             
        self.optimization_type = optimization_type
        if 'optimization_type' in params:
            self.optimization_type = params["optimization_type"]


             
        self.producer = producer
        if 'producer' in params:
            self.producer = params["producer"]


             
        self.pdf_compression = pdf_compression
        if 'pdf_compression' in params:
            self.pdf_compression = params["pdf_compression"]


             
        self.font_encoding = font_encoding
        if 'font_encoding' in params:
            self.font_encoding = params["font_encoding"]


             
        self.watermark = watermark
        if 'watermark' in params:
            self.watermark = params["watermark"]


             
        self.calculate_formula = calculate_formula
        if 'calculate_formula' in params:
            self.calculate_formula = params["calculate_formula"]


             
        self.check_font_compatibility = check_font_compatibility
        if 'check_font_compatibility' in params:
            self.check_font_compatibility = params["check_font_compatibility"]


             
        self.compliance = compliance
        if 'compliance' in params:
            self.compliance = params["compliance"]


             
        self.default_font = default_font
        if 'default_font' in params:
            self.default_font = params["default_font"]


             
        self.one_page_per_sheet = one_page_per_sheet
        if 'one_page_per_sheet' in params:
            self.one_page_per_sheet = params["one_page_per_sheet"]


             
        self.printing_page_type = printing_page_type
        if 'printing_page_type' in params:
            self.printing_page_type = params["printing_page_type"]


             
        self.security_options = security_options
        if 'security_options' in params:
            self.security_options = params["security_options"]


             
        self.desired_ppi = desired_ppi
        if 'desired_ppi' in params:
            self.desired_ppi = params["desired_ppi"]


             
        self.jpeg_quality = jpeg_quality
        if 'jpeg_quality' in params:
            self.jpeg_quality = params["jpeg_quality"]


             
        self.image_type = image_type
        if 'image_type' in params:
            self.image_type = params["image_type"]


             
        self.save_format = save_format
        if 'save_format' in params:
            self.save_format = params["save_format"]


             
        self.cached_file_folder = cached_file_folder
        if 'cached_file_folder' in params:
            self.cached_file_folder = params["cached_file_folder"]


             
        self.clear_data = clear_data
        if 'clear_data' in params:
            self.clear_data = params["clear_data"]


             
        self.create_directory = create_directory
        if 'create_directory' in params:
            self.create_directory = params["create_directory"]


             
        self.enable_http_compression = enable_http_compression
        if 'enable_http_compression' in params:
            self.enable_http_compression = params["enable_http_compression"]


             
        self.refresh_chart_cache = refresh_chart_cache
        if 'refresh_chart_cache' in params:
            self.refresh_chart_cache = params["refresh_chart_cache"]


             
        self.sort_names = sort_names
        if 'sort_names' in params:
            self.sort_names = params["sort_names"]


             
        self.validate_merged_areas = validate_merged_areas
        if 'validate_merged_areas' in params:
            self.validate_merged_areas = params["validate_merged_areas"]


             
        self.merge_areas = merge_areas
        if 'merge_areas' in params:
            self.merge_areas = params["merge_areas"]


             
        self.sort_external_names = sort_external_names
        if 'sort_external_names' in params:
            self.sort_external_names = params["sort_external_names"]


             
        self.check_excel_restriction = check_excel_restriction
        if 'check_excel_restriction' in params:
            self.check_excel_restriction = params["check_excel_restriction"]


             
        self.update_smart_art = update_smart_art
        if 'update_smart_art' in params:
            self.update_smart_art = params["update_smart_art"]


             
        self.encrypt_document_properties = encrypt_document_properties
        if 'encrypt_document_properties' in params:
            self.encrypt_document_properties = params["encrypt_document_properties"]


             

    @property
    def display_doc_title(self):
        return self.container['display_doc_title']

    @display_doc_title.setter
    def display_doc_title(self, display_doc_title):
        self.container['display_doc_title'] = display_doc_title 
    @property
    def export_document_structure(self):
        return self.container['export_document_structure']

    @export_document_structure.setter
    def export_document_structure(self, export_document_structure):
        self.container['export_document_structure'] = export_document_structure 
    @property
    def emf_render_setting(self):
        return self.container['emf_render_setting']

    @emf_render_setting.setter
    def emf_render_setting(self, emf_render_setting):
        self.container['emf_render_setting'] = emf_render_setting 
    @property
    def custom_properties_export(self):
        return self.container['custom_properties_export']

    @custom_properties_export.setter
    def custom_properties_export(self, custom_properties_export):
        self.container['custom_properties_export'] = custom_properties_export 
    @property
    def optimization_type(self):
        return self.container['optimization_type']

    @optimization_type.setter
    def optimization_type(self, optimization_type):
        self.container['optimization_type'] = optimization_type 
    @property
    def producer(self):
        return self.container['producer']

    @producer.setter
    def producer(self, producer):
        self.container['producer'] = producer 
    @property
    def pdf_compression(self):
        return self.container['pdf_compression']

    @pdf_compression.setter
    def pdf_compression(self, pdf_compression):
        self.container['pdf_compression'] = pdf_compression 
    @property
    def font_encoding(self):
        return self.container['font_encoding']

    @font_encoding.setter
    def font_encoding(self, font_encoding):
        self.container['font_encoding'] = font_encoding 
    @property
    def watermark(self):
        return self.container['watermark']

    @watermark.setter
    def watermark(self, watermark):
        self.container['watermark'] = watermark 
    @property
    def calculate_formula(self):
        return self.container['calculate_formula']

    @calculate_formula.setter
    def calculate_formula(self, calculate_formula):
        self.container['calculate_formula'] = calculate_formula 
    @property
    def check_font_compatibility(self):
        return self.container['check_font_compatibility']

    @check_font_compatibility.setter
    def check_font_compatibility(self, check_font_compatibility):
        self.container['check_font_compatibility'] = check_font_compatibility 
    @property
    def compliance(self):
        return self.container['compliance']

    @compliance.setter
    def compliance(self, compliance):
        self.container['compliance'] = compliance 
    @property
    def default_font(self):
        return self.container['default_font']

    @default_font.setter
    def default_font(self, default_font):
        self.container['default_font'] = default_font 
    @property
    def one_page_per_sheet(self):
        return self.container['one_page_per_sheet']

    @one_page_per_sheet.setter
    def one_page_per_sheet(self, one_page_per_sheet):
        self.container['one_page_per_sheet'] = one_page_per_sheet 
    @property
    def printing_page_type(self):
        return self.container['printing_page_type']

    @printing_page_type.setter
    def printing_page_type(self, printing_page_type):
        self.container['printing_page_type'] = printing_page_type 
    @property
    def security_options(self):
        return self.container['security_options']

    @security_options.setter
    def security_options(self, security_options):
        self.container['security_options'] = security_options 
    @property
    def desired_ppi(self):
        return self.container['desired_ppi']

    @desired_ppi.setter
    def desired_ppi(self, desired_ppi):
        self.container['desired_ppi'] = desired_ppi 
    @property
    def jpeg_quality(self):
        return self.container['jpeg_quality']

    @jpeg_quality.setter
    def jpeg_quality(self, jpeg_quality):
        self.container['jpeg_quality'] = jpeg_quality 
    @property
    def image_type(self):
        return self.container['image_type']

    @image_type.setter
    def image_type(self, image_type):
        self.container['image_type'] = image_type 
    @property
    def save_format(self):
        return self.container['save_format']

    @save_format.setter
    def save_format(self, save_format):
        self.container['save_format'] = save_format 
    @property
    def cached_file_folder(self):
        return self.container['cached_file_folder']

    @cached_file_folder.setter
    def cached_file_folder(self, cached_file_folder):
        self.container['cached_file_folder'] = cached_file_folder 
    @property
    def clear_data(self):
        return self.container['clear_data']

    @clear_data.setter
    def clear_data(self, clear_data):
        self.container['clear_data'] = clear_data 
    @property
    def create_directory(self):
        return self.container['create_directory']

    @create_directory.setter
    def create_directory(self, create_directory):
        self.container['create_directory'] = create_directory 
    @property
    def enable_http_compression(self):
        return self.container['enable_http_compression']

    @enable_http_compression.setter
    def enable_http_compression(self, enable_http_compression):
        self.container['enable_http_compression'] = enable_http_compression 
    @property
    def refresh_chart_cache(self):
        return self.container['refresh_chart_cache']

    @refresh_chart_cache.setter
    def refresh_chart_cache(self, refresh_chart_cache):
        self.container['refresh_chart_cache'] = refresh_chart_cache 
    @property
    def sort_names(self):
        return self.container['sort_names']

    @sort_names.setter
    def sort_names(self, sort_names):
        self.container['sort_names'] = sort_names 
    @property
    def validate_merged_areas(self):
        return self.container['validate_merged_areas']

    @validate_merged_areas.setter
    def validate_merged_areas(self, validate_merged_areas):
        self.container['validate_merged_areas'] = validate_merged_areas 
    @property
    def merge_areas(self):
        return self.container['merge_areas']

    @merge_areas.setter
    def merge_areas(self, merge_areas):
        self.container['merge_areas'] = merge_areas 
    @property
    def sort_external_names(self):
        return self.container['sort_external_names']

    @sort_external_names.setter
    def sort_external_names(self, sort_external_names):
        self.container['sort_external_names'] = sort_external_names 
    @property
    def check_excel_restriction(self):
        return self.container['check_excel_restriction']

    @check_excel_restriction.setter
    def check_excel_restriction(self, check_excel_restriction):
        self.container['check_excel_restriction'] = check_excel_restriction 
    @property
    def update_smart_art(self):
        return self.container['update_smart_art']

    @update_smart_art.setter
    def update_smart_art(self, update_smart_art):
        self.container['update_smart_art'] = update_smart_art 
    @property
    def encrypt_document_properties(self):
        return self.container['encrypt_document_properties']

    @encrypt_document_properties.setter
    def encrypt_document_properties(self, encrypt_document_properties):
        self.container['encrypt_document_properties'] = encrypt_document_properties 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PdfSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    