# coding: utf-8
"""
<copyright company="Aspose" file="PivotFieldpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PivotField(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_show_count' : 'int',
        'auto_show_field' : 'int',
        'auto_sort_field' : 'int',
        'base_field' : 'int',
        'base_index' : 'int',
        'base_item' : 'int',
        'base_item_position' : 'str',
        'current_page_item' : 'int',
        'data_display_format' : 'str',
        'display_name' : 'str',
        'drag_to_column' : 'bool',
        'drag_to_data' : 'bool',
        'drag_to_hide' : 'bool',
        'drag_to_page' : 'bool',
        'drag_to_row' : 'bool',
        'function' : 'str',
        'insert_blank_row' : 'bool',
        'is_ascend_show' : 'bool',
        'is_ascend_sort' : 'bool',
        'is_auto_show' : 'bool',
        'is_auto_sort' : 'bool',
        'is_auto_subtotals' : 'bool',
        'is_calculated_field' : 'bool',
        'is_include_new_items_in_filter' : 'bool',
        'is_insert_page_breaks_between_items' : 'bool',
        'is_multiple_item_selection_allowed' : 'bool',
        'is_repeat_item_labels' : 'bool',
        'item_count' : 'int',
        'items' : 'list[str]',
        'name' : 'str',
        'number' : 'int',
        'number_format' : 'str',
        'original_items' : 'list[str]',
        'pivot_items' : 'list[PivotItem]',
        'position' : 'int',
        'show_all_items' : 'bool',
        'show_compact' : 'bool',
        'show_in_outline_form' : 'bool',
        'show_subtotal_at_top' : 'bool'
    }

    attribute_map = {
        'auto_show_count' : 'AutoShowCount' ,
        'auto_show_field' : 'AutoShowField' ,
        'auto_sort_field' : 'AutoSortField' ,
        'base_field' : 'BaseField' ,
        'base_index' : 'BaseIndex' ,
        'base_item' : 'BaseItem' ,
        'base_item_position' : 'BaseItemPosition' ,
        'current_page_item' : 'CurrentPageItem' ,
        'data_display_format' : 'DataDisplayFormat' ,
        'display_name' : 'DisplayName' ,
        'drag_to_column' : 'DragToColumn' ,
        'drag_to_data' : 'DragToData' ,
        'drag_to_hide' : 'DragToHide' ,
        'drag_to_page' : 'DragToPage' ,
        'drag_to_row' : 'DragToRow' ,
        'function' : 'Function' ,
        'insert_blank_row' : 'InsertBlankRow' ,
        'is_ascend_show' : 'IsAscendShow' ,
        'is_ascend_sort' : 'IsAscendSort' ,
        'is_auto_show' : 'IsAutoShow' ,
        'is_auto_sort' : 'IsAutoSort' ,
        'is_auto_subtotals' : 'IsAutoSubtotals' ,
        'is_calculated_field' : 'IsCalculatedField' ,
        'is_include_new_items_in_filter' : 'IsIncludeNewItemsInFilter' ,
        'is_insert_page_breaks_between_items' : 'IsInsertPageBreaksBetweenItems' ,
        'is_multiple_item_selection_allowed' : 'IsMultipleItemSelectionAllowed' ,
        'is_repeat_item_labels' : 'IsRepeatItemLabels' ,
        'item_count' : 'ItemCount' ,
        'items' : 'Items' ,
        'name' : 'Name' ,
        'number' : 'Number' ,
        'number_format' : 'NumberFormat' ,
        'original_items' : 'OriginalItems' ,
        'pivot_items' : 'PivotItems' ,
        'position' : 'Position' ,
        'show_all_items' : 'ShowAllItems' ,
        'show_compact' : 'ShowCompact' ,
        'show_in_outline_form' : 'ShowInOutlineForm' ,
        'show_subtotal_at_top' : 'ShowSubtotalAtTop' 
    }

    @staticmethod
    def get_swagger_types():
        return PivotField.swagger_types

    @staticmethod
    def get_attribute_map():
        return PivotField.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_show_count=None ,auto_show_field=None ,auto_sort_field=None ,base_field=None ,base_index=None ,base_item=None ,base_item_position=None ,current_page_item=None ,data_display_format=None ,display_name=None ,drag_to_column=None ,drag_to_data=None ,drag_to_hide=None ,drag_to_page=None ,drag_to_row=None ,function=None ,insert_blank_row=None ,is_ascend_show=None ,is_ascend_sort=None ,is_auto_show=None ,is_auto_sort=None ,is_auto_subtotals=None ,is_calculated_field=None ,is_include_new_items_in_filter=None ,is_insert_page_breaks_between_items=None ,is_multiple_item_selection_allowed=None ,is_repeat_item_labels=None ,item_count=None ,items=None ,name=None ,number=None ,number_format=None ,original_items=None ,pivot_items=None ,position=None ,show_all_items=None ,show_compact=None ,show_in_outline_form=None ,show_subtotal_at_top=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PivotField - a model defined in Swagger
        """
        self.container['auto_show_count'] = None 
        self.container['auto_show_field'] = None 
        self.container['auto_sort_field'] = None 
        self.container['base_field'] = None 
        self.container['base_index'] = None 
        self.container['base_item'] = None 
        self.container['base_item_position'] = None 
        self.container['current_page_item'] = None 
        self.container['data_display_format'] = None 
        self.container['display_name'] = None 
        self.container['drag_to_column'] = None 
        self.container['drag_to_data'] = None 
        self.container['drag_to_hide'] = None 
        self.container['drag_to_page'] = None 
        self.container['drag_to_row'] = None 
        self.container['function'] = None 
        self.container['insert_blank_row'] = None 
        self.container['is_ascend_show'] = None 
        self.container['is_ascend_sort'] = None 
        self.container['is_auto_show'] = None 
        self.container['is_auto_sort'] = None 
        self.container['is_auto_subtotals'] = None 
        self.container['is_calculated_field'] = None 
        self.container['is_include_new_items_in_filter'] = None 
        self.container['is_insert_page_breaks_between_items'] = None 
        self.container['is_multiple_item_selection_allowed'] = None 
        self.container['is_repeat_item_labels'] = None 
        self.container['item_count'] = None 
        self.container['items'] = None 
        self.container['name'] = None 
        self.container['number'] = None 
        self.container['number_format'] = None 
        self.container['original_items'] = None 
        self.container['pivot_items'] = None 
        self.container['position'] = None 
        self.container['show_all_items'] = None 
        self.container['show_compact'] = None 
        self.container['show_in_outline_form'] = None 
        self.container['show_subtotal_at_top'] = None 
        params = locals()
        self.auto_show_count = auto_show_count
        if 'auto_show_count' in params:
            self.auto_show_count = params["auto_show_count"]


             
        self.auto_show_field = auto_show_field
        if 'auto_show_field' in params:
            self.auto_show_field = params["auto_show_field"]


             
        self.auto_sort_field = auto_sort_field
        if 'auto_sort_field' in params:
            self.auto_sort_field = params["auto_sort_field"]


             
        self.base_field = base_field
        if 'base_field' in params:
            self.base_field = params["base_field"]


             
        self.base_index = base_index
        if 'base_index' in params:
            self.base_index = params["base_index"]


             
        self.base_item = base_item
        if 'base_item' in params:
            self.base_item = params["base_item"]


             
        self.base_item_position = base_item_position
        if 'base_item_position' in params:
            self.base_item_position = params["base_item_position"]


             
        self.current_page_item = current_page_item
        if 'current_page_item' in params:
            self.current_page_item = params["current_page_item"]


             
        self.data_display_format = data_display_format
        if 'data_display_format' in params:
            self.data_display_format = params["data_display_format"]


             
        self.display_name = display_name
        if 'display_name' in params:
            self.display_name = params["display_name"]


             
        self.drag_to_column = drag_to_column
        if 'drag_to_column' in params:
            self.drag_to_column = params["drag_to_column"]


             
        self.drag_to_data = drag_to_data
        if 'drag_to_data' in params:
            self.drag_to_data = params["drag_to_data"]


             
        self.drag_to_hide = drag_to_hide
        if 'drag_to_hide' in params:
            self.drag_to_hide = params["drag_to_hide"]


             
        self.drag_to_page = drag_to_page
        if 'drag_to_page' in params:
            self.drag_to_page = params["drag_to_page"]


             
        self.drag_to_row = drag_to_row
        if 'drag_to_row' in params:
            self.drag_to_row = params["drag_to_row"]


             
        self.function = function
        if 'function' in params:
            self.function = params["function"]


             
        self.insert_blank_row = insert_blank_row
        if 'insert_blank_row' in params:
            self.insert_blank_row = params["insert_blank_row"]


             
        self.is_ascend_show = is_ascend_show
        if 'is_ascend_show' in params:
            self.is_ascend_show = params["is_ascend_show"]


             
        self.is_ascend_sort = is_ascend_sort
        if 'is_ascend_sort' in params:
            self.is_ascend_sort = params["is_ascend_sort"]


             
        self.is_auto_show = is_auto_show
        if 'is_auto_show' in params:
            self.is_auto_show = params["is_auto_show"]


             
        self.is_auto_sort = is_auto_sort
        if 'is_auto_sort' in params:
            self.is_auto_sort = params["is_auto_sort"]


             
        self.is_auto_subtotals = is_auto_subtotals
        if 'is_auto_subtotals' in params:
            self.is_auto_subtotals = params["is_auto_subtotals"]


             
        self.is_calculated_field = is_calculated_field
        if 'is_calculated_field' in params:
            self.is_calculated_field = params["is_calculated_field"]


             
        self.is_include_new_items_in_filter = is_include_new_items_in_filter
        if 'is_include_new_items_in_filter' in params:
            self.is_include_new_items_in_filter = params["is_include_new_items_in_filter"]


             
        self.is_insert_page_breaks_between_items = is_insert_page_breaks_between_items
        if 'is_insert_page_breaks_between_items' in params:
            self.is_insert_page_breaks_between_items = params["is_insert_page_breaks_between_items"]


             
        self.is_multiple_item_selection_allowed = is_multiple_item_selection_allowed
        if 'is_multiple_item_selection_allowed' in params:
            self.is_multiple_item_selection_allowed = params["is_multiple_item_selection_allowed"]


             
        self.is_repeat_item_labels = is_repeat_item_labels
        if 'is_repeat_item_labels' in params:
            self.is_repeat_item_labels = params["is_repeat_item_labels"]


             
        self.item_count = item_count
        if 'item_count' in params:
            self.item_count = params["item_count"]


             
        self.items = items
        if 'items' in params:
            self.items = params["items"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.number = number
        if 'number' in params:
            self.number = params["number"]


             
        self.number_format = number_format
        if 'number_format' in params:
            self.number_format = params["number_format"]


             
        self.original_items = original_items
        if 'original_items' in params:
            self.original_items = params["original_items"]


             
        self.pivot_items = pivot_items
        if 'pivot_items' in params:
            self.pivot_items = params["pivot_items"]


             
        self.position = position
        if 'position' in params:
            self.position = params["position"]


             
        self.show_all_items = show_all_items
        if 'show_all_items' in params:
            self.show_all_items = params["show_all_items"]


             
        self.show_compact = show_compact
        if 'show_compact' in params:
            self.show_compact = params["show_compact"]


             
        self.show_in_outline_form = show_in_outline_form
        if 'show_in_outline_form' in params:
            self.show_in_outline_form = params["show_in_outline_form"]


             
        self.show_subtotal_at_top = show_subtotal_at_top
        if 'show_subtotal_at_top' in params:
            self.show_subtotal_at_top = params["show_subtotal_at_top"]


             

    @property
    def auto_show_count(self):
        return self.container['auto_show_count']

    @auto_show_count.setter
    def auto_show_count(self, auto_show_count):
        self.container['auto_show_count'] = auto_show_count 
    @property
    def auto_show_field(self):
        return self.container['auto_show_field']

    @auto_show_field.setter
    def auto_show_field(self, auto_show_field):
        self.container['auto_show_field'] = auto_show_field 
    @property
    def auto_sort_field(self):
        return self.container['auto_sort_field']

    @auto_sort_field.setter
    def auto_sort_field(self, auto_sort_field):
        self.container['auto_sort_field'] = auto_sort_field 
    @property
    def base_field(self):
        return self.container['base_field']

    @base_field.setter
    def base_field(self, base_field):
        self.container['base_field'] = base_field 
    @property
    def base_index(self):
        return self.container['base_index']

    @base_index.setter
    def base_index(self, base_index):
        self.container['base_index'] = base_index 
    @property
    def base_item(self):
        return self.container['base_item']

    @base_item.setter
    def base_item(self, base_item):
        self.container['base_item'] = base_item 
    @property
    def base_item_position(self):
        return self.container['base_item_position']

    @base_item_position.setter
    def base_item_position(self, base_item_position):
        self.container['base_item_position'] = base_item_position 
    @property
    def current_page_item(self):
        return self.container['current_page_item']

    @current_page_item.setter
    def current_page_item(self, current_page_item):
        self.container['current_page_item'] = current_page_item 
    @property
    def data_display_format(self):
        return self.container['data_display_format']

    @data_display_format.setter
    def data_display_format(self, data_display_format):
        self.container['data_display_format'] = data_display_format 
    @property
    def display_name(self):
        return self.container['display_name']

    @display_name.setter
    def display_name(self, display_name):
        self.container['display_name'] = display_name 
    @property
    def drag_to_column(self):
        return self.container['drag_to_column']

    @drag_to_column.setter
    def drag_to_column(self, drag_to_column):
        self.container['drag_to_column'] = drag_to_column 
    @property
    def drag_to_data(self):
        return self.container['drag_to_data']

    @drag_to_data.setter
    def drag_to_data(self, drag_to_data):
        self.container['drag_to_data'] = drag_to_data 
    @property
    def drag_to_hide(self):
        return self.container['drag_to_hide']

    @drag_to_hide.setter
    def drag_to_hide(self, drag_to_hide):
        self.container['drag_to_hide'] = drag_to_hide 
    @property
    def drag_to_page(self):
        return self.container['drag_to_page']

    @drag_to_page.setter
    def drag_to_page(self, drag_to_page):
        self.container['drag_to_page'] = drag_to_page 
    @property
    def drag_to_row(self):
        return self.container['drag_to_row']

    @drag_to_row.setter
    def drag_to_row(self, drag_to_row):
        self.container['drag_to_row'] = drag_to_row 
    @property
    def function(self):
        return self.container['function']

    @function.setter
    def function(self, function):
        self.container['function'] = function 
    @property
    def insert_blank_row(self):
        return self.container['insert_blank_row']

    @insert_blank_row.setter
    def insert_blank_row(self, insert_blank_row):
        self.container['insert_blank_row'] = insert_blank_row 
    @property
    def is_ascend_show(self):
        return self.container['is_ascend_show']

    @is_ascend_show.setter
    def is_ascend_show(self, is_ascend_show):
        self.container['is_ascend_show'] = is_ascend_show 
    @property
    def is_ascend_sort(self):
        return self.container['is_ascend_sort']

    @is_ascend_sort.setter
    def is_ascend_sort(self, is_ascend_sort):
        self.container['is_ascend_sort'] = is_ascend_sort 
    @property
    def is_auto_show(self):
        return self.container['is_auto_show']

    @is_auto_show.setter
    def is_auto_show(self, is_auto_show):
        self.container['is_auto_show'] = is_auto_show 
    @property
    def is_auto_sort(self):
        return self.container['is_auto_sort']

    @is_auto_sort.setter
    def is_auto_sort(self, is_auto_sort):
        self.container['is_auto_sort'] = is_auto_sort 
    @property
    def is_auto_subtotals(self):
        return self.container['is_auto_subtotals']

    @is_auto_subtotals.setter
    def is_auto_subtotals(self, is_auto_subtotals):
        self.container['is_auto_subtotals'] = is_auto_subtotals 
    @property
    def is_calculated_field(self):
        return self.container['is_calculated_field']

    @is_calculated_field.setter
    def is_calculated_field(self, is_calculated_field):
        self.container['is_calculated_field'] = is_calculated_field 
    @property
    def is_include_new_items_in_filter(self):
        return self.container['is_include_new_items_in_filter']

    @is_include_new_items_in_filter.setter
    def is_include_new_items_in_filter(self, is_include_new_items_in_filter):
        self.container['is_include_new_items_in_filter'] = is_include_new_items_in_filter 
    @property
    def is_insert_page_breaks_between_items(self):
        return self.container['is_insert_page_breaks_between_items']

    @is_insert_page_breaks_between_items.setter
    def is_insert_page_breaks_between_items(self, is_insert_page_breaks_between_items):
        self.container['is_insert_page_breaks_between_items'] = is_insert_page_breaks_between_items 
    @property
    def is_multiple_item_selection_allowed(self):
        return self.container['is_multiple_item_selection_allowed']

    @is_multiple_item_selection_allowed.setter
    def is_multiple_item_selection_allowed(self, is_multiple_item_selection_allowed):
        self.container['is_multiple_item_selection_allowed'] = is_multiple_item_selection_allowed 
    @property
    def is_repeat_item_labels(self):
        return self.container['is_repeat_item_labels']

    @is_repeat_item_labels.setter
    def is_repeat_item_labels(self, is_repeat_item_labels):
        self.container['is_repeat_item_labels'] = is_repeat_item_labels 
    @property
    def item_count(self):
        return self.container['item_count']

    @item_count.setter
    def item_count(self, item_count):
        self.container['item_count'] = item_count 
    @property
    def items(self):
        return self.container['items']

    @items.setter
    def items(self, items):
        self.container['items'] = items 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def number(self):
        return self.container['number']

    @number.setter
    def number(self, number):
        self.container['number'] = number 
    @property
    def number_format(self):
        return self.container['number_format']

    @number_format.setter
    def number_format(self, number_format):
        self.container['number_format'] = number_format 
    @property
    def original_items(self):
        return self.container['original_items']

    @original_items.setter
    def original_items(self, original_items):
        self.container['original_items'] = original_items 
    @property
    def pivot_items(self):
        return self.container['pivot_items']

    @pivot_items.setter
    def pivot_items(self, pivot_items):
        self.container['pivot_items'] = pivot_items 
    @property
    def position(self):
        return self.container['position']

    @position.setter
    def position(self, position):
        self.container['position'] = position 
    @property
    def show_all_items(self):
        return self.container['show_all_items']

    @show_all_items.setter
    def show_all_items(self, show_all_items):
        self.container['show_all_items'] = show_all_items 
    @property
    def show_compact(self):
        return self.container['show_compact']

    @show_compact.setter
    def show_compact(self, show_compact):
        self.container['show_compact'] = show_compact 
    @property
    def show_in_outline_form(self):
        return self.container['show_in_outline_form']

    @show_in_outline_form.setter
    def show_in_outline_form(self, show_in_outline_form):
        self.container['show_in_outline_form'] = show_in_outline_form 
    @property
    def show_subtotal_at_top(self):
        return self.container['show_subtotal_at_top']

    @show_subtotal_at_top.setter
    def show_subtotal_at_top(self, show_subtotal_at_top):
        self.container['show_subtotal_at_top'] = show_subtotal_at_top 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PivotField):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    