# coding: utf-8
"""
<copyright company="Aspose" file="PivotFilterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PivotFilter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_filter' : 'AutoFilter',
        'evaluation_order' : 'int',
        'field_index' : 'int',
        'filter_type' : 'str',
        'value_field_index' : 'int',
        'member_property_field_index' : 'int',
        'name' : 'str',
        'value1' : 'str',
        'value2' : 'str',
        'top10_filter' : 'Top10Filter'
    }

    attribute_map = {
        'auto_filter' : 'AutoFilter' ,
        'evaluation_order' : 'EvaluationOrder' ,
        'field_index' : 'FieldIndex' ,
        'filter_type' : 'FilterType' ,
        'value_field_index' : 'ValueFieldIndex' ,
        'member_property_field_index' : 'MemberPropertyFieldIndex' ,
        'name' : 'Name' ,
        'value1' : 'Value1' ,
        'value2' : 'Value2' ,
        'top10_filter' : 'Top10Filter' 
    }

    @staticmethod
    def get_swagger_types():
        return PivotFilter.swagger_types

    @staticmethod
    def get_attribute_map():
        return PivotFilter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_filter=None ,evaluation_order=None ,field_index=None ,filter_type=None ,value_field_index=None ,member_property_field_index=None ,name=None ,value1=None ,value2=None ,top10_filter=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PivotFilter - a model defined in Swagger
        """
        self.container['auto_filter'] = None 
        self.container['evaluation_order'] = None 
        self.container['field_index'] = None 
        self.container['filter_type'] = None 
        self.container['value_field_index'] = None 
        self.container['member_property_field_index'] = None 
        self.container['name'] = None 
        self.container['value1'] = None 
        self.container['value2'] = None 
        self.container['top10_filter'] = None 
        params = locals()
        self.auto_filter = auto_filter
        if 'auto_filter' in params:
            self.auto_filter = params["auto_filter"]


             
        self.evaluation_order = evaluation_order
        if 'evaluation_order' in params:
            self.evaluation_order = params["evaluation_order"]


             
        self.field_index = field_index
        if 'field_index' in params:
            self.field_index = params["field_index"]


             
        self.filter_type = filter_type
        if 'filter_type' in params:
            self.filter_type = params["filter_type"]


             
        self.value_field_index = value_field_index
        if 'value_field_index' in params:
            self.value_field_index = params["value_field_index"]


             
        self.member_property_field_index = member_property_field_index
        if 'member_property_field_index' in params:
            self.member_property_field_index = params["member_property_field_index"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.value1 = value1
        if 'value1' in params:
            self.value1 = params["value1"]


             
        self.value2 = value2
        if 'value2' in params:
            self.value2 = params["value2"]


             
        self.top10_filter = top10_filter
        if 'top10_filter' in params:
            self.top10_filter = params["top10_filter"]


             

    @property
    def auto_filter(self):
        return self.container['auto_filter']

    @auto_filter.setter
    def auto_filter(self, auto_filter):
        self.container['auto_filter'] = auto_filter 
    @property
    def evaluation_order(self):
        return self.container['evaluation_order']

    @evaluation_order.setter
    def evaluation_order(self, evaluation_order):
        self.container['evaluation_order'] = evaluation_order 
    @property
    def field_index(self):
        return self.container['field_index']

    @field_index.setter
    def field_index(self, field_index):
        self.container['field_index'] = field_index 
    @property
    def filter_type(self):
        return self.container['filter_type']

    @filter_type.setter
    def filter_type(self, filter_type):
        self.container['filter_type'] = filter_type 
    @property
    def value_field_index(self):
        return self.container['value_field_index']

    @value_field_index.setter
    def value_field_index(self, value_field_index):
        self.container['value_field_index'] = value_field_index 
    @property
    def member_property_field_index(self):
        return self.container['member_property_field_index']

    @member_property_field_index.setter
    def member_property_field_index(self, member_property_field_index):
        self.container['member_property_field_index'] = member_property_field_index 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def value1(self):
        return self.container['value1']

    @value1.setter
    def value1(self, value1):
        self.container['value1'] = value1 
    @property
    def value2(self):
        return self.container['value2']

    @value2.setter
    def value2(self, value2):
        self.container['value2'] = value2 
    @property
    def top10_filter(self):
        return self.container['top10_filter']

    @top10_filter.setter
    def top10_filter(self, top10_filter):
        self.container['top10_filter'] = top10_filter 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PivotFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    