# coding: utf-8
"""
<copyright company="Aspose" file="PivotTableOperateParameterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PivotTableOperateParameter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'source_data' : 'str',
        'dest_cell_name' : 'str',
        'table_name' : 'str',
        'use_same_source' : 'bool',
        'pivot_table_index' : 'int',
        'pivot_field_rows' : 'list[int]',
        'pivot_field_columns' : 'list[int]',
        'pivot_field_data' : 'list[int]',
        'operate_type' : 'str'
    }

    attribute_map = {
        'source_data' : 'SourceData' ,
        'dest_cell_name' : 'DestCellName' ,
        'table_name' : 'TableName' ,
        'use_same_source' : 'UseSameSource' ,
        'pivot_table_index' : 'PivotTableIndex' ,
        'pivot_field_rows' : 'PivotFieldRows' ,
        'pivot_field_columns' : 'PivotFieldColumns' ,
        'pivot_field_data' : 'PivotFieldData' ,
        'operate_type' : 'OperateType' 
    }

    @staticmethod
    def get_swagger_types():
        return PivotTableOperateParameter.swagger_types

    @staticmethod
    def get_attribute_map():
        return PivotTableOperateParameter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,source_data=None ,dest_cell_name=None ,table_name=None ,use_same_source=None ,pivot_table_index=None ,pivot_field_rows=None ,pivot_field_columns=None ,pivot_field_data=None ,operate_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PivotTableOperateParameter - a model defined in Swagger
        """
        self.container['source_data'] = None 
        self.container['dest_cell_name'] = None 
        self.container['table_name'] = None 
        self.container['use_same_source'] = None 
        self.container['pivot_table_index'] = None 
        self.container['pivot_field_rows'] = None 
        self.container['pivot_field_columns'] = None 
        self.container['pivot_field_data'] = None 
        self.container['operate_type'] = None 
        params = locals()
        self.source_data = source_data
        if 'source_data' in params:
            self.source_data = params["source_data"]


             
        self.dest_cell_name = dest_cell_name
        if 'dest_cell_name' in params:
            self.dest_cell_name = params["dest_cell_name"]


             
        self.table_name = table_name
        if 'table_name' in params:
            self.table_name = params["table_name"]


             
        self.use_same_source = use_same_source
        if 'use_same_source' in params:
            self.use_same_source = params["use_same_source"]


             
        self.pivot_table_index = pivot_table_index
        if 'pivot_table_index' in params:
            self.pivot_table_index = params["pivot_table_index"]


             
        self.pivot_field_rows = pivot_field_rows
        if 'pivot_field_rows' in params:
            self.pivot_field_rows = params["pivot_field_rows"]


             
        self.pivot_field_columns = pivot_field_columns
        if 'pivot_field_columns' in params:
            self.pivot_field_columns = params["pivot_field_columns"]


             
        self.pivot_field_data = pivot_field_data
        if 'pivot_field_data' in params:
            self.pivot_field_data = params["pivot_field_data"]


             
        self.operate_type = operate_type
        if 'operate_type' in params:
            self.operate_type = params["operate_type"]


             

    @property
    def source_data(self):
        return self.container['source_data']

    @source_data.setter
    def source_data(self, source_data):
        self.container['source_data'] = source_data 
    @property
    def dest_cell_name(self):
        return self.container['dest_cell_name']

    @dest_cell_name.setter
    def dest_cell_name(self, dest_cell_name):
        self.container['dest_cell_name'] = dest_cell_name 
    @property
    def table_name(self):
        return self.container['table_name']

    @table_name.setter
    def table_name(self, table_name):
        self.container['table_name'] = table_name 
    @property
    def use_same_source(self):
        return self.container['use_same_source']

    @use_same_source.setter
    def use_same_source(self, use_same_source):
        self.container['use_same_source'] = use_same_source 
    @property
    def pivot_table_index(self):
        return self.container['pivot_table_index']

    @pivot_table_index.setter
    def pivot_table_index(self, pivot_table_index):
        self.container['pivot_table_index'] = pivot_table_index 
    @property
    def pivot_field_rows(self):
        return self.container['pivot_field_rows']

    @pivot_field_rows.setter
    def pivot_field_rows(self, pivot_field_rows):
        self.container['pivot_field_rows'] = pivot_field_rows 
    @property
    def pivot_field_columns(self):
        return self.container['pivot_field_columns']

    @pivot_field_columns.setter
    def pivot_field_columns(self, pivot_field_columns):
        self.container['pivot_field_columns'] = pivot_field_columns 
    @property
    def pivot_field_data(self):
        return self.container['pivot_field_data']

    @pivot_field_data.setter
    def pivot_field_data(self, pivot_field_data):
        self.container['pivot_field_data'] = pivot_field_data 
    @property
    def operate_type(self):
        return self.container['operate_type']

    @operate_type.setter
    def operate_type(self, operate_type):
        self.container['operate_type'] = operate_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PivotTableOperateParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    