# coding: utf-8
"""
<copyright company="Aspose" file="RangeConvertRequestpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class RangeConvertRequest(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'source' : 'Range',
        'image_type' : 'str',
        'image_or_print_options' : 'ImageOrPrintOptions',
        'page_setup' : 'PageSetup'
    }

    attribute_map = {
        'source' : 'Source' ,
        'image_type' : 'ImageType' ,
        'image_or_print_options' : 'ImageOrPrintOptions' ,
        'page_setup' : 'PageSetup' 
    }

    @staticmethod
    def get_swagger_types():
        return RangeConvertRequest.swagger_types

    @staticmethod
    def get_attribute_map():
        return RangeConvertRequest.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,source=None ,image_type=None ,image_or_print_options=None ,page_setup=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        RangeConvertRequest - a model defined in Swagger
        """
        self.container['source'] = None 
        self.container['image_type'] = None 
        self.container['image_or_print_options'] = None 
        self.container['page_setup'] = None 
        params = locals()
        self.source = source
        if 'source' in params:
            self.source = params["source"]


             
        self.image_type = image_type
        if 'image_type' in params:
            self.image_type = params["image_type"]


             
        self.image_or_print_options = image_or_print_options
        if 'image_or_print_options' in params:
            self.image_or_print_options = params["image_or_print_options"]


             
        self.page_setup = page_setup
        if 'page_setup' in params:
            self.page_setup = params["page_setup"]


             

    @property
    def source(self):
        return self.container['source']

    @source.setter
    def source(self, source):
        self.container['source'] = source 
    @property
    def image_type(self):
        return self.container['image_type']

    @image_type.setter
    def image_type(self, image_type):
        self.container['image_type'] = image_type 
    @property
    def image_or_print_options(self):
        return self.container['image_or_print_options']

    @image_or_print_options.setter
    def image_or_print_options(self, image_or_print_options):
        self.container['image_or_print_options'] = image_or_print_options 
    @property
    def page_setup(self):
        return self.container['page_setup']

    @page_setup.setter
    def page_setup(self, page_setup):
        self.container['page_setup'] = page_setup 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RangeConvertRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    