# coding: utf-8
"""
<copyright company="Aspose" file="ResultDestinationpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ResultDestination(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'destination_type' : 'str',
        'input_file' : 'str',
        'output_file' : 'str'
    }

    attribute_map = {
        'destination_type' : 'DestinationType' ,
        'input_file' : 'InputFile' ,
        'output_file' : 'OutputFile' 
    }

    @staticmethod
    def get_swagger_types():
        return ResultDestination.swagger_types

    @staticmethod
    def get_attribute_map():
        return ResultDestination.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,destination_type=None ,input_file=None ,output_file=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ResultDestination - a model defined in Swagger
        """
        self.container['destination_type'] = None 
        self.container['input_file'] = None 
        self.container['output_file'] = None 
        params = locals()
        self.destination_type = destination_type
        if 'destination_type' in params:
            self.destination_type = params["destination_type"]


             
        self.input_file = input_file
        if 'input_file' in params:
            self.input_file = params["input_file"]


             
        self.output_file = output_file
        if 'output_file' in params:
            self.output_file = params["output_file"]


             

    @property
    def destination_type(self):
        return self.container['destination_type']

    @destination_type.setter
    def destination_type(self, destination_type):
        self.container['destination_type'] = destination_type 
    @property
    def input_file(self):
        return self.container['input_file']

    @input_file.setter
    def input_file(self, input_file):
        self.container['input_file'] = input_file 
    @property
    def output_file(self):
        return self.container['output_file']

    @output_file.setter
    def output_file(self, output_file):
        self.container['output_file'] = output_file 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ResultDestination):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    