# coding: utf-8
"""
<copyright company="Aspose" file="SmartMarkerTaskParameterpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SmartMarkerTaskParameter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'source_workbook' : 'FileSource',
        'destination_workbook' : 'FileSource',
        'xml_file' : 'FileSource',
        'data_source' : 'DataSource',
        'target_data_source' : 'DataSource',
        'xml_file_data_source' : 'DataSource'
    }

    attribute_map = {
        'source_workbook' : 'SourceWorkbook' ,
        'destination_workbook' : 'DestinationWorkbook' ,
        'xml_file' : 'xmlFile' ,
        'data_source' : 'DataSource' ,
        'target_data_source' : 'TargetDataSource' ,
        'xml_file_data_source' : 'XMLFileDataSource' 
    }

    @staticmethod
    def get_swagger_types():
        return SmartMarkerTaskParameter.swagger_types

    @staticmethod
    def get_attribute_map():
        return SmartMarkerTaskParameter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,source_workbook=None ,destination_workbook=None ,xml_file=None ,data_source=None ,target_data_source=None ,xml_file_data_source=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SmartMarkerTaskParameter - a model defined in Swagger
        """
        self.container['source_workbook'] = None 
        self.container['destination_workbook'] = None 
        self.container['xml_file'] = None 
        self.container['data_source'] = None 
        self.container['target_data_source'] = None 
        self.container['xml_file_data_source'] = None 
        params = locals()
        self.source_workbook = source_workbook
        if 'source_workbook' in params:
            self.source_workbook = params["source_workbook"]


             
        self.destination_workbook = destination_workbook
        if 'destination_workbook' in params:
            self.destination_workbook = params["destination_workbook"]


             
        self.xml_file = xml_file
        if 'xml_file' in params:
            self.xml_file = params["xml_file"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.target_data_source = target_data_source
        if 'target_data_source' in params:
            self.target_data_source = params["target_data_source"]


             
        self.xml_file_data_source = xml_file_data_source
        if 'xml_file_data_source' in params:
            self.xml_file_data_source = params["xml_file_data_source"]


             

    @property
    def source_workbook(self):
        return self.container['source_workbook']

    @source_workbook.setter
    def source_workbook(self, source_workbook):
        self.container['source_workbook'] = source_workbook 
    @property
    def destination_workbook(self):
        return self.container['destination_workbook']

    @destination_workbook.setter
    def destination_workbook(self, destination_workbook):
        self.container['destination_workbook'] = destination_workbook 
    @property
    def xml_file(self):
        return self.container['xml_file']

    @xml_file.setter
    def xml_file(self, xml_file):
        self.container['xml_file'] = xml_file 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def target_data_source(self):
        return self.container['target_data_source']

    @target_data_source.setter
    def target_data_source(self, target_data_source):
        self.container['target_data_source'] = target_data_source 
    @property
    def xml_file_data_source(self):
        return self.container['xml_file_data_source']

    @xml_file_data_source.setter
    def xml_file_data_source(self, xml_file_data_source):
        self.container['xml_file_data_source'] = xml_file_data_source 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SmartMarkerTaskParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    