# coding: utf-8
"""
<copyright company="Aspose" file="SortKeypy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SortKey(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'key' : 'int',
        'sort_order' : 'str',
        'custom_list' : 'list[str]',
        'order' : 'str',
        'index' : 'int',
        'type' : 'str'
    }

    attribute_map = {
        'key' : 'Key' ,
        'sort_order' : 'SortOrder' ,
        'custom_list' : 'CustomList' ,
        'order' : 'Order' ,
        'index' : 'Index' ,
        'type' : 'Type' 
    }

    @staticmethod
    def get_swagger_types():
        return SortKey.swagger_types

    @staticmethod
    def get_attribute_map():
        return SortKey.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,key=None ,sort_order=None ,custom_list=None ,order=None ,index=None ,type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SortKey - a model defined in Swagger
        """
        self.container['key'] = None 
        self.container['sort_order'] = None 
        self.container['custom_list'] = None 
        self.container['order'] = None 
        self.container['index'] = None 
        self.container['type'] = None 
        params = locals()
        self.key = key
        if 'key' in params:
            self.key = params["key"]


             
        self.sort_order = sort_order
        if 'sort_order' in params:
            self.sort_order = params["sort_order"]


             
        self.custom_list = custom_list
        if 'custom_list' in params:
            self.custom_list = params["custom_list"]


             
        self.order = order
        if 'order' in params:
            self.order = params["order"]


             
        self.index = index
        if 'index' in params:
            self.index = params["index"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             

    @property
    def key(self):
        return self.container['key']

    @key.setter
    def key(self, key):
        self.container['key'] = key 
    @property
    def sort_order(self):
        return self.container['sort_order']

    @sort_order.setter
    def sort_order(self, sort_order):
        self.container['sort_order'] = sort_order 
    @property
    def custom_list(self):
        return self.container['custom_list']

    @custom_list.setter
    def custom_list(self, custom_list):
        self.container['custom_list'] = custom_list 
    @property
    def order(self):
        return self.container['order']

    @order.setter
    def order(self, order):
        self.container['order'] = order 
    @property
    def index(self):
        return self.container['index']

    @index.setter
    def index(self, index):
        self.container['index'] = index 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SortKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    