# coding: utf-8
"""
<copyright company="Aspose" file="SpecifyCellsObjectpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SpecifyCellsObject(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'worksheet_name' : 'str',
        'page_index' : 'int',
        'region' : 'str'
    }

    attribute_map = {
        'worksheet_name' : 'WorksheetName' ,
        'page_index' : 'PageIndex' ,
        'region' : 'Region' 
    }

    @staticmethod
    def get_swagger_types():
        return SpecifyCellsObject.swagger_types

    @staticmethod
    def get_attribute_map():
        return SpecifyCellsObject.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,worksheet_name=None ,page_index=None ,region=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SpecifyCellsObject - a model defined in Swagger
        """
        self.container['worksheet_name'] = None 
        self.container['page_index'] = None 
        self.container['region'] = None 
        params = locals()
        self.worksheet_name = worksheet_name
        if 'worksheet_name' in params:
            self.worksheet_name = params["worksheet_name"]


             
        self.page_index = page_index
        if 'page_index' in params:
            self.page_index = params["page_index"]


             
        self.region = region
        if 'region' in params:
            self.region = params["region"]


             

    @property
    def worksheet_name(self):
        return self.container['worksheet_name']

    @worksheet_name.setter
    def worksheet_name(self, worksheet_name):
        self.container['worksheet_name'] = worksheet_name 
    @property
    def page_index(self):
        return self.container['page_index']

    @page_index.setter
    def page_index(self, page_index):
        self.container['page_index'] = page_index 
    @property
    def region(self):
        return self.container['region']

    @region.setter
    def region(self, region):
        self.container['region'] = region 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SpecifyCellsObject):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    