# coding: utf-8
"""
<copyright company="Aspose" file="SplitTextOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SplitTextOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'data_source' : 'DataSource',
        'file_info' : 'FileInfo',
        'worksheet' : 'str',
        'range' : 'str',
        'split_delimiters_type' : 'str',
        'custom_delimiter' : 'str',
        'keep_delimiters_in_resulting_cells' : 'bool',
        'keep_delimiters_position' : 'str',
        'how_to_split' : 'str'
    }

    attribute_map = {
        'name' : 'Name' ,
        'data_source' : 'DataSource' ,
        'file_info' : 'FileInfo' ,
        'worksheet' : 'Worksheet' ,
        'range' : 'Range' ,
        'split_delimiters_type' : 'SplitDelimitersType' ,
        'custom_delimiter' : 'CustomDelimiter' ,
        'keep_delimiters_in_resulting_cells' : 'KeepDelimitersInResultingCells' ,
        'keep_delimiters_position' : 'KeepDelimitersPosition' ,
        'how_to_split' : 'HowToSplit' 
    }

    @staticmethod
    def get_swagger_types():
        return SplitTextOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return SplitTextOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,data_source=None ,file_info=None ,worksheet=None ,range=None ,split_delimiters_type=None ,custom_delimiter=None ,keep_delimiters_in_resulting_cells=None ,keep_delimiters_position=None ,how_to_split=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SplitTextOptions - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['data_source'] = None 
        self.container['file_info'] = None 
        self.container['worksheet'] = None 
        self.container['range'] = None 
        self.container['split_delimiters_type'] = None 
        self.container['custom_delimiter'] = None 
        self.container['keep_delimiters_in_resulting_cells'] = None 
        self.container['keep_delimiters_position'] = None 
        self.container['how_to_split'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.file_info = file_info
        if 'file_info' in params:
            self.file_info = params["file_info"]


             
        self.worksheet = worksheet
        if 'worksheet' in params:
            self.worksheet = params["worksheet"]


             
        self.range = range
        if 'range' in params:
            self.range = params["range"]


             
        self.split_delimiters_type = split_delimiters_type
        if 'split_delimiters_type' in params:
            self.split_delimiters_type = params["split_delimiters_type"]


             
        self.custom_delimiter = custom_delimiter
        if 'custom_delimiter' in params:
            self.custom_delimiter = params["custom_delimiter"]


             
        self.keep_delimiters_in_resulting_cells = keep_delimiters_in_resulting_cells
        if 'keep_delimiters_in_resulting_cells' in params:
            self.keep_delimiters_in_resulting_cells = params["keep_delimiters_in_resulting_cells"]


             
        self.keep_delimiters_position = keep_delimiters_position
        if 'keep_delimiters_position' in params:
            self.keep_delimiters_position = params["keep_delimiters_position"]


             
        self.how_to_split = how_to_split
        if 'how_to_split' in params:
            self.how_to_split = params["how_to_split"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def file_info(self):
        return self.container['file_info']

    @file_info.setter
    def file_info(self, file_info):
        self.container['file_info'] = file_info 
    @property
    def worksheet(self):
        return self.container['worksheet']

    @worksheet.setter
    def worksheet(self, worksheet):
        self.container['worksheet'] = worksheet 
    @property
    def range(self):
        return self.container['range']

    @range.setter
    def range(self, range):
        self.container['range'] = range 
    @property
    def split_delimiters_type(self):
        return self.container['split_delimiters_type']

    @split_delimiters_type.setter
    def split_delimiters_type(self, split_delimiters_type):
        self.container['split_delimiters_type'] = split_delimiters_type 
    @property
    def custom_delimiter(self):
        return self.container['custom_delimiter']

    @custom_delimiter.setter
    def custom_delimiter(self, custom_delimiter):
        self.container['custom_delimiter'] = custom_delimiter 
    @property
    def keep_delimiters_in_resulting_cells(self):
        return self.container['keep_delimiters_in_resulting_cells']

    @keep_delimiters_in_resulting_cells.setter
    def keep_delimiters_in_resulting_cells(self, keep_delimiters_in_resulting_cells):
        self.container['keep_delimiters_in_resulting_cells'] = keep_delimiters_in_resulting_cells 
    @property
    def keep_delimiters_position(self):
        return self.container['keep_delimiters_position']

    @keep_delimiters_position.setter
    def keep_delimiters_position(self, keep_delimiters_position):
        self.container['keep_delimiters_position'] = keep_delimiters_position 
    @property
    def how_to_split(self):
        return self.container['how_to_split']

    @how_to_split.setter
    def how_to_split(self, how_to_split):
        self.container['how_to_split'] = how_to_split 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SplitTextOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    