# coding: utf-8
"""
<copyright company="Aspose" file="SqlScriptSaveOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class SqlScriptSaveOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'check_if_table_exists' : 'bool',
        'column_type_map' : 'str',
        'check_all_data_for_column_type' : 'bool',
        'add_blank_line_between_rows' : 'bool',
        'separator' : 'str',
        'operator_type' : 'str',
        'primary_key' : 'int',
        'create_table' : 'bool',
        'id_name' : 'str',
        'start_id' : 'int',
        'table_name' : 'str',
        'export_as_string' : 'bool',
        'export_area' : 'CellArea',
        'has_header_row' : 'bool',
        'save_format' : 'str',
        'cached_file_folder' : 'str',
        'clear_data' : 'bool',
        'create_directory' : 'bool',
        'enable_http_compression' : 'bool',
        'refresh_chart_cache' : 'bool',
        'sort_names' : 'bool',
        'validate_merged_areas' : 'bool',
        'merge_areas' : 'bool',
        'sort_external_names' : 'bool',
        'check_excel_restriction' : 'bool',
        'update_smart_art' : 'bool',
        'encrypt_document_properties' : 'bool'
    }

    attribute_map = {
        'check_if_table_exists' : 'CheckIfTableExists' ,
        'column_type_map' : 'ColumnTypeMap' ,
        'check_all_data_for_column_type' : 'CheckAllDataForColumnType' ,
        'add_blank_line_between_rows' : 'AddBlankLineBetweenRows' ,
        'separator' : 'Separator' ,
        'operator_type' : 'OperatorType' ,
        'primary_key' : 'PrimaryKey' ,
        'create_table' : 'CreateTable' ,
        'id_name' : 'IdName' ,
        'start_id' : 'StartId' ,
        'table_name' : 'TableName' ,
        'export_as_string' : 'ExportAsString' ,
        'export_area' : 'ExportArea' ,
        'has_header_row' : 'HasHeaderRow' ,
        'save_format' : 'SaveFormat' ,
        'cached_file_folder' : 'CachedFileFolder' ,
        'clear_data' : 'ClearData' ,
        'create_directory' : 'CreateDirectory' ,
        'enable_http_compression' : 'EnableHTTPCompression' ,
        'refresh_chart_cache' : 'RefreshChartCache' ,
        'sort_names' : 'SortNames' ,
        'validate_merged_areas' : 'ValidateMergedAreas' ,
        'merge_areas' : 'MergeAreas' ,
        'sort_external_names' : 'SortExternalNames' ,
        'check_excel_restriction' : 'CheckExcelRestriction' ,
        'update_smart_art' : 'UpdateSmartArt' ,
        'encrypt_document_properties' : 'EncryptDocumentProperties' 
    }

    @staticmethod
    def get_swagger_types():
        return SqlScriptSaveOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return SqlScriptSaveOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,check_if_table_exists=None ,column_type_map=None ,check_all_data_for_column_type=None ,add_blank_line_between_rows=None ,separator=None ,operator_type=None ,primary_key=None ,create_table=None ,id_name=None ,start_id=None ,table_name=None ,export_as_string=None ,export_area=None ,has_header_row=None ,save_format=None ,cached_file_folder=None ,clear_data=None ,create_directory=None ,enable_http_compression=None ,refresh_chart_cache=None ,sort_names=None ,validate_merged_areas=None ,merge_areas=None ,sort_external_names=None ,check_excel_restriction=None ,update_smart_art=None ,encrypt_document_properties=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        SqlScriptSaveOptions - a model defined in Swagger
        """
        self.container['check_if_table_exists'] = None 
        self.container['column_type_map'] = None 
        self.container['check_all_data_for_column_type'] = None 
        self.container['add_blank_line_between_rows'] = None 
        self.container['separator'] = None 
        self.container['operator_type'] = None 
        self.container['primary_key'] = None 
        self.container['create_table'] = None 
        self.container['id_name'] = None 
        self.container['start_id'] = None 
        self.container['table_name'] = None 
        self.container['export_as_string'] = None 
        self.container['export_area'] = None 
        self.container['has_header_row'] = None 
        self.container['save_format'] = None 
        self.container['cached_file_folder'] = None 
        self.container['clear_data'] = None 
        self.container['create_directory'] = None 
        self.container['enable_http_compression'] = None 
        self.container['refresh_chart_cache'] = None 
        self.container['sort_names'] = None 
        self.container['validate_merged_areas'] = None 
        self.container['merge_areas'] = None 
        self.container['sort_external_names'] = None 
        self.container['check_excel_restriction'] = None 
        self.container['update_smart_art'] = None 
        self.container['encrypt_document_properties'] = None 
        params = locals()
        self.check_if_table_exists = check_if_table_exists
        if 'check_if_table_exists' in params:
            self.check_if_table_exists = params["check_if_table_exists"]


             
        self.column_type_map = column_type_map
        if 'column_type_map' in params:
            self.column_type_map = params["column_type_map"]


             
        self.check_all_data_for_column_type = check_all_data_for_column_type
        if 'check_all_data_for_column_type' in params:
            self.check_all_data_for_column_type = params["check_all_data_for_column_type"]


             
        self.add_blank_line_between_rows = add_blank_line_between_rows
        if 'add_blank_line_between_rows' in params:
            self.add_blank_line_between_rows = params["add_blank_line_between_rows"]


             
        self.separator = separator
        if 'separator' in params:
            self.separator = params["separator"]


             
        self.operator_type = operator_type
        if 'operator_type' in params:
            self.operator_type = params["operator_type"]


             
        self.primary_key = primary_key
        if 'primary_key' in params:
            self.primary_key = params["primary_key"]


             
        self.create_table = create_table
        if 'create_table' in params:
            self.create_table = params["create_table"]


             
        self.id_name = id_name
        if 'id_name' in params:
            self.id_name = params["id_name"]


             
        self.start_id = start_id
        if 'start_id' in params:
            self.start_id = params["start_id"]


             
        self.table_name = table_name
        if 'table_name' in params:
            self.table_name = params["table_name"]


             
        self.export_as_string = export_as_string
        if 'export_as_string' in params:
            self.export_as_string = params["export_as_string"]


             
        self.export_area = export_area
        if 'export_area' in params:
            self.export_area = params["export_area"]


             
        self.has_header_row = has_header_row
        if 'has_header_row' in params:
            self.has_header_row = params["has_header_row"]


             
        self.save_format = save_format
        if 'save_format' in params:
            self.save_format = params["save_format"]


             
        self.cached_file_folder = cached_file_folder
        if 'cached_file_folder' in params:
            self.cached_file_folder = params["cached_file_folder"]


             
        self.clear_data = clear_data
        if 'clear_data' in params:
            self.clear_data = params["clear_data"]


             
        self.create_directory = create_directory
        if 'create_directory' in params:
            self.create_directory = params["create_directory"]


             
        self.enable_http_compression = enable_http_compression
        if 'enable_http_compression' in params:
            self.enable_http_compression = params["enable_http_compression"]


             
        self.refresh_chart_cache = refresh_chart_cache
        if 'refresh_chart_cache' in params:
            self.refresh_chart_cache = params["refresh_chart_cache"]


             
        self.sort_names = sort_names
        if 'sort_names' in params:
            self.sort_names = params["sort_names"]


             
        self.validate_merged_areas = validate_merged_areas
        if 'validate_merged_areas' in params:
            self.validate_merged_areas = params["validate_merged_areas"]


             
        self.merge_areas = merge_areas
        if 'merge_areas' in params:
            self.merge_areas = params["merge_areas"]


             
        self.sort_external_names = sort_external_names
        if 'sort_external_names' in params:
            self.sort_external_names = params["sort_external_names"]


             
        self.check_excel_restriction = check_excel_restriction
        if 'check_excel_restriction' in params:
            self.check_excel_restriction = params["check_excel_restriction"]


             
        self.update_smart_art = update_smart_art
        if 'update_smart_art' in params:
            self.update_smart_art = params["update_smart_art"]


             
        self.encrypt_document_properties = encrypt_document_properties
        if 'encrypt_document_properties' in params:
            self.encrypt_document_properties = params["encrypt_document_properties"]


             

    @property
    def check_if_table_exists(self):
        return self.container['check_if_table_exists']

    @check_if_table_exists.setter
    def check_if_table_exists(self, check_if_table_exists):
        self.container['check_if_table_exists'] = check_if_table_exists 
    @property
    def column_type_map(self):
        return self.container['column_type_map']

    @column_type_map.setter
    def column_type_map(self, column_type_map):
        self.container['column_type_map'] = column_type_map 
    @property
    def check_all_data_for_column_type(self):
        return self.container['check_all_data_for_column_type']

    @check_all_data_for_column_type.setter
    def check_all_data_for_column_type(self, check_all_data_for_column_type):
        self.container['check_all_data_for_column_type'] = check_all_data_for_column_type 
    @property
    def add_blank_line_between_rows(self):
        return self.container['add_blank_line_between_rows']

    @add_blank_line_between_rows.setter
    def add_blank_line_between_rows(self, add_blank_line_between_rows):
        self.container['add_blank_line_between_rows'] = add_blank_line_between_rows 
    @property
    def separator(self):
        return self.container['separator']

    @separator.setter
    def separator(self, separator):
        self.container['separator'] = separator 
    @property
    def operator_type(self):
        return self.container['operator_type']

    @operator_type.setter
    def operator_type(self, operator_type):
        self.container['operator_type'] = operator_type 
    @property
    def primary_key(self):
        return self.container['primary_key']

    @primary_key.setter
    def primary_key(self, primary_key):
        self.container['primary_key'] = primary_key 
    @property
    def create_table(self):
        return self.container['create_table']

    @create_table.setter
    def create_table(self, create_table):
        self.container['create_table'] = create_table 
    @property
    def id_name(self):
        return self.container['id_name']

    @id_name.setter
    def id_name(self, id_name):
        self.container['id_name'] = id_name 
    @property
    def start_id(self):
        return self.container['start_id']

    @start_id.setter
    def start_id(self, start_id):
        self.container['start_id'] = start_id 
    @property
    def table_name(self):
        return self.container['table_name']

    @table_name.setter
    def table_name(self, table_name):
        self.container['table_name'] = table_name 
    @property
    def export_as_string(self):
        return self.container['export_as_string']

    @export_as_string.setter
    def export_as_string(self, export_as_string):
        self.container['export_as_string'] = export_as_string 
    @property
    def export_area(self):
        return self.container['export_area']

    @export_area.setter
    def export_area(self, export_area):
        self.container['export_area'] = export_area 
    @property
    def has_header_row(self):
        return self.container['has_header_row']

    @has_header_row.setter
    def has_header_row(self, has_header_row):
        self.container['has_header_row'] = has_header_row 
    @property
    def save_format(self):
        return self.container['save_format']

    @save_format.setter
    def save_format(self, save_format):
        self.container['save_format'] = save_format 
    @property
    def cached_file_folder(self):
        return self.container['cached_file_folder']

    @cached_file_folder.setter
    def cached_file_folder(self, cached_file_folder):
        self.container['cached_file_folder'] = cached_file_folder 
    @property
    def clear_data(self):
        return self.container['clear_data']

    @clear_data.setter
    def clear_data(self, clear_data):
        self.container['clear_data'] = clear_data 
    @property
    def create_directory(self):
        return self.container['create_directory']

    @create_directory.setter
    def create_directory(self, create_directory):
        self.container['create_directory'] = create_directory 
    @property
    def enable_http_compression(self):
        return self.container['enable_http_compression']

    @enable_http_compression.setter
    def enable_http_compression(self, enable_http_compression):
        self.container['enable_http_compression'] = enable_http_compression 
    @property
    def refresh_chart_cache(self):
        return self.container['refresh_chart_cache']

    @refresh_chart_cache.setter
    def refresh_chart_cache(self, refresh_chart_cache):
        self.container['refresh_chart_cache'] = refresh_chart_cache 
    @property
    def sort_names(self):
        return self.container['sort_names']

    @sort_names.setter
    def sort_names(self, sort_names):
        self.container['sort_names'] = sort_names 
    @property
    def validate_merged_areas(self):
        return self.container['validate_merged_areas']

    @validate_merged_areas.setter
    def validate_merged_areas(self, validate_merged_areas):
        self.container['validate_merged_areas'] = validate_merged_areas 
    @property
    def merge_areas(self):
        return self.container['merge_areas']

    @merge_areas.setter
    def merge_areas(self, merge_areas):
        self.container['merge_areas'] = merge_areas 
    @property
    def sort_external_names(self):
        return self.container['sort_external_names']

    @sort_external_names.setter
    def sort_external_names(self, sort_external_names):
        self.container['sort_external_names'] = sort_external_names 
    @property
    def check_excel_restriction(self):
        return self.container['check_excel_restriction']

    @check_excel_restriction.setter
    def check_excel_restriction(self, check_excel_restriction):
        self.container['check_excel_restriction'] = check_excel_restriction 
    @property
    def update_smart_art(self):
        return self.container['update_smart_art']

    @update_smart_art.setter
    def update_smart_art(self, update_smart_art):
        self.container['update_smart_art'] = update_smart_art 
    @property
    def encrypt_document_properties(self):
        return self.container['encrypt_document_properties']

    @encrypt_document_properties.setter
    def encrypt_document_properties(self, encrypt_document_properties):
        self.container['encrypt_document_properties'] = encrypt_document_properties 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SqlScriptSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    