# coding: utf-8
"""
<copyright company="Aspose" file="TilePicOptionpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class TilePicOption(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'offset_x' : 'float',
        'offset_y' : 'float',
        'scale_x' : 'float',
        'scale_y' : 'float',
        'alignment_type' : 'str',
        'mirror_type' : 'str'
    }

    attribute_map = {
        'offset_x' : 'OffsetX' ,
        'offset_y' : 'OffsetY' ,
        'scale_x' : 'ScaleX' ,
        'scale_y' : 'ScaleY' ,
        'alignment_type' : 'AlignmentType' ,
        'mirror_type' : 'MirrorType' 
    }

    @staticmethod
    def get_swagger_types():
        return TilePicOption.swagger_types

    @staticmethod
    def get_attribute_map():
        return TilePicOption.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,offset_x=None ,offset_y=None ,scale_x=None ,scale_y=None ,alignment_type=None ,mirror_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        TilePicOption - a model defined in Swagger
        """
        self.container['offset_x'] = None 
        self.container['offset_y'] = None 
        self.container['scale_x'] = None 
        self.container['scale_y'] = None 
        self.container['alignment_type'] = None 
        self.container['mirror_type'] = None 
        params = locals()
        self.offset_x = offset_x
        if 'offset_x' in params:
            self.offset_x = params["offset_x"]


             
        self.offset_y = offset_y
        if 'offset_y' in params:
            self.offset_y = params["offset_y"]


             
        self.scale_x = scale_x
        if 'scale_x' in params:
            self.scale_x = params["scale_x"]


             
        self.scale_y = scale_y
        if 'scale_y' in params:
            self.scale_y = params["scale_y"]


             
        self.alignment_type = alignment_type
        if 'alignment_type' in params:
            self.alignment_type = params["alignment_type"]


             
        self.mirror_type = mirror_type
        if 'mirror_type' in params:
            self.mirror_type = params["mirror_type"]


             

    @property
    def offset_x(self):
        return self.container['offset_x']

    @offset_x.setter
    def offset_x(self, offset_x):
        self.container['offset_x'] = offset_x 
    @property
    def offset_y(self):
        return self.container['offset_y']

    @offset_y.setter
    def offset_y(self, offset_y):
        self.container['offset_y'] = offset_y 
    @property
    def scale_x(self):
        return self.container['scale_x']

    @scale_x.setter
    def scale_x(self, scale_x):
        self.container['scale_x'] = scale_x 
    @property
    def scale_y(self):
        return self.container['scale_y']

    @scale_y.setter
    def scale_y(self, scale_y):
        self.container['scale_y'] = scale_y 
    @property
    def alignment_type(self):
        return self.container['alignment_type']

    @alignment_type.setter
    def alignment_type(self, alignment_type):
        self.container['alignment_type'] = alignment_type 
    @property
    def mirror_type(self):
        return self.container['mirror_type']

    @mirror_type.setter
    def mirror_type(self, mirror_type):
        self.container['mirror_type'] = mirror_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TilePicOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    