# coding: utf-8
"""
<copyright company="Aspose" file="Workbookpy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Workbook(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'file_name' : 'str',
        'links' : 'list[Link]',
        'worksheets' : 'LinkElement',
        'default_style' : 'LinkElement',
        'document_properties' : 'LinkElement',
        'names' : 'LinkElement',
        'settings' : 'LinkElement',
        'is_write_protected' : 'str',
        'is_protected' : 'str',
        'is_encryption' : 'str',
        'password' : 'str'
    }

    attribute_map = {
        'file_name' : 'FileName' ,
        'links' : 'Links' ,
        'worksheets' : 'Worksheets' ,
        'default_style' : 'DefaultStyle' ,
        'document_properties' : 'DocumentProperties' ,
        'names' : 'Names' ,
        'settings' : 'Settings' ,
        'is_write_protected' : 'IsWriteProtected' ,
        'is_protected' : 'IsProtected' ,
        'is_encryption' : 'IsEncryption' ,
        'password' : 'Password' 
    }

    @staticmethod
    def get_swagger_types():
        return Workbook.swagger_types

    @staticmethod
    def get_attribute_map():
        return Workbook.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,file_name=None ,links=None ,worksheets=None ,default_style=None ,document_properties=None ,names=None ,settings=None ,is_write_protected=None ,is_protected=None ,is_encryption=None ,password=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Workbook - a model defined in Swagger
        """
        self.container['file_name'] = None 
        self.container['links'] = None 
        self.container['worksheets'] = None 
        self.container['default_style'] = None 
        self.container['document_properties'] = None 
        self.container['names'] = None 
        self.container['settings'] = None 
        self.container['is_write_protected'] = None 
        self.container['is_protected'] = None 
        self.container['is_encryption'] = None 
        self.container['password'] = None 
        params = locals()
        self.file_name = file_name
        if 'file_name' in params:
            self.file_name = params["file_name"]


             
        self.links = links
        if 'links' in params:
            self.links = params["links"]


             
        self.worksheets = worksheets
        if 'worksheets' in params:
            self.worksheets = params["worksheets"]


             
        self.default_style = default_style
        if 'default_style' in params:
            self.default_style = params["default_style"]


             
        self.document_properties = document_properties
        if 'document_properties' in params:
            self.document_properties = params["document_properties"]


             
        self.names = names
        if 'names' in params:
            self.names = params["names"]


             
        self.settings = settings
        if 'settings' in params:
            self.settings = params["settings"]


             
        self.is_write_protected = is_write_protected
        if 'is_write_protected' in params:
            self.is_write_protected = params["is_write_protected"]


             
        self.is_protected = is_protected
        if 'is_protected' in params:
            self.is_protected = params["is_protected"]


             
        self.is_encryption = is_encryption
        if 'is_encryption' in params:
            self.is_encryption = params["is_encryption"]


             
        self.password = password
        if 'password' in params:
            self.password = params["password"]


             

    @property
    def file_name(self):
        return self.container['file_name']

    @file_name.setter
    def file_name(self, file_name):
        self.container['file_name'] = file_name 
    @property
    def links(self):
        return self.container['links']

    @links.setter
    def links(self, links):
        self.container['links'] = links 
    @property
    def worksheets(self):
        return self.container['worksheets']

    @worksheets.setter
    def worksheets(self, worksheets):
        self.container['worksheets'] = worksheets 
    @property
    def default_style(self):
        return self.container['default_style']

    @default_style.setter
    def default_style(self, default_style):
        self.container['default_style'] = default_style 
    @property
    def document_properties(self):
        return self.container['document_properties']

    @document_properties.setter
    def document_properties(self, document_properties):
        self.container['document_properties'] = document_properties 
    @property
    def names(self):
        return self.container['names']

    @names.setter
    def names(self, names):
        self.container['names'] = names 
    @property
    def settings(self):
        return self.container['settings']

    @settings.setter
    def settings(self, settings):
        self.container['settings'] = settings 
    @property
    def is_write_protected(self):
        return self.container['is_write_protected']

    @is_write_protected.setter
    def is_write_protected(self, is_write_protected):
        self.container['is_write_protected'] = is_write_protected 
    @property
    def is_protected(self):
        return self.container['is_protected']

    @is_protected.setter
    def is_protected(self, is_protected):
        self.container['is_protected'] = is_protected 
    @property
    def is_encryption(self):
        return self.container['is_encryption']

    @is_encryption.setter
    def is_encryption(self, is_encryption):
        self.container['is_encryption'] = is_encryption 
    @property
    def password(self):
        return self.container['password']

    @password.setter
    def password(self, password):
        self.container['password'] = password 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Workbook):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    