# coding: utf-8
"""
<copyright company="Aspose" file="XmlSaveOptionspy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class XmlSaveOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'sheet_indexes' : 'list[int]',
        'export_area' : 'CellArea',
        'has_header_row' : 'bool',
        'xml_map_name' : 'str',
        'sheet_name_as_element_name' : 'bool',
        'data_as_attribute' : 'bool',
        'save_format' : 'str',
        'cached_file_folder' : 'str',
        'clear_data' : 'bool',
        'create_directory' : 'bool',
        'enable_http_compression' : 'bool',
        'refresh_chart_cache' : 'bool',
        'sort_names' : 'bool',
        'validate_merged_areas' : 'bool',
        'merge_areas' : 'bool',
        'sort_external_names' : 'bool',
        'check_excel_restriction' : 'bool',
        'update_smart_art' : 'bool',
        'encrypt_document_properties' : 'bool'
    }

    attribute_map = {
        'sheet_indexes' : 'SheetIndexes' ,
        'export_area' : 'ExportArea' ,
        'has_header_row' : 'HasHeaderRow' ,
        'xml_map_name' : 'XmlMapName' ,
        'sheet_name_as_element_name' : 'SheetNameAsElementName' ,
        'data_as_attribute' : 'DataAsAttribute' ,
        'save_format' : 'SaveFormat' ,
        'cached_file_folder' : 'CachedFileFolder' ,
        'clear_data' : 'ClearData' ,
        'create_directory' : 'CreateDirectory' ,
        'enable_http_compression' : 'EnableHTTPCompression' ,
        'refresh_chart_cache' : 'RefreshChartCache' ,
        'sort_names' : 'SortNames' ,
        'validate_merged_areas' : 'ValidateMergedAreas' ,
        'merge_areas' : 'MergeAreas' ,
        'sort_external_names' : 'SortExternalNames' ,
        'check_excel_restriction' : 'CheckExcelRestriction' ,
        'update_smart_art' : 'UpdateSmartArt' ,
        'encrypt_document_properties' : 'EncryptDocumentProperties' 
    }

    @staticmethod
    def get_swagger_types():
        return XmlSaveOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return XmlSaveOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,sheet_indexes=None ,export_area=None ,has_header_row=None ,xml_map_name=None ,sheet_name_as_element_name=None ,data_as_attribute=None ,save_format=None ,cached_file_folder=None ,clear_data=None ,create_directory=None ,enable_http_compression=None ,refresh_chart_cache=None ,sort_names=None ,validate_merged_areas=None ,merge_areas=None ,sort_external_names=None ,check_excel_restriction=None ,update_smart_art=None ,encrypt_document_properties=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        XmlSaveOptions - a model defined in Swagger
        """
        self.container['sheet_indexes'] = None 
        self.container['export_area'] = None 
        self.container['has_header_row'] = None 
        self.container['xml_map_name'] = None 
        self.container['sheet_name_as_element_name'] = None 
        self.container['data_as_attribute'] = None 
        self.container['save_format'] = None 
        self.container['cached_file_folder'] = None 
        self.container['clear_data'] = None 
        self.container['create_directory'] = None 
        self.container['enable_http_compression'] = None 
        self.container['refresh_chart_cache'] = None 
        self.container['sort_names'] = None 
        self.container['validate_merged_areas'] = None 
        self.container['merge_areas'] = None 
        self.container['sort_external_names'] = None 
        self.container['check_excel_restriction'] = None 
        self.container['update_smart_art'] = None 
        self.container['encrypt_document_properties'] = None 
        params = locals()
        self.sheet_indexes = sheet_indexes
        if 'sheet_indexes' in params:
            self.sheet_indexes = params["sheet_indexes"]


             
        self.export_area = export_area
        if 'export_area' in params:
            self.export_area = params["export_area"]


             
        self.has_header_row = has_header_row
        if 'has_header_row' in params:
            self.has_header_row = params["has_header_row"]


             
        self.xml_map_name = xml_map_name
        if 'xml_map_name' in params:
            self.xml_map_name = params["xml_map_name"]


             
        self.sheet_name_as_element_name = sheet_name_as_element_name
        if 'sheet_name_as_element_name' in params:
            self.sheet_name_as_element_name = params["sheet_name_as_element_name"]


             
        self.data_as_attribute = data_as_attribute
        if 'data_as_attribute' in params:
            self.data_as_attribute = params["data_as_attribute"]


             
        self.save_format = save_format
        if 'save_format' in params:
            self.save_format = params["save_format"]


             
        self.cached_file_folder = cached_file_folder
        if 'cached_file_folder' in params:
            self.cached_file_folder = params["cached_file_folder"]


             
        self.clear_data = clear_data
        if 'clear_data' in params:
            self.clear_data = params["clear_data"]


             
        self.create_directory = create_directory
        if 'create_directory' in params:
            self.create_directory = params["create_directory"]


             
        self.enable_http_compression = enable_http_compression
        if 'enable_http_compression' in params:
            self.enable_http_compression = params["enable_http_compression"]


             
        self.refresh_chart_cache = refresh_chart_cache
        if 'refresh_chart_cache' in params:
            self.refresh_chart_cache = params["refresh_chart_cache"]


             
        self.sort_names = sort_names
        if 'sort_names' in params:
            self.sort_names = params["sort_names"]


             
        self.validate_merged_areas = validate_merged_areas
        if 'validate_merged_areas' in params:
            self.validate_merged_areas = params["validate_merged_areas"]


             
        self.merge_areas = merge_areas
        if 'merge_areas' in params:
            self.merge_areas = params["merge_areas"]


             
        self.sort_external_names = sort_external_names
        if 'sort_external_names' in params:
            self.sort_external_names = params["sort_external_names"]


             
        self.check_excel_restriction = check_excel_restriction
        if 'check_excel_restriction' in params:
            self.check_excel_restriction = params["check_excel_restriction"]


             
        self.update_smart_art = update_smart_art
        if 'update_smart_art' in params:
            self.update_smart_art = params["update_smart_art"]


             
        self.encrypt_document_properties = encrypt_document_properties
        if 'encrypt_document_properties' in params:
            self.encrypt_document_properties = params["encrypt_document_properties"]


             

    @property
    def sheet_indexes(self):
        return self.container['sheet_indexes']

    @sheet_indexes.setter
    def sheet_indexes(self, sheet_indexes):
        self.container['sheet_indexes'] = sheet_indexes 
    @property
    def export_area(self):
        return self.container['export_area']

    @export_area.setter
    def export_area(self, export_area):
        self.container['export_area'] = export_area 
    @property
    def has_header_row(self):
        return self.container['has_header_row']

    @has_header_row.setter
    def has_header_row(self, has_header_row):
        self.container['has_header_row'] = has_header_row 
    @property
    def xml_map_name(self):
        return self.container['xml_map_name']

    @xml_map_name.setter
    def xml_map_name(self, xml_map_name):
        self.container['xml_map_name'] = xml_map_name 
    @property
    def sheet_name_as_element_name(self):
        return self.container['sheet_name_as_element_name']

    @sheet_name_as_element_name.setter
    def sheet_name_as_element_name(self, sheet_name_as_element_name):
        self.container['sheet_name_as_element_name'] = sheet_name_as_element_name 
    @property
    def data_as_attribute(self):
        return self.container['data_as_attribute']

    @data_as_attribute.setter
    def data_as_attribute(self, data_as_attribute):
        self.container['data_as_attribute'] = data_as_attribute 
    @property
    def save_format(self):
        return self.container['save_format']

    @save_format.setter
    def save_format(self, save_format):
        self.container['save_format'] = save_format 
    @property
    def cached_file_folder(self):
        return self.container['cached_file_folder']

    @cached_file_folder.setter
    def cached_file_folder(self, cached_file_folder):
        self.container['cached_file_folder'] = cached_file_folder 
    @property
    def clear_data(self):
        return self.container['clear_data']

    @clear_data.setter
    def clear_data(self, clear_data):
        self.container['clear_data'] = clear_data 
    @property
    def create_directory(self):
        return self.container['create_directory']

    @create_directory.setter
    def create_directory(self, create_directory):
        self.container['create_directory'] = create_directory 
    @property
    def enable_http_compression(self):
        return self.container['enable_http_compression']

    @enable_http_compression.setter
    def enable_http_compression(self, enable_http_compression):
        self.container['enable_http_compression'] = enable_http_compression 
    @property
    def refresh_chart_cache(self):
        return self.container['refresh_chart_cache']

    @refresh_chart_cache.setter
    def refresh_chart_cache(self, refresh_chart_cache):
        self.container['refresh_chart_cache'] = refresh_chart_cache 
    @property
    def sort_names(self):
        return self.container['sort_names']

    @sort_names.setter
    def sort_names(self, sort_names):
        self.container['sort_names'] = sort_names 
    @property
    def validate_merged_areas(self):
        return self.container['validate_merged_areas']

    @validate_merged_areas.setter
    def validate_merged_areas(self, validate_merged_areas):
        self.container['validate_merged_areas'] = validate_merged_areas 
    @property
    def merge_areas(self):
        return self.container['merge_areas']

    @merge_areas.setter
    def merge_areas(self, merge_areas):
        self.container['merge_areas'] = merge_areas 
    @property
    def sort_external_names(self):
        return self.container['sort_external_names']

    @sort_external_names.setter
    def sort_external_names(self, sort_external_names):
        self.container['sort_external_names'] = sort_external_names 
    @property
    def check_excel_restriction(self):
        return self.container['check_excel_restriction']

    @check_excel_restriction.setter
    def check_excel_restriction(self, check_excel_restriction):
        self.container['check_excel_restriction'] = check_excel_restriction 
    @property
    def update_smart_art(self):
        return self.container['update_smart_art']

    @update_smart_art.setter
    def update_smart_art(self, update_smart_art):
        self.container['update_smart_art'] = update_smart_art 
    @property
    def encrypt_document_properties(self):
        return self.container['encrypt_document_properties']

    @encrypt_document_properties.setter
    def encrypt_document_properties(self, encrypt_document_properties):
        self.container['encrypt_document_properties'] = encrypt_document_properties 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, XmlSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    