# coding: utf-8
"""
<copyright company="Aspose" file="ImportDataIntoSpreadsheetRequest.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

import json
import os

from six import iteritems
from asposecellscloud import *
from asposecellscloud.models import *
from asposecellscloud.requests import *
from six.moves.urllib.parse import quote

class ImportDataIntoSpreadsheetRequest(object):

    def __init__(self , datafile ,spreadsheet ,worksheet ,startcell ,insert =None ,convert_numeric_data =None ,splitter =None ,out_path =None ,out_storage_name =None ,fonts_location =None ,region =None ,password =None ):
        self.datafile = datafile 
        self.spreadsheet = spreadsheet 
        self.worksheet = worksheet 
        self.startcell = startcell 
        self.insert = insert 
        self.convert_numeric_data = convert_numeric_data 
        self.splitter = splitter 
        self.out_path = out_path 
        self.out_storage_name = out_storage_name 
        self.fonts_location = fonts_location 
        self.region = region 
        self.password = password 
    def create_http_request(self, api_client):

        # verify the required parameter 'datafile' is set
        if self.datafile is None:
            raise ValueError("Missing the required parameter `datafile` when calling `import_data_into_spreadsheet`")


        # verify the required parameter 'spreadsheet' is set
        if self.spreadsheet is None:
            raise ValueError("Missing the required parameter `spreadsheet` when calling `import_data_into_spreadsheet`")


        # verify the required parameter 'worksheet' is set
        if self.worksheet is None:
            raise ValueError("Missing the required parameter `worksheet` when calling `import_data_into_spreadsheet`")


        # verify the required parameter 'startcell' is set
        if self.startcell is None:
            raise ValueError("Missing the required parameter `startcell` when calling `import_data_into_spreadsheet`")


        collection_formats = {}

        path_params = {}
        query_params = []
        if self.worksheet is not None:
            query_params.append(('worksheet',self.worksheet ))
        if self.startcell is not None:
            query_params.append(('startcell',self.startcell ))
        if self.insert is not None:
            query_params.append(('insert',self.insert ))
        if self.convert_numeric_data is not None:
            query_params.append(('convertNumericData',self.convert_numeric_data ))
        if self.splitter is not None:
            query_params.append(('splitter',self.splitter ))
        if self.out_path is not None:
            query_params.append(('outPath',self.out_path ))
        if self.out_storage_name is not None:
            query_params.append(('outStorageName',self.out_storage_name ))
        if self.fonts_location is not None:
            query_params.append(('fontsLocation',self.fonts_location ))
        if self.region is not None:
            query_params.append(('region',self.region ))
        if self.password is not None:
            query_params.append(('password',self.password ))

        header_params = {}
        header_params['x-aspose-client'] = 'python sdk';
        header_params['x-aspose-client-version'] = '25.10';

        form_params = []
        local_var_files = {}
        if self.datafile is not None:            
            if isinstance(self.datafile,dict):
                for filename , filecontext in  self.datafile.items():
                    local_var_files[filename] = filecontext
            else:
                if isinstance(self.datafile,bytes):
                    local_var_files['File'] = self.datafile
                else:
                    local_var_files[os.path.basename( self.datafile)] = self.datafile   
        if self.spreadsheet is not None:            
            if isinstance(self.spreadsheet,dict):
                for filename , filecontext in  self.spreadsheet.items():
                    local_var_files[filename] = filecontext
            else:
                if isinstance(self.spreadsheet,bytes):
                    local_var_files['File'] = self.spreadsheet
                else:
                    local_var_files[os.path.basename( self.spreadsheet)] = self.spreadsheet   

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = []
        resource_path =  "v4.0/cells/import/data"
        # path parameters
        if path_params:
            path_params = api_client.sanitize_for_serialization(path_params)
            path_params = api_client.parameters_to_tuples(path_params, collection_formats)
            for k, v in path_params:
                # specified safe chars, encode everything
                resource_path = resource_path.replace('{%s}' % k, quote(str(v), safe='/'))
        return {
                "method": "PUT",
                "path":resource_path,
                "query_params": query_params,
                "header_params": header_params,
                "form_params": form_params,
                "files":local_var_files,
                "auth_settings":auth_settings,
                "body": body_params,
                "collection_formats": collection_formats,
                "response_type": 'file'  
        }

