"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const YAML = require("yaml");
const amplify_generated_1 = require("./amplify.generated");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * An Amplify Console application
 */
class App extends core_1.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = (_c = props.sourceCodeProvider) === null || _c === void 0 ? void 0 : _c.bind(this);
        const app = new amplify_generated_1.CfnApp(this, 'Resource', {
            accessToken: (_d = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.accessToken) === null || _d === void 0 ? void 0 : _d.unsafeUnwrap(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: (_e = props.autoBranchCreation.autoBuild) !== null && _e !== void 0 ? _e : true,
                environmentVariables: core_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: (_f = props.autoBranchCreation.pullRequestPreview) !== null && _f !== void 0 ? _f : true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: core_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: core_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: (_g = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.oauthToken) === null || _g === void 0 ? void 0 : _g.unsafeUnwrap(),
            repository: sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * Import an existing application
     */
    static fromAppId(scope, id, appId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds a custom rewrite/redirect rule to this application
     */
    addCustomRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_CustomRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCustomRule);
            }
            throw error;
        }
        this.customRules.push(rule);
        return this;
    }
    /**
     * Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * Adds a branch to this application
     */
    addBranch(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_BranchOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addBranch);
            }
            throw error;
        }
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * Adds a domain to this application
     */
    addDomain(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_DomainOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDomain);
            }
            throw error;
        }
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify.App", version: "1.156.1" };
/**
 * The status code for a URL rewrite or redirect rule.
 */
var RedirectStatus;
(function (RedirectStatus) {
    /**
     * Rewrite (200)
     */
    RedirectStatus["REWRITE"] = "200";
    /**
     * Permanent redirect (301)
     */
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    /**
     * Temporary redirect (302)
     */
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    /**
     * Not found (404)
     */
    RedirectStatus["NOT_FOUND"] = "404";
    /**
     * Not found rewrite (404)
     */
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus = exports.RedirectStatus || (exports.RedirectStatus = {}));
/**
 * Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 */
class CustomRule {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_CustomRuleOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify.CustomRule", version: "1.156.1" };
/**
 * Sets up a 200 rewrite for all paths to `index.html` except for path
 * containing a file extension.
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
function renderCustomResponseHeaders(customHeaders) {
    const modifiedHeaders = customHeaders.map(customHeader => ({
        ...customHeader,
        headers: Object.entries(customHeader.headers).map(([key, value]) => ({ key, value })),
    }));
    const customHeadersObject = { customHeaders: modifiedHeaders };
    return YAML.stringify(customHeadersObject);
}
//# sourceMappingURL=data:application/json;base64,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