"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAuth = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
/**
 * Basic Auth configuration
 */
class BasicAuth {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_BasicAuthProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Creates a Basic Auth configuration from a username and a password
     *
     * @param username The username
     * @param password The password
     */
    static fromCredentials(username, password) {
        return new BasicAuth({ username, password });
    }
    /**
     * Creates a Basic Auth configuration with a password generated in Secrets
     * Manager.
     *
     * @param username The username
     * @param encryptionKey The encryption key to use to encrypt the password in
     * Secrets Manager
     */
    static fromGeneratedPassword(username, encryptionKey) {
        return new BasicAuth({ username, encryptionKey });
    }
    /**
     * Binds this Basic Auth configuration to an App
     */
    bind(scope, id) {
        const config = {
            enableBasicAuth: true,
            username: this.props.username,
        };
        if (this.props.password) {
            return {
                ...config,
                password: this.props.password.unsafeUnwrap(),
            };
        }
        const secret = new secretsmanager.Secret(scope, id, {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: this.props.username }),
                generateStringKey: 'password',
            },
        });
        return {
            ...config,
            password: secret.secretValueFromJson('password').unsafeUnwrap(),
        };
    }
}
exports.BasicAuth = BasicAuth;
_a = JSII_RTTI_SYMBOL_1;
BasicAuth[_a] = { fqn: "@aws-cdk/aws-amplify.BasicAuth", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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