"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
const amplify_generated_1 = require("./amplify.generated");
const utils_1 = require("./utils");
/**
 * An Amplify Console branch
 */
class Branch extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_BranchProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new amplify_generated_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: (_b = props.autoBuild) !== null && _b !== void 0 ? _b : true,
            enablePullRequestPreview: (_c = props.pullRequestPreview) !== null && _c !== void 0 ? _c : true,
            environmentVariables: core_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
            enablePerformanceMode: props.performanceMode,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
        if (props.asset) {
            new core_1.CustomResource(this, 'DeploymentResource', {
                serviceToken: AmplifyAssetDeploymentProvider.getOrCreate(this),
                resourceType: 'Custom::AmplifyAssetDeployment',
                properties: {
                    AppId: props.app.appId,
                    BranchName: branchName,
                    S3ObjectKey: props.asset.s3ObjectKey,
                    S3BucketName: props.asset.s3BucketName,
                },
            });
        }
    }
    /**
     * Import an existing branch
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
_a = JSII_RTTI_SYMBOL_1;
Branch[_a] = { fqn: "@aws-cdk/aws-amplify.Branch", version: "1.156.1" };
class AmplifyAssetDeploymentProvider extends core_1.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        const onEvent = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-on-event', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'onEvent',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        's3:GetObject',
                        's3:GetSignedUrl',
                        'amplify:ListJobs',
                        'amplify:StartDeployment',
                    ],
                }),
            ],
        });
        const isComplete = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-is-complete', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'isComplete',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: ['amplify:GetJob*'],
                }),
            ],
        });
        this.provider = new custom_resources_1.Provider(this, 'amplify-asset-deployment-handler-provider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            totalTimeout: core_1.Duration.minutes(5),
        });
    }
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        var _b;
        const providerId = 'com.amazonaws.cdk.custom-resources.amplify-asset-deployment-provider';
        const stack = core_1.Stack.of(scope);
        const group = (_b = stack.node.tryFindChild(providerId)) !== null && _b !== void 0 ? _b : new AmplifyAssetDeploymentProvider(stack, providerId);
        return group.provider.serviceToken;
    }
}
//# sourceMappingURL=data:application/json;base64,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